/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.jsp.JavaCompiler;
import coldfusion.runtime.Array;
import coldfusion.runtime.ListFunc;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.XmlRpcService;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.ServiceInfo;
import coldfusion.xml.rpc.ServiceInfoGeneratorStrategy;
import coldfusion.xml.rpc.ServiceStubGenerationException;
import coldfusion.xml.rpc.module.Axis2ServiceInfo;
import coldfusion.xml.rpc.module.CFCodeGenerationEngine;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.client.Stub;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.OptionsValidator;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.util.WSDL2JavaOptionsValidator;
import org.w3c.dom.Document;

public class Axis2ServiceInfoGeneratorStrategy
extends ServiceInfoGeneratorStrategy {
    public Axis2ServiceInfoGeneratorStrategy(XmlRpcService service, boolean saveJava) {
        super(service, saveJava);
    }

    public ServiceInfo generateServiceInfo(final String name, final String outputdir, String username, String password, final String wsdl, final Document wsdlDocument, String w2jargs, Map config) {
        ArrayList<String> wsdl2JavaArgs = new ArrayList<String>();
        wsdl2JavaArgs.add("-uri");
        wsdl2JavaArgs.add(wsdl);
        wsdl2JavaArgs.add("-o");
        wsdl2JavaArgs.add(outputdir);
        wsdl2JavaArgs.add("-uw");
        wsdl2JavaArgs.add("-u");
        wsdl2JavaArgs.add("-g");
        final String port = (String)config.get("port");
        if (null != port) {
            wsdl2JavaArgs.add("-pn");
            wsdl2JavaArgs.add(port);
        }
        if (wsdl.endsWith("wsdl2")) {
            wsdl2JavaArgs.add("-wv");
            wsdl2JavaArgs.add("2.0");
        }
        if (w2jargs != null) {
            Array wsdl2JavaArgsFromUser = ListFunc.ListToArray((String)w2jargs, (String)" ");
            try {
                wsdl2JavaArgs.addAll((Collection<String>)wsdl2JavaArgsFromUser);
            }
            catch (Exception e) {
                throw new ServiceInfoGeneratorStrategy.BadWSDL2JavaSwitchException((ServiceInfoGeneratorStrategy)this, e.getMessage(), w2jargs);
            }
        }
        String[] args = new String[wsdl2JavaArgs.size()];
        wsdl2JavaArgs.toArray(args);
        final CommandLineOptionParser commandLineOptionParser = new CommandLineOptionParser(args);
        List invalidOptions = commandLineOptionParser.getInvalidOptions((OptionsValidator)new WSDL2JavaOptionsValidator());
        if (invalidOptions.size() > 0) {
            throw new ServiceInfoGeneratorStrategy.BadWSDL2JavaSwitchException((ServiceInfoGeneratorStrategy)this, "Invalid options specified. " + invalidOptions, w2jargs);
        }
        if (null == System.getSecurityManager()) {
            try {
                this.generateCode(name, wsdl, wsdlDocument, commandLineOptionParser);
            }
            catch (CodeGenerationException e) {
                throw new ServiceStubGenerationException(name, wsdl, (Exception)((Object)e));
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Axis2ServiceInfoGeneratorStrategy.this.generateCode(name, wsdl, wsdlDocument, commandLineOptionParser);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceStubGenerationException(name, wsdl, pex.getException());
        }
        List compiledFileList = null;
        try {
            compiledFileList = (List)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JavaCompiler compiler = new JavaCompiler();
                    compiler.setCompilerSpec(null);
                    if (Axis2ServiceInfoGeneratorStrategy.this.service.getClassPath() != null) {
                        compiler.setClasspath(Axis2ServiceInfoGeneratorStrategy.this.service.getClassPath());
                    }
                    compiler.setOutputDirectory(outputdir);
                    compiler.setSaveJava("true");
                    List fileList = Axis2ServiceInfoGeneratorStrategy.this.getGeneratedFilePathList(outputdir, ".java");
                    compiler.compileClass(fileList, true);
                    if (!Axis2ServiceInfoGeneratorStrategy.this.saveJava) {
                        Iterator it = fileList.iterator();
                        while (it.hasNext()) {
                            File f = new File((String)it.next());
                            f.delete();
                        }
                    }
                    return Axis2ServiceInfoGeneratorStrategy.this.getGeneratedFilePathList(outputdir, ".class");
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
        try {
            final URLClassLoader loader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader parent = Thread.currentThread().getContextClassLoader();
                    if (parent == null) {
                        parent = this.getClass().getClassLoader();
                    }
                    return new URLClassLoader(new URL[]{Utils.getCanonicalFile((String)outputdir).toURL()}, parent);
                }
            });
            final List finalList = compiledFileList;
            return (ServiceInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    boolean found = false;
                    HashMap portMap = new HashMap();
                    int size = finalList.size();
                    int outputDirLength = new File(outputdir).getAbsolutePath().length();
                    for (int i = 0; i < size; ++i) {
                        Class<?> stub;
                        String absoluteFilePath = (String)finalList.get(i);
                        String classname = absoluteFilePath.substring(outputDirLength + 1);
                        if ((classname = classname.replaceAll("[/\\\\]+", ".")).endsWith(".class")) {
                            classname = classname.substring(0, classname.length() - 6);
                        }
                        if (!Stub.class.isAssignableFrom(stub = loader.loadClass(classname))) continue;
                        found = true;
                        portMap.put(port, stub);
                    }
                    Axis2ServiceInfo serviceInfo = new Axis2ServiceInfo(name, portMap, wsdl);
                    if (!found) {
                        throw new ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException(name, wsdl);
                    }
                    return serviceInfo;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (ServiceStubGenerationException ex) {
            throw ex;
        }
        catch (ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
    }

    private void generateCode(String name, String wsdl, Document wsdlDocument, CommandLineOptionParser commandLineOptionParser) throws CodeGenerationException {
        CFCodeGenerationEngine codeGenerationEngine = new CFCodeGenerationEngine(commandLineOptionParser, wsdlDocument);
        List axisServices = codeGenerationEngine.getConfiguration().getAxisServices();
        if (0 == axisServices.size()) {
            throw new ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException(name, wsdl);
        }
        codeGenerationEngine.generate();
    }

    private List getGeneratedFilePathList(String outputdir, String fileType) {
        ArrayList<String> fileList = new ArrayList<String>();
        File outputDir = new File(outputdir);
        if (outputDir.isDirectory()) {
            File[] listFiles;
            for (File file : listFiles = outputDir.listFiles()) {
                if (file.isFile()) {
                    if (!file.getAbsolutePath().endsWith(fileType)) continue;
                    fileList.add(file.getAbsolutePath());
                    continue;
                }
                fileList.addAll(this.getGeneratedFilePathList(file.getAbsolutePath(), fileType));
            }
        }
        return fileList;
    }

    public int getVersion() {
        return 2;
    }
}

