/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.fms;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import coldfusion.eventgateway.GenericGateway;
import coldfusion.eventgateway.Logger;
import coldfusion.eventgateway.fms.FMS2CFTranslator;
import coldfusion.eventgateway.fms.FMSGatewayHelper;
import coldfusion.eventgateway.fms.FMSManager;
import coldfusion.eventgateway.fms.SOEventListener;
import coldfusion.runtime.ApplicationException;
import com.macromedia.fcs.common.SyncInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class FMSGateway
extends GenericGateway
implements SOEventListener {
    private FMSManager manager = null;
    private String gatewayID;
    private String gatewayType = "FMS Gateway";
    private GatewayServices gatewayService;
    private FMSGatewayHelper helper = null;
    private String rtmpURL = null;
    private String sharedObject = null;
    private Properties properties = new Properties();
    private String configFile = null;
    Logger log;

    public FMSGateway(String gatewayID, String configFile) throws Exception {
        super(gatewayID);
        this.gatewayID = gatewayID;
        this.gatewayService = GatewayServices.getGatewayServices();
        this.configFile = configFile;
        this.helper = new FMSGatewayHelper(this);
    }

    public GatewayHelper getHelper() {
        return this.helper;
    }

    public void startGateway() throws Exception {
        this.log = this.gatewayService.getLogger();
        try {
            FileInputStream propsFile = new FileInputStream(this.configFile);
            this.properties.load(propsFile);
            propsFile.close();
            this.loadProperties();
        }
        catch (IOException e) {
            throw new FMSGatewayInitializationException(this.gatewayType, e);
        }
        this.status = 2;
        if (this.rtmpURL == null || this.sharedObject == null || this.rtmpURL.trim().equals("") || this.sharedObject.trim().equals("")) {
            throw new FMSGatewayInvalidConfigException(this.rtmpURL, this.sharedObject);
        }
        if (this.manager == null) {
            this.manager = new FMSManager(this.rtmpURL, this.sharedObject);
        }
        try {
            this.manager.connetToFCS();
            this.manager.addSOEventListener(this);
        }
        catch (Exception e) {
            this.stop();
            throw new FMSGatewayStartException(this.gatewayID, e);
        }
    }

    public void stopGateway() {
        this.status = 4;
        try {
            this.manager.removeSOEventListener(this);
            this.manager.closeConnectionToFCS();
        }
        catch (Exception e) {
            throw new FMSGatewayStopException(this.gatewayID, e);
        }
    }

    private void loadProperties() {
        this.rtmpURL = this.properties.getProperty("rtmpurl");
        this.sharedObject = this.properties.getProperty("sharedobject");
    }

    public String outgoingMessage(CFEvent cfmsg) {
        return "ok";
    }

    protected String[] getListeners() {
        return this.listeners;
    }

    protected GatewayServices getGatewayServices() {
        return this.gatewayService;
    }

    @Override
    public void onSODataChange(SyncInfo syncInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", syncInfo.getName());
        data.put("oldValue", FMS2CFTranslator.translate(syncInfo.getOldValue()));
        data.put("value", this.manager.getSharedObjValue(syncInfo.getName()));
        CFEvent event = new CFEvent(this.gatewayID);
        event.setCfcMethod("onSync");
        event.setData(data);
        event.setGatewayType("FMS");
        event.setOriginatorID("");
        this.sendEvent(event);
    }

    private void sendEvent(CFEvent event) {
        String[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            event.setCfcPath(listeners[i]);
            this.getGatewayServices().addEvent(event);
        }
    }

    public void setSharedObjProperty(String name, Object value) {
        if (this.getStatus() != 2) {
            throw new FMSGatewayNotRunningException(this.gatewayID);
        }
        this.manager.setSharedObjValue(name, value);
    }

    public Object getSharedObjProperty(String name) {
        if (this.getStatus() != 2) {
            throw new FMSGatewayNotRunningException(this.gatewayID);
        }
        Object value = this.manager.getSharedObjValue(name);
        return value == null ? "" : value;
    }

    public class FMSGatewayNotRunningException
    extends ApplicationException {
        public String gatewayid;

        public FMSGatewayNotRunningException(String gatewayid) {
            this.gatewayid = gatewayid;
        }
    }

    public class FMSGatewayStopException
    extends ApplicationException {
        public String gatewayid;

        public FMSGatewayStopException(String gatewayid, Throwable e) {
            super(e);
            this.gatewayid = gatewayid;
        }
    }

    public class FMSGatewayStartException
    extends ApplicationException {
        public String gatewayid;

        public FMSGatewayStartException(String gatewayid, Throwable e) {
            super(e);
            this.gatewayid = gatewayid;
        }
    }

    public class FMSGatewayInvalidConfigException
    extends ApplicationException {
        public String rtmpurl = null;
        public String sharedObject = null;

        public FMSGatewayInvalidConfigException(String rtmpurl, String sharedObject) {
            this.rtmpurl = rtmpurl;
            this.sharedObject = sharedObject;
        }
    }

    public class FMSGatewayInitializationException
    extends ApplicationException {
        public String gatewaytype;
        public String errorMessage;

        public FMSGatewayInitializationException(String gatewaytype, Throwable e) {
            super(e);
            this.gatewaytype = null;
            this.errorMessage = null;
            this.gatewaytype = gatewaytype;
        }
    }
}

