/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debug;

import coldfusion.debug.core.Debugger;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.Table;
import coldfusion.tagext.net.HttpTag;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AMFDebugger
implements Debugger {
    private DebuggingService ds = ServiceFactory.getDebuggingService();
    private Vector events = new Vector();

    public void cfoql(String statement, String type, List lIDs, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(5)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "ObjectQuery");
                event.put("Name", type);
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("Result", lIDs);
                event.put("Datasource", type == null ? "" : type);
                event.put("RowCount", new Integer(lIDs.size()));
                event.put("CachedQuery", new Boolean(false));
                event.put("Body", statement);
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void exception(Throwable t) {
        try {
            if (this.ds.check(8)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "Exception");
                event.put("Name", t instanceof NeoException ? ((NeoException)t).getType() : t.getClass().getName());
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("StackTrace", t);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void executionTime(long startTime, long endTime) {
        try {
            if (this.ds.check(2)) {
                ExceptionInformation st = new ExceptionInformation((Throwable)new Exception());
                Struct event = new Struct();
                event.put("EventType", "ExecutionTime");
                event.put("Name", "Execution Time");
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void http(String url, HttpTag.HttpTagResponse resp, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(200)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "Http");
                event.put("Name", "");
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("URL", url == null ? "" : url);
                event.put("Result", resp);
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void ormSql(String statement, Throwable t) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "ORMSqlQuery");
                event.put("Name", "");
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("Datasource", "");
                event.put("RowCount", "");
                event.put("CachedQuery", new Boolean(false));
                event.put("Body", statement);
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void sql(String statement, String name, Object datasource, Throwable t, long startTime, long endTime) {
        this.sql(statement, name, datasource, new Table(0, 0), t, 0, startTime, endTime, false, new Vector());
    }

    public void sql(String statement, String name, Object datasource, Table result, Throwable t, int count, long startTime, long endTime, boolean cached, Vector params) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "SqlQuery");
                event.put("Name", name);
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("Datasource", datasource == null ? "" : datasource.toString());
                event.put("RowCount", new Integer(count));
                event.put("CachedQuery", new Boolean(cached));
                event.put("Body", statement);
                event.put("StackTrace", st);
                event.put("Attributes", params);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storedproc(String proc, Object dsn, Vector results, Vector params, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(6)) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "StoredProcedure");
                event.put("Name", proc);
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("Result", results);
                event.put("Datasource", dsn == null ? "" : dsn.toString());
                event.put("Attributes", params);
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void template(String child, long startTime, long endTime) {
        this.template(child, new Exception(), startTime, endTime);
    }

    public void template(String child, Throwable t, long startTime, long endTime) {
        try {
            if (this.ds.check(1) && child.toLowerCase().indexOf("/web-inf/cftags/") == -1 && child.toLowerCase().indexOf("/web-inf/exception/") == -1 && child.toLowerCase().indexOf("/web-inf/debug/") == -1 && child.toLowerCase().indexOf("\\web-inf\\cftags\\") == -1 && child.toLowerCase().indexOf("\\web-inf\\exception\\") == -1 && child.toLowerCase().indexOf("\\web-inf\\debug\\") == -1) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "Template");
                event.put("Name", "");
                event.put("StartTime", new Long(startTime));
                event.put("EndTime", new Long(endTime));
                event.put("Template", child);
                event.put("Parent", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("StackTrace", st);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void trace(String priority, String category, String var, String text) {
        this.trace(priority, category, var, text, (Date)new OleDateTime(System.currentTimeMillis()), 0L);
    }

    public void trace(String priority, String category, String var, String text, Date timestamp, long delta) {
        try {
            if (this.ds.check(7)) {
                ExceptionInformation st = new ExceptionInformation((Throwable)new Exception());
                Struct event = new Struct();
                event.put("EventType", "Trace");
                event.put("Name", "");
                event.put("StartTime", new Long(0L));
                event.put("EndTime", new Long(delta));
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("Result", var);
                event.put("Message", text == null ? "" : text);
                event.put("Category", category);
                event.put("Priority", priority);
                event.put("StackTrace", st);
                this.addEvent((Map)event, timestamp);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void unexpected(Throwable t) {
        try {
            if (this.ds.isEnabled()) {
                ExceptionInformation st = new ExceptionInformation(t);
                Struct event = new Struct();
                event.put("EventType", "Unexpected");
                event.put("Name", t instanceof NeoException ? ((NeoException)t).getType() : t.getClass().getName());
                event.put("Template", st.getTemplate());
                event.put("Line", new Integer(st.getLine()));
                event.put("StackTrace", t);
                this.addEvent((Map)event, (Date)new OleDateTime(System.currentTimeMillis()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void userDefined(Map data) {
        try {
            Struct event = new Struct();
            event.put("EventType", data.get("type"));
            event.put("Name", data.get("name"));
            event.put("StartTime", data.get("starttime"));
            event.put("EndTime", data.get("endtime"));
            event.put("Template", data.get("template"));
            event.put("Parent", data.get("parent"));
            event.put("Line", data.get("line"));
            event.put("URL", data.get("url"));
            event.put("Result", data.get("result"));
            event.put("DataSource", data.get("datasource"));
            event.put("RowCount", data.get("rowcount"));
            event.put("CachedQuery", data.get("cachedquery"));
            event.put("Message", data.get("message"));
            event.put("Body", data.get("body"));
            event.put("Category", data.get("category"));
            event.put("Priority", data.get("priority"));
            event.put("Attributes", data.get("attributes"));
            event.put("StackTrace", data.get("stacktrace"));
            this.addEvent((Map)event, (Date)(data.get("timestamp") == null ? new OleDateTime(System.currentTimeMillis()) : (Date)data.get("timestamp")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addEvent(Map event, Date date) {
        event.put("Source", "ColdFusion");
        event.put("Date", date);
        event.put("Time", new Long(date.getTime()));
        this.events.add(event);
    }

    public Object getData() {
        return this.events;
    }
}

