/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.BaseClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.http.Crc32Validation;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.http.AmazonAsyncHttpClient;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.core.internal.http.async.AsyncAfterTransmissionInterceptorCallingResponseHandler;
import software.amazon.awssdk.core.internal.http.async.AsyncResponseHandler;
import software.amazon.awssdk.core.internal.http.async.AsyncStreamingResponseHandler;
import software.amazon.awssdk.core.internal.util.ThrowableUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkProtectedApi
public abstract class BaseAsyncClientHandler
extends BaseClientHandler
implements AsyncClientHandler {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(BaseAsyncClientHandler.class);
    private final SdkClientConfiguration clientConfiguration;
    private final AmazonAsyncHttpClient client;
    private final Function<SdkHttpFullResponse, SdkHttpFullResponse> crc32Validator;

    protected BaseAsyncClientHandler(SdkClientConfiguration clientConfiguration, AmazonAsyncHttpClient client) {
        super(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.client = client;
        this.crc32Validator = response -> Crc32Validation.validate(this.isCalculateCrc32FromCompressedData(), response);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        ExecutionContext executionContext = this.createExecutionContext(executionParams);
        HttpResponseHandler<OutputT> decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), executionContext);
        AsyncResponseHandler<OutputT> asyncResponseHandler = new AsyncResponseHandler<OutputT>(decoratedResponseHandlers, this.crc32Validator, executionContext.executionAttributes());
        return this.doExecute(executionParams, executionContext, asyncResponseHandler);
    }

    @Override
    public <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> CompletableFuture<ReturnT> execute(ClientExecutionParams<InputT, OutputT> executionParams, AsyncResponseTransformer<OutputT, ReturnT> asyncResponseTransformer) {
        AsyncStreamingResponseHandler<OutputT, ReturnT> asyncStreamingResponseHandler = new AsyncStreamingResponseHandler<OutputT, ReturnT>(asyncResponseTransformer);
        CompletableFuture<ReturnT> asyncTransformerFuture = asyncStreamingResponseHandler.prepare();
        ExecutionContext context = this.createExecutionContext(executionParams);
        context.executionAttributes().putAttribute(SdkInternalExecutionAttribute.ASYNC_RESPONSE_TRANSFORMER_FUTURE, asyncTransformerFuture);
        HttpResponseHandler<OutputT> decoratedResponseHandlers = this.decorateResponseHandlers(executionParams.getResponseHandler(), context);
        asyncStreamingResponseHandler.responseHandler(decoratedResponseHandlers);
        return this.doExecute(executionParams, context, asyncStreamingResponseHandler);
    }

    private <InputT extends SdkRequest, OutputT extends SdkResponse, ReturnT> CompletableFuture<ReturnT> doExecute(ClientExecutionParams<InputT, OutputT> executionParams, ExecutionContext executionContext, TransformingAsyncResponseHandler<ReturnT> asyncResponseHandler) {
        try {
            InterceptorContext finalizeSdkRequestContext = BaseAsyncClientHandler.finalizeSdkRequest(executionContext);
            SdkRequest inputT = finalizeSdkRequestContext.request();
            InterceptorContext finalizeSdkHttpRequestContext = BaseAsyncClientHandler.finalizeSdkHttpFullRequest(executionParams, executionContext, inputT, this.clientConfiguration);
            SdkHttpFullRequest marshalled = (SdkHttpFullRequest)finalizeSdkHttpRequestContext.httpRequest();
            if (!finalizeSdkHttpRequestContext.asyncRequestBody().isPresent() && finalizeSdkHttpRequestContext.requestBody().isPresent()) {
                marshalled = marshalled.toBuilder().contentStreamProvider(finalizeSdkHttpRequestContext.requestBody().get().contentStreamProvider()).build();
            }
            AsyncAfterTransmissionInterceptorCallingResponseHandler<ReturnT> successResponseHandler = new AsyncAfterTransmissionInterceptorCallingResponseHandler<ReturnT>(asyncResponseHandler, executionContext);
            TransformingAsyncResponseHandler<? extends SdkException> errorHandler = this.resolveErrorResponseHandler(executionParams, executionContext, this.crc32Validator);
            CompletableFuture<ReturnT> invokeFuture = this.invoke(marshalled, finalizeSdkHttpRequestContext.asyncRequestBody().orElse(null), inputT, executionContext, successResponseHandler, errorHandler);
            CompletionStage exceptionTranslatedFuture = invokeFuture.handle((resp, err) -> {
                if (err != null) {
                    throw ThrowableUtils.failure(err);
                }
                return resp;
            });
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)exceptionTranslatedFuture, invokeFuture);
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log.logger(), (String)"Error thrown from TransformingAsyncResponseHandler#onError, ignoring.", () -> asyncResponseHandler.onError(t));
            return CompletableFutureUtils.failedFuture((Throwable)ThrowableUtils.asSdkException(t));
        }
    }

    public void close() {
        this.client.close();
    }

    private TransformingAsyncResponseHandler<? extends SdkException> resolveErrorResponseHandler(ClientExecutionParams<?, ?> executionParams, ExecutionContext executionContext, Function<SdkHttpFullResponse, SdkHttpFullResponse> responseAdapter) {
        AsyncResponseHandler<SdkException> result = new AsyncResponseHandler<SdkException>(executionParams.getErrorResponseHandler(), responseAdapter, executionContext.executionAttributes());
        return new AsyncAfterTransmissionInterceptorCallingResponseHandler<SdkException>(result, executionContext);
    }

    private <InputT extends SdkRequest, OutputT> CompletableFuture<OutputT> invoke(SdkHttpFullRequest request, AsyncRequestBody requestProvider, InputT originalRequest, ExecutionContext executionContext, TransformingAsyncResponseHandler<OutputT> responseHandler, TransformingAsyncResponseHandler<? extends SdkException> errorResponseHandler) {
        return this.client.requestExecutionBuilder().requestProvider(requestProvider).request(request).originalRequest(originalRequest).executionContext(executionContext).errorResponseHandler(errorResponseHandler).execute(responseHandler);
    }
}

