/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.CFJVMDebugManager;
import coldfusion.debugger.JVMDebugThreadManager;
import coldfusion.debugger.rds.handler.DebugCommandHandler;
import coldfusion.debugger.rds.handler.DebugEventsHandler;
import coldfusion.debugger.rds.handler.DebugServerHandler;
import coldfusion.debugger.rds.handler.DebugStartRequestHandler;
import coldfusion.debugger.rds.handler.DebugStopRequestHandler;
import coldfusion.debugger.rds.handler.DebuggerExitThread;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import com.sun.jdi.VirtualMachine;

public class DebuggerRDSRequestManager {
    CFJVMDebugManager debugMgr = null;
    String host = null;
    int port = -1;
    String cfRootDir = null;
    String ctxRoot = null;
    String canonicalCtxRoot = null;
    boolean attachedToDebugger = false;
    private int activeSessionCount = 0;
    private int maxSessionCount = 0;
    private boolean debuggerStopped = false;
    private boolean traceDebugger = false;

    public DebuggerRDSRequestManager(String host, String ctxRoot, String canonicalCtxRoot, int port, String cfRoot, int maxSessions) {
        this(host, ctxRoot, canonicalCtxRoot, port, cfRoot, maxSessions, false);
    }

    public DebuggerRDSRequestManager(String host, String ctxRoot, String canonicalCtxRoot, int port, String cfRoot, int maxSessions, boolean traceDebugger) {
        this.debugMgr = new CFJVMDebugManager(ctxRoot, canonicalCtxRoot, traceDebugger);
        this.host = host;
        this.port = port;
        this.cfRootDir = cfRoot;
        this.maxSessionCount = maxSessions;
        this.ctxRoot = ctxRoot;
        this.traceDebugger = traceDebugger;
    }

    public synchronized boolean connectToDebugger(RdsResponse resp) {
        if (this.attachedToDebugger) {
            return true;
        }
        try {
            this.debugMgr.attachToCFJVM(this.host, this.port);
            this.attachedToDebugger = true;
        }
        catch (Throwable e) {
            this.attachedToDebugger = false;
            CFDebuggerLogger.log(e);
            resp.setError("Error connecting to JVM for debugging at " + this.host + ":" + this.port + ".\n" + e.getMessage());
            return false;
        }
        return true;
    }

    public void processRequest(RdsRequest req, RdsResponse resp) {
        String command = req.getMetaString(0);
        if (command.equalsIgnoreCase("DBG_GET_DEBUG_SERVER_INFO")) {
            DebugServerHandler.handleServerInfoRequest(req, resp, this.port, this.host, this.cfRootDir, this.ctxRoot, this.maxSessionCount);
            return;
        }
        if (this.debugMgr == null) {
            resp.setError("Debugger is not attached");
            return;
        }
        if (this.debuggerStopped) {
            return;
        }
        if (command.equalsIgnoreCase("DBG_SERVER_STOP")) {
            this.stopDebugger(false);
            return;
        }
        if (!this.attachedToDebugger && !this.connectToDebugger(resp)) {
            return;
        }
        if (command.equalsIgnoreCase("DBG_START")) {
            boolean canCreateSession = this.incrementActiveSessionCount();
            if (!canCreateSession) {
                resp.setError("Cannot start a new session. Max session count reached");
                return;
            }
            String sessionId = DebugStartRequestHandler.handleRequest(req, resp, this.debugMgr);
            if (sessionId == null) {
                this.decrementActiveSessionCount();
            }
        } else if (command.equalsIgnoreCase("DBG_REQUEST")) {
            DebugCommandHandler.handleRequest(req, resp, this.debugMgr);
        } else if (command.equalsIgnoreCase("DBG_STOP")) {
            DebugStopRequestHandler.handleRequest(req, resp, this.debugMgr);
            this.decrementActiveSessionCount();
        } else if (command.equalsIgnoreCase("DBG_EVENTS")) {
            DebugEventsHandler.handleRequest(req, resp, this.debugMgr);
        }
    }

    public int getJVMDebugPort() {
        return this.port;
    }

    public String getCFHost() {
        return this.host;
    }

    private synchronized boolean incrementActiveSessionCount() {
        if (this.activeSessionCount + 1 > this.maxSessionCount) {
            return false;
        }
        ++this.activeSessionCount;
        return true;
    }

    private synchronized void decrementActiveSessionCount() {
        --this.activeSessionCount;
    }

    public synchronized void stopDebugger(boolean cfShutdown) {
        if (this.debuggerStopped) {
            return;
        }
        VirtualMachine vm = this.debugMgr.getVm();
        if (vm != null) {
            boolean atLeaseOneThreadResumed = false;
            try {
                this.debugMgr.stopEventManager();
                vm.eventRequestManager().deleteAllBreakpoints();
                atLeaseOneThreadResumed = JVMDebugThreadManager.resumeWaitingThreads(vm);
            }
            catch (Throwable t) {
                CFDebuggerLogger.log(t);
            }
            this.debugMgr.onVMDisconnected(null);
            try {
                boolean disposeVm = true;
                if (cfShutdown && atLeaseOneThreadResumed) {
                    disposeVm = false;
                }
                if (disposeVm) {
                    vm.dispose();
                    vm = null;
                }
            }
            catch (Throwable t) {
                CFDebuggerLogger.log(t);
            }
        }
        DebuggerExitThread exitThread = new DebuggerExitThread(vm);
        exitThread.start();
        this.debuggerStopped = true;
    }

    public boolean isTraceDebugger() {
        return this.traceDebugger;
    }

    public void setTraceDebugger(boolean traceDebugger) {
        this.traceDebugger = traceDebugger;
    }
}

