/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class CFDebuggerLogger {
    private static CFDebuggerLogger theInstance = new CFDebuggerLogger();
    private static boolean enabled = false;
    public static final String traceDebuggerPropName = "DEBUGGER_TRACE";

    private CFDebuggerLogger() {
    }

    public static CFDebuggerLogger getIntance() {
        return theInstance;
    }

    public static void log(String msg) {
        if (enabled) {
            System.out.println("\n" + msg);
        }
    }

    public static void log(Throwable t) {
        if (!enabled) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(outStream);
        t.printStackTrace(writer);
        writer.close();
        CFDebuggerLogger.log(outStream.toString());
    }

    public static void log(RdsRequest req) {
        if (!enabled) {
            return;
        }
        StringBuffer buf = new StringBuffer("RDSRequest - ");
        int count = req.getMetaCount();
        for (int i = 0; i < count; ++i) {
            buf.append(req.getMetaString(i) + ",");
        }
        CFDebuggerLogger.log(buf.toString());
    }

    public static void log(RdsResponse res) {
        if (!enabled) {
            return;
        }
        StringBuffer buf = new StringBuffer("RDSResponse - ");
        int count = res.getMetaCount();
        for (int i = 0; i < count; ++i) {
            buf.append(res.getMetaString(i) + ",");
        }
        CFDebuggerLogger.log(buf.toString());
    }

    public static synchronized void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static synchronized boolean getEnabled() {
        return enabled;
    }
}

