/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Path;

public class Vector_Object
implements Serializable {
    private int increment_size = 1000;
    private int current_item;
    private int max_size = 250;
    private static final Integer GENERIC = 1;
    private static final Integer BASICSTROKE = 2;
    private static final Integer BUFFERED_IMAGE = 3;
    private static final Integer GENERAL_PATH = 4;
    private static final Integer T1GLYPH = 5;
    private static final Integer TTGLYPH = 6;
    private static final Integer AREA = 7;
    private static final Integer RECT = 8;
    private static final Integer T3GLYPH = 9;
    private static final Integer TEXTUREDPAINT = 10;
    private Object[] items = new Object[this.max_size];
    private int checkPoint = -1;

    public Vector_Object() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }

    private static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Object(int number) {
        this.max_size = number;
        this.items = new Object[this.max_size];
    }

    public final Object[] get() {
        return this.items;
    }

    public final Object pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final boolean contains(Object value) {
        boolean flag = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (!this.items[i].equals(value)) continue;
            i = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final void addElement(Object value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void setElementAt(Object new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final Object elementAt(int id) {
        if (id >= this.max_size) {
            return null;
        }
        return this.items[id];
    }

    public final void set(Object[] new_items) {
        this.items = new_items;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = null;
        } else {
            this.items[0] = null;
        }
        --this.current_item;
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            Object[] temp = this.items;
            this.items = new Object[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Object.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream bos) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            ByteArrayOutputStream baos;
            Object nextObj = this.items[i];
            if (nextObj instanceof BasicStroke) {
                os.writeObject(BASICSTROKE);
                BasicStroke stroke = (BasicStroke)this.items[i];
                os.writeFloat(stroke.getLineWidth());
                os.writeInt(stroke.getEndCap());
                os.writeInt(stroke.getLineJoin());
                os.writeFloat(stroke.getMiterLimit());
                os.writeObject(stroke.getDashArray());
                os.writeFloat(stroke.getDashPhase());
                continue;
            }
            if (nextObj instanceof Rectangle2D) {
                os.writeObject(RECT);
                Rectangle2D rect = (Rectangle2D)this.items[i];
                os.writeDouble(rect.getBounds2D().getX());
                os.writeDouble(rect.getBounds2D().getY());
                os.writeDouble(rect.getBounds2D().getWidth());
                os.writeDouble(rect.getBounds2D().getHeight());
                continue;
            }
            if (nextObj instanceof BufferedImage) {
                os.writeObject(BUFFERED_IMAGE);
                baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)nextObj, "png", baos);
                os.writeObject(baos.toByteArray());
                continue;
            }
            if (nextObj instanceof GeneralPath) {
                os.writeObject(GENERAL_PATH);
                PathSerializer.serializePath(os, ((Shape)this.items[i]).getPathIterator(new AffineTransform()));
                continue;
            }
            if (nextObj instanceof T1Glyph) {
                os.writeObject(T1GLYPH);
                ((T1Glyph)nextObj).flushArea();
                os.writeObject(nextObj);
                ((T1Glyph)nextObj).writePathsToStream(os);
                continue;
            }
            if (nextObj instanceof TTGlyph) {
                os.writeObject(TTGLYPH);
                ((TTGlyph)nextObj).flushArea();
                os.writeObject(nextObj);
                ((TTGlyph)nextObj).writePathsToStream(os);
                continue;
            }
            if (nextObj instanceof T3Glyph) {
                os.writeObject(T3GLYPH);
                ((T3Glyph)nextObj).writePathsToStream(os);
                continue;
            }
            if (nextObj instanceof PdfTexturePaint) {
                os.writeObject(TEXTUREDPAINT);
                baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((TexturePaint)nextObj).getImage(), "png", baos);
                os.writeObject(baos.toByteArray());
                Rectangle2D rect = ((TexturePaint)nextObj).getAnchorRect();
                os.writeDouble(rect.getBounds2D().getX());
                os.writeDouble(rect.getBounds2D().getY());
                os.writeDouble(rect.getBounds2D().getWidth());
                os.writeDouble(rect.getBounds2D().getHeight());
                continue;
            }
            if (nextObj instanceof Area) {
                os.writeObject(AREA);
                Area area = (Area)this.items[i];
                PathIterator pathIterator = area.getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
                continue;
            }
            try {
                os.writeObject(GENERIC);
                os.writeObject(nextObj);
                continue;
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        os.close();
    }

    public void restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        int size;
        ObjectInputStream os = new ObjectInputStream(bis);
        this.max_size = size = ((Integer)os.readObject()).intValue();
        this.items = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object nextObject;
            Integer type = (Integer)os.readObject();
            if (type.compareTo(BASICSTROKE) == 0) {
                float w = os.readFloat();
                int current_line_cap_style = os.readInt();
                int current_line_join_style = os.readInt();
                float mitre_limit = os.readFloat();
                float[] current_line_dash_array = (float[])os.readObject();
                float current_line_dash_phase = os.readFloat();
                nextObject = new BasicStroke(w, current_line_cap_style, current_line_join_style, mitre_limit, current_line_dash_array, current_line_dash_phase);
            } else if (type.compareTo(RECT) == 0) {
                float x = os.readFloat();
                float y = os.readFloat();
                float w = os.readFloat();
                float h = os.readFloat();
                nextObject = new Rectangle2D.Float(x, y, w, h);
            } else if (type.compareTo(BUFFERED_IMAGE) == 0) {
                byte[] bytes = (byte[])os.readObject();
                nextObject = DefaultImageHelper.read(bytes);
            } else if (type.compareTo(GENERAL_PATH) == 0) {
                nextObject = PathSerializer.deserializePath(os);
            } else if (type.compareTo(T1GLYPH) == 0) {
                T1Glyph glyph = (T1Glyph)os.readObject();
                int count = (Integer)os.readObject();
                GeneralPath[] paths = new GeneralPath[count];
                for (int j = 0; j < count; ++j) {
                    paths[j] = PathSerializer.deserializePath(os);
                }
                Vector_Path vp = new Vector_Path();
                vp.set(paths);
                vp.setCurrent_item(paths.length);
                glyph.setPaths(vp);
                nextObject = glyph;
            } else if (type.compareTo(TTGLYPH) == 0) {
                TTGlyph glyph = (TTGlyph)os.readObject();
                int count = (Integer)os.readObject();
                GeneralPath[] paths = new GeneralPath[count];
                for (int j = 0; j < count; ++j) {
                    paths[j] = PathSerializer.deserializePath(os);
                }
                Vector_Path vp = new Vector_Path();
                vp.set(paths);
                vp.setCurrent_item(paths.length);
                glyph.setPaths(vp);
                nextObject = glyph;
            } else if (type.compareTo(T3GLYPH) == 0) {
                nextObject = new T3Glyph(os);
            } else if (type.compareTo(TEXTUREDPAINT) == 0) {
                byte[] bytes = (byte[])os.readObject();
                BufferedImage img = DefaultImageHelper.read(bytes);
                float x = os.readFloat();
                float y = os.readFloat();
                float w = os.readFloat();
                float h = os.readFloat();
                Rectangle2D.Float anchor = new Rectangle2D.Float(x, y, w, h);
                nextObject = new PdfTexturePaint(img, anchor);
            } else {
                GeneralPath path;
                nextObject = type.compareTo(AREA) == 0 ? ((path = PathSerializer.deserializePath(os)) == null ? null : new Area(path)) : os.readObject();
            }
            this.items[i] = nextObject;
        }
    }

    public void trim() {
        Object[] newItems = new Object[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }
}

