/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static LogScanner logScanner;
    public static String log_name;
    private static boolean verbose;
    private static final Set<String> filterValues;
    public static final boolean isRunningFromIDE;

    private static Set<String> getFilterSet() {
        String filters = System.getProperty("org.jpedal.inclusiveLogFilters");
        HashSet<String> filterSet = null;
        if (filters != null) {
            filterSet = new HashSet<String>(Arrays.asList(filters.toLowerCase().split("[,]")));
        }
        return filterSet;
    }

    public static final void writeLog(String message) {
        if (message == null) {
            System.out.println("[Warning] Null message string passed to logger.");
            return;
        }
        if (isRunningFromIDE && message.contains("Exception")) {
            System.out.println("[Exception] " + message);
            try {
                throw new RuntimeException("Exception thrown at");
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.out);
            }
        }
        if (verbose || logScanner != null) {
            LogWriter.writeMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMessage(String message) {
        if (filterValues != null && message != null) {
            boolean found = false;
            for (String s : filterValues) {
                if (!message.toLowerCase().contains(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (logScanner != null) {
            logScanner.message(message);
        }
        if (verbose) {
            System.out.println(message);
        }
        if (log_name != null) {
            PrintWriter log_file = null;
            try {
                log_file = new PrintWriter(new FileWriter(log_name, true));
                log_file.println(TimeNow.getTimeNow() + ' ' + message);
                log_file.println(message);
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
            finally {
                if (log_file != null) {
                    try {
                        log_file.close();
                    }
                    catch (Exception e) {
                        System.err.println("Exception " + e + " attempting to close log file " + log_name);
                    }
                }
            }
        }
    }

    public static final void setupLogFile(String command_line_values) {
        if (command_line_values != null) {
            if (command_line_values.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        LogWriter.writeLog("=======================================================");
    }

    static {
        filterValues = LogWriter.getFilterSet();
        isRunningFromIDE = System.getProperty("debugInIDE") != null && System.getProperty("debugInIDE").equalsIgnoreCase("true") && LogWriter.class.getResource("LogWriter.class").toString().startsWith("file:");
    }
}

