/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfShape;
import org.jpedal.render.G2Display;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class ImageDisplay
extends G2Display {
    public ImageDisplay(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.type = 2;
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.areas = new Vector_Rectangle_Int(defaultSize);
    }

    @Override
    public final int drawImage(int pageNumber, BufferedImage image, GraphicsState gs, boolean alreadyCached, String name, int previousUse) {
        int iw = (int)gs.CTM[0][0];
        if (iw < 0) {
            iw = -iw;
        } else if (iw == 0 && (iw = (int)gs.CTM[0][1]) < 0) {
            iw = -iw;
        }
        int ih = (int)gs.CTM[1][1];
        if (ih < 0) {
            ih = -ih;
        } else if (ih == 0 && (ih = (int)gs.CTM[1][0]) < 0) {
            ih = -ih;
        }
        int[] rectParams = new int[]{(int)gs.CTM[2][0], (int)gs.CTM[2][1], iw, ih};
        this.areas.addElement(rectParams);
        this.blendMode = gs.getBMValue();
        this.renderImage(null, image, gs.getAlpha(2), gs, gs.x, gs.y);
        return -1;
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean canBeCached) {
        Area clip = currentGraphicsState.getClippingShape();
        if (!(canBeCached && this.hasClips && this.lastClip == null && clip == null || canBeCached && this.lastClip != null && clip != null && clip.equals(this.lastClip))) {
            RenderUtils.renderClip(currentGraphicsState.getClippingShape(), null, defaultClip, this.g2);
            this.lastClip = clip;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] textTransform, String glyf, PdfFont currentFontData, float glyfWidth) {
        this.blendMode = gs.getBMValue();
        AffineTransform at = null;
        if (textTransform != null) {
            at = new AffineTransform(textTransform);
        }
        if (type == 1) {
            PdfPaint currentCol = null;
            PdfPaint fillCol = null;
            int text_fill_type = gs.getTextRenderType();
            if ((text_fill_type & 2) == 2) {
                fillCol = gs.getNonstrokeColor();
            }
            if ((text_fill_type & 1) == 1) {
                currentCol = gs.getStrokeColor();
            }
            Stroke newStroke = gs.getStroke();
            this.g2.setStroke(newStroke);
            AffineTransform def = this.g2.getTransform();
            this.g2.translate(Trm[2][0], Trm[2][1]);
            if (at != null) {
                this.g2.transform(at);
            }
            this.renderText(Trm[2][0], Trm[2][1], text_fill_type, (Area)javaGlyph, currentCol, fillCol, gs.getAlpha(1), gs.getAlpha(2));
            this.g2.setTransform(def);
        } else {
            int fontSize2;
            PdfPaint strokeCol = null;
            PdfPaint fillCol = null;
            int text_fill_type = gs.getTextRenderType();
            if ((text_fill_type & 2) == 2) {
                fillCol = gs.getNonstrokeColor();
            }
            if ((text_fill_type & 1) == 1) {
                strokeCol = gs.getStrokeColor();
            }
            Stroke newStroke = gs.getStroke();
            Stroke currentStroke = this.g2.getStroke();
            if (text_fill_type == 1) {
                this.g2.setStroke(newStroke);
            }
            if ((fontSize2 = (int)gs.CTM[1][1]) < 0) {
                fontSize2 = -fontSize2;
            }
            if (fontSize2 == 0) {
                fontSize2 = (int)gs.CTM[0][1];
            }
            if (fontSize2 < 0) {
                fontSize2 = -fontSize2;
            }
            int[] rectParams = new int[]{(int)gs.CTM[2][0], (int)gs.CTM[2][1], fontSize2, fontSize2};
            this.areas.addElement(rectParams);
            this.renderEmbeddedText(text_fill_type, embeddedGlyph, type, at, strokeCol, fillCol, gs.getAlpha(1), gs.getAlpha(2), (int)gs.getLineWidth());
            this.g2.setStroke(currentStroke);
        }
    }

    @Override
    public final void drawShape(PdfShape pdfShape, GraphicsState gs, int cmd) {
        Shape currentShape = pdfShape.getShape();
        if ((cmd == 70 || cmd == 66) && gs.CTM[0][1] == 0.0f && gs.CTM[1][0] == 0.0f) {
            int x = currentShape.getBounds().x;
            int y = currentShape.getBounds().y;
            int w = currentShape.getBounds().width;
            int h = currentShape.getBounds().height;
            int[] rectParams = new int[]{x, y, w, h};
            this.areas.addElement(rectParams);
        } else {
            this.areas.addElement(null);
        }
        this.blendMode = gs.getBMValue();
        this.renderShape(null, gs.getFillType(), gs.getStrokeColor(), gs.getNonstrokeColor(), gs.getStroke(), currentShape, gs.getAlpha(1), gs.getAlpha(2));
    }

    @Override
    public void drawShape(Object currentShape, GraphicsState currentGraphicsState) {
    }
}

