/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Color;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import org.jpedal.color.PdfColor;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.SwingShape;
import org.jpedal.render.G2Display;
import org.jpedal.render.ImageObject;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;

public abstract class GUIDisplay
extends G2Display {
    private boolean needsHorizontalInvert;
    private boolean needsVerticalInvert;

    public void saveImage(int id, String des, String type) {
        String name = (String)this.imageIDtoName.get(id);
        BufferedImage image = this.objectStoreRef.loadStoredImage(name);
        if (image == null) {
            image = (BufferedImage)this.pageObjects.elementAt(id);
        }
        if (image != null) {
            if (image.getType() == 0 || type.equals("jpg") && image.getType() == 2) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
            if (this.needsHorizontalInvert) {
                image = RenderUtils.invertImageBeforeSave(image, true);
            }
            if (this.needsVerticalInvert) {
                image = RenderUtils.invertImageBeforeSave(image, false);
            }
            try {
                DefaultImageHelper.write(image, type, des);
            }
            catch (IOException ex) {
                LogWriter.writeLog("Exception in writing image " + ex);
            }
        }
    }

    public void setneedsVerticalInvert(boolean b) {
        this.needsVerticalInvert = b;
    }

    public void setneedsHorizontalInvert(boolean b) {
        this.needsHorizontalInvert = b;
    }

    public int getObjectUnderneath(int x, int y) {
        int typeFound = -1;
        int[][] areas = this.areas.get();
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            boolean nothing = true;
            for (int i = count - 1; i > -1; --i) {
                if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y) || types[i] == 2 || types[i] == 7) continue;
                nothing = false;
                typeFound = types[i];
                i = -1;
            }
            if (nothing) {
                return -1;
            }
        }
        return typeFound;
    }

    public int[] getAreaAsArray(int i) {
        return this.areas.elementAt(i);
    }

    public int isInsideImage(int x, int y) {
        int outLine = -1;
        int[][] areas = this.areas.get();
        int[] possArea = null;
        int count = areas.length;
        if (this.objectType != null) {
            int[] types = this.objectType.get();
            for (int i = 0; i < count; ++i) {
                if (areas[i] == null || !RenderUtils.rectangleContains(areas[i], x, y) || types[i] != 3) continue;
                if (possArea != null) {
                    int area2 = areas[i][3] * areas[i][2];
                    void area1 = possArea[3] * possArea[2];
                    if (area2 < area1) {
                        possArea = areas[i];
                    }
                    outLine = i;
                    continue;
                }
                possArea = areas[i];
                outLine = i;
            }
        }
        return outLine;
    }

    void drawUserContent(int[] type1, Object[] obj, Color[] colors) throws PdfException {
        int count = type1.length;
        block10: for (int i = 0; i < count; ++i) {
            int currentType = type1[i];
            switch (currentType) {
                case 18: {
                    this.setGraphicsState(2, ((Number)obj[i]).floatValue(), 1111314299);
                    continue block10;
                }
                case 17: {
                    this.setGraphicsState(1, ((Number)obj[i]).floatValue(), 1111314299);
                    continue block10;
                }
                case 19: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(1);
                    gs.setStrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape(new SwingShape((Shape)obj[i]), gs, 83);
                    continue block10;
                }
                case 20: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape(new SwingShape((Shape)obj[i]), gs, 70);
                    continue block10;
                }
                case 23: {
                    this.drawCustom(obj[i]);
                    continue block10;
                }
                case 3: {
                    ImageObject imgObj = (ImageObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    gs.CTM = new float[][]{{imgObj.image.getWidth(), 0.0f, 1.0f}, {0.0f, imgObj.image.getHeight(), 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = imgObj.x;
                    gs.y = imgObj.y;
                    this.drawImage(this.rawPageNumber, imgObj.image, gs, false, "extImg" + i, -1);
                    continue block10;
                }
                case 16: {
                    TextObject textObj = (TextObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    float fontSize = textObj.font.getSize();
                    double[] afValues = new double[]{fontSize, 0.0, 0.0, fontSize, 0.0, 0.0};
                    this.drawAffine(afValues);
                    this.drawTR(2);
                    gs.setTextRenderType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawText(null, textObj.text, gs, textObj.x, -textObj.y, textObj.font);
                    continue block10;
                }
                case 0: {
                    continue block10;
                }
                default: {
                    throw new PdfException("Unrecognised type " + currentType);
                }
            }
        }
    }

    void drawCustom(Object value) {
        throw new UnsupportedOperationException("drawCustom base method in GUI data should not be called " + value);
    }

    void drawAffine(double[] afValues) {
        throw new UnsupportedOperationException("drawAffine only supported in Swing Viewer " + Arrays.toString(afValues));
    }
}

