/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.downsample;

import org.jpedal.images.SamplingFactory;
import org.jpedal.parser.image.data.ImageData;

class KernelUtils {
    KernelUtils() {
    }

    static void applyKernel(ImageData imageData, int compCount) {
        double[][] kernel = SamplingFactory.getSharpenKernel();
        byte[] input = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        if (compCount == 3) {
            compCount = 4;
        }
        byte[] output = new byte[w * h * compCount];
        int value = 0;
        int lineBytes = w * compCount;
        int matrixSize = kernel.length;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < matrixSize; ++i) {
                    for (int j = 0; j < matrixSize; ++j) {
                        int imageX = (x - matrixSize / 2 + i + w) % w;
                        int imageY = (y - matrixSize / 2 + j + h) % h;
                        int currentPixel = input[imageY * lineBytes + imageX] & 0xFF;
                        value = (int)((double)value + (double)currentPixel * kernel[i][j]);
                    }
                }
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                output[y * lineBytes + x] = (byte)value;
                value = 0;
            }
        }
        imageData.setObjectData(output);
    }
}

