/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.utils.LogWriter;

public class DO
extends ImageDecoder {
    public DO(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ImageHandler customImageHandler, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, PdfPageData pageData, String imagesInFile) {
        super(imageCount, currentPdfFile, errorTracker, customImageHandler, objectStoreStreamRef, pdfImages, pageData, imagesInFile);
    }

    @Override
    public int processImage(String name, int dataPointer, PdfObject XObject2) {
        String key = null;
        if (ImageCommands.rejectSuperimposedImages) {
            key = (int)this.gs.CTM[2][0] + "-" + (int)this.gs.CTM[2][1] + '-' + (int)this.gs.CTM[0][0] + '-' + (int)this.gs.CTM[1][1] + '-' + (int)this.gs.CTM[0][1] + '-' + (int)this.gs.CTM[1][0];
        }
        try {
            if (System.getProperty("testsDisableImages") == null) {
                this.processXImage(name, name, key, XObject2);
            }
        }
        catch (Error e) {
            LogWriter.writeLog("Error: " + e.getMessage());
            this.parserOptions.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e);
            this.parserOptions.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        return dataPointer;
    }

    private void processXImage(String name, String details, String key, PdfObject XObject2) {
        int previousUse = -1;
        if (ImageCommands.trackImages) {
            details = details + " Image";
            if (this.imagesInFile == null) {
                this.imagesInFile = "";
            }
        }
        boolean isForHTML = this.current.isHTMLorSVG();
        if (this.parserOptions.imagesNeeded()) {
            byte[] objectData;
            byte[] temp = this.objectStoreStreamRef.getMemoryData(XObject2.getObjectRefAsString());
            if (temp != null) {
                objectData = temp;
            } else {
                objectData = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(this.currentPdfFile.getObjectReader()));
                this.objectStoreStreamRef.addMemoryData(XObject2.getObjectRefAsString(), objectData);
            }
            if (objectData == null || XObject2.streamMayBeCorrupt()) {
                this.parserOptions.imagesProcessedFully = false;
            } else {
                this.currentImage = this.parserOptions.getFileName() + '-' + name;
                BufferedImage image = this.processImageXObject(XObject2, name, objectData, details);
                if (image != null && image.getWidth() == 1 && image.getHeight() == 1 && this.parserOptions.isType3Font()) {
                    image.flush();
                    image = null;
                }
                if (image != null) {
                    if (isForHTML) {
                        this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, name, -2);
                    } else {
                        if (this.parserOptions.renderImages()) {
                            this.gs.x = this.gs.CTM[2][0];
                            this.gs.y = this.gs.CTM[2][1];
                            int id = this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, name, -1);
                            if (ImageCommands.rejectSuperimposedImages && key != null) {
                                this.cache.setImposedKey(key, id);
                            }
                        }
                        if (this.parserOptions.isPageContent() && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                            if (this.parserOptions.isClippedImagesExtracted()) {
                                this.generateClippedImage(image);
                            } else if (this.parserOptions.isFinalImagesExtracted() || this.parserOptions.isRawImagesExtracted()) {
                                try {
                                    this.generateTransformedImageSingle(image);
                                }
                                catch (Exception e) {
                                    LogWriter.writeLog("Exception " + e + " on transforming image in file");
                                }
                            }
                        }
                    }
                    image.flush();
                }
            }
        }
    }
}

