/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.gs;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;

public class GraphicsStates {
    private boolean isStackInitialised;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Int nonstrokeColorValueStack;
    private Vector_Int strokeColorValueStack;
    private Vector_Object textStateStack;
    private int depth;
    private final ParserOptions parserOptions;

    public GraphicsStates(ParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    public void pushGraphicsState(GraphicsState gs, DynamicVectorRenderer current) {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorValueStack = new Vector_Int(20);
            this.strokeColorValueStack = new Vector_Int(20);
        }
        ++this.depth;
        this.graphicsStateStack.push(gs.deepCopy());
        this.textStateStack.push(gs.getTextState().deepCopy());
        this.nonstrokeColorStateStack.push(gs.nonstrokeColorSpace);
        this.strokeColorStateStack.push(gs.strokeColorSpace);
        int strokeColorData = gs.strokeColorSpace.getColor().getRGB();
        int nonStrokeColorData = gs.nonstrokeColorSpace.getColor().getRGB();
        this.strokeColorValueStack.push(strokeColorData);
        this.nonstrokeColorValueStack.push(nonStrokeColorData);
        current.writeCustom(18, null);
    }

    public GraphicsState restoreGraphicsState(DynamicVectorRenderer current) {
        GraphicsState gs = new GraphicsState();
        gs.setTextState(new TextState());
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else if (this.depth > 0) {
            --this.depth;
            gs = (GraphicsState)this.graphicsStateStack.pull();
            gs.setTextState((TextState)this.textStateStack.pull());
            gs.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            gs.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            int strokeColorData = this.strokeColorValueStack.pull();
            int nonStrokeColorData = this.nonstrokeColorValueStack.pull();
            gs.resetColorSpaces(strokeColorData, nonStrokeColorData);
        }
        if (this.parserOptions.isRenderPage()) {
            current.drawClip(gs, this.parserOptions.defaultClip, false);
            current.writeCustom(18, null);
            current.setGraphicsState(2, gs.getAlpha(2), gs.getBMValue());
            current.setGraphicsState(1, gs.getAlpha(1), gs.getBMValue());
        }
        return gs;
    }

    public int getDepth() {
        return this.depth;
    }

    public void correctDepth(int currentDepth, DynamicVectorRenderer current) {
        while (this.depth > currentDepth) {
            this.restoreGraphicsState(current);
        }
    }
}

