/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import com.idrsolutions.pdf.acroforms.xfa.objects.XFADraw;
import com.idrsolutions.pdf.acroforms.xfa.objects.XFAField;
import java.util.ArrayList;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.AcroRendererXFA;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.Tj;
import org.w3c.dom.Node;

public class XFAStreamDecoder
extends PdfStreamDecoder {
    private final AcroRendererXFA formRenderer;

    public XFAStreamDecoder(PdfObjectReader currentPdfFile, PdfLayerList pdfLayerList, AcroRendererXFA formRenderer) {
        super(currentPdfFile, pdfLayerList);
        this.formRenderer = formRenderer;
        this.parserOptions.setXFA(true);
    }

    @Override
    public final T3Size decodePageContent(PdfObject pdfObject) {
        this.parserOptions.imagesProcessedFully = true;
        Tj textDecoder = new Tj(this.parserOptions, this.pdfData, this.isXMLExtraction, this.textAreas, this.textDirections, this.textUrlAreas, this.textUrlStrings, this.current, this.errorTracker);
        textDecoder.setReturnText(true);
        HashMap<Integer, XFAPageContent> pgMap = this.formRenderer.getPageMapXFA();
        ArrayList<Node> fieldList = new ArrayList<Node>();
        ArrayList<Node> drawList = new ArrayList<Node>();
        XFAPageContent xfaPageCont = null;
        Node pageAreaNode = null;
        xfaPageCont = pgMap.get(pdfObject.getPageNumber());
        if (xfaPageCont != null) {
            pageAreaNode = xfaPageCont.getPageAreaNode();
            XFAFormStream.nodePicker(pageAreaNode, 3091780, drawList, new ArrayList<Node>(), 0);
            XFAFormStream.nodePicker(pageAreaNode, 97427706, fieldList, new ArrayList<Node>(), 0);
            for (Node node : xfaPageCont.getNodeList()) {
                if (XFAFormStream.isDraw(node)) {
                    drawList.add(node);
                    continue;
                }
                if (!XFAFormStream.isField(node)) continue;
                fieldList.add(node);
            }
            HashMap<String, PdfFont> fontCache = new HashMap<String, PdfFont>();
            for (Node fn : drawList) {
                new XFADraw(textDecoder, fn, pageAreaNode, this.current, this.currentPdfFile, this, fontCache);
            }
            for (Node fn : fieldList) {
                new XFAField(textDecoder, fn, pageAreaNode, pdfObject.getPageNumber(), this.current, this.currentPdfFile, xfaPageCont, this, fontCache);
            }
            fontCache.clear();
        }
        return null;
    }
}

