/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.mask.MaskUtils;
import org.jpedal.render.ClipUtils;

public class FormFlattener {
    private static final FormExclusion exclusionOption;

    public void drawFlattenedForm(PdfStreamDecoder pdfStreamDecoder, PdfObject form, boolean isHTML, PdfObject AcroRes) throws PdfException {
        if (exclusionOption != FormExclusion.ExcludeNone && !FormFlattener.showForm(form)) {
            return;
        }
        ParserOptions parserOptions = pdfStreamDecoder.parserOptions;
        int pageNumber = parserOptions.getPageNumber();
        int type = form.getParameterConstant(1147962727);
        if (type == 1919840408) {
            AnnotationFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pageNumber, pdfStreamDecoder.pageData.getRotation(pageNumber));
            return;
        }
        PdfObjectReader currentPdfFile = pdfStreamDecoder.currentPdfFile;
        GraphicsState oldGS = pdfStreamDecoder.gs;
        pdfStreamDecoder.gs = new GraphicsState();
        parserOptions.setFlattenedForm(true);
        boolean[] characteristic = ((FormObject)form).getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5] || !form.getBoolean(524301630) && form.getParameterConstant(1147962727) == 1061176672) {
            return;
        }
        PdfObject imgObj = FormFlattener.getImageObject(pdfStreamDecoder, form, AcroRes, pageNumber, type, currentPdfFile);
        if (imgObj == null) {
            return;
        }
        byte[] formData = imgObj.getDecodedStream();
        PdfObject resources = imgObj.getDictionary(2004251818);
        if (resources != null) {
            pdfStreamDecoder.readResources(resources, false);
        }
        int pageRotation = pdfStreamDecoder.pageData.getRotation(pageNumber);
        float[] BBox = FormFlattener.setupBBox(form, parserOptions, imgObj);
        float[] matrix = imgObj.getFloatArray(1145198201);
        float x = BBox[0];
        float y = BBox[1];
        Area newClip = null;
        if (matrix != null) {
            float yScale = 1.0f;
            if (pageRotation == 0 && matrix[4] > 0.0f && matrix[5] > 0.0f) {
                float t;
                float[] BoundingBox = imgObj.getFloatArray(303185736);
                if (BoundingBox[1] > BoundingBox[3]) {
                    t = BoundingBox[1];
                    BoundingBox[1] = BoundingBox[3];
                    BoundingBox[3] = t;
                }
                if (BoundingBox[0] > BoundingBox[2]) {
                    t = BoundingBox[0];
                    BoundingBox[0] = BoundingBox[2];
                    BoundingBox[2] = t;
                }
                matrix[0] = (BBox[2] - BBox[0]) / (BoundingBox[2] - BoundingBox[0]);
                matrix[1] = 0.0f;
                matrix[2] = 0.0f;
                matrix[3] = (BBox[3] - BBox[1]) / (BoundingBox[3] - BoundingBox[1]);
                matrix[4] = BBox[0] - BoundingBox[0];
                matrix[5] = BBox[1] - BoundingBox[1];
                pdfStreamDecoder.gs.CTM = new float[][]{{matrix[0], matrix[1], 0.0f}, {matrix[2], matrix[3], 0.0f}, {matrix[4], matrix[5], 1.0f}};
                newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)(BBox[2] - BBox[0] + 2.0f), (int)(BBox[3] - BBox[1] + 2.0f)));
                x = matrix[4];
                y = matrix[5];
            } else {
                float[] BoundingBox;
                PdfObject temp = form.getDictionary(4384);
                if (temp != null && (temp = temp.getDictionary(30)) != null && (BoundingBox = temp.getFloatArray(303185736)) != null && BBox[0] != BoundingBox[0] && BBox[1] != BoundingBox[1] && BBox[2] != BoundingBox[2] && BBox[3] != BoundingBox[3]) {
                    if (matrix[0] * matrix[3] == 1.0f && matrix[1] * matrix[2] == 0.0f) {
                        float bbh = BBox[3] - BBox[1];
                        float imh = BoundingBox[3] - BoundingBox[1];
                        if ((int)bbh != (int)imh) {
                            yScale = bbh / imh;
                        }
                    } else if (matrix[0] * matrix[3] == 0.0f && matrix[1] * matrix[2] == -1.0f) {
                        float bbh = BBox[2] - BBox[0];
                        switch (pageRotation) {
                            case 90: {
                                bbh = BBox[2] - BBox[0];
                                break;
                            }
                            case 180: {
                                break;
                            }
                            case 270: {
                                bbh = BBox[2] - BBox[0];
                            }
                        }
                        float imh = BoundingBox[3] - BoundingBox[1];
                        if ((int)bbh != (int)imh) {
                            yScale = bbh / imh;
                        }
                    }
                }
                switch (pageRotation) {
                    case 90: {
                        x = BBox[0] < BBox[2] ? BBox[0] + matrix[4] * yScale : BBox[2] + matrix[4] * yScale;
                        if (!(matrix[4] < 0.0f)) break;
                        x = BBox[0] + matrix[4] * yScale;
                        break;
                    }
                    default: {
                        x = BBox[0] + matrix[4] * yScale;
                        newClip = new Area(new Rectangle((int)(BBox[0] - 1.0f), (int)(BBox[1] - 1.0f), (int)(BBox[2] - BBox[0] + 2.0f), (int)(BBox[3] - BBox[1] + 2.0f)));
                    }
                }
                y = BBox[1] + matrix[5] * yScale;
                pdfStreamDecoder.gs.CTM = new float[][]{{matrix[0] * yScale, matrix[1] * yScale, 0.0f}, {matrix[2] * yScale, matrix[3] * yScale, 0.0f}, {x, y, 1.0f}};
            }
        } else {
            newClip = FormFlattener.setClipAndCTM(pdfStreamDecoder, form, imgObj, BBox, x, y);
        }
        newClip = ClipUtils.convertPDFClipToJavaClip(newClip);
        this.drawForm(imgObj, form, pdfStreamDecoder, newClip, isHTML, BBox, x, y, formData, oldGS);
    }

    private static PdfObject getImageObject(PdfStreamDecoder pdfStreamDecoder, PdfObject form, PdfObject AcroRes, int pageNumber, int type, PdfObjectReader currentPdfFile) {
        String str;
        byte[] formData;
        PdfObject imgObj = null;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            String defaultState = form.getName(4387);
            Object[] values = FormStream.getNormalKeyValues(form, currentPdfFile.getObjectReader());
            if (defaultState != null && defaultState.equals(((FormObject)form).getNormalOnState())) {
                ((FormObject)form).setNormalOnState((String)values[0]);
                imgObj = (PdfObject)values[1];
            } else {
                imgObj = (PdfObject)values[2];
            }
        }
        if (imgObj != null && (formData = imgObj.getDecodedStream()) != null && ((str = new String(formData)).isEmpty() || str.contains("BMC") && !str.contains("BT"))) {
            imgObj = null;
        }
        if (imgObj == null) {
            byte[] DA;
            String V = form.getTextStreamValue(38);
            if (V == null && type == 980909433) {
                V = form.getTextStreamValue(1216184967);
            }
            if ((DA = form.getTextStreamValueAsByte(5137)) != null || V != null && !V.isEmpty()) {
                ReadOnlyTextIcon textIcon = new ReadOnlyTextIcon(form, 0, currentPdfFile, AcroRes);
                textIcon.decipherAppObject((FormObject)form);
                if (V != null) {
                    textIcon.setText(V);
                    imgObj = textIcon.getFakeObject();
                } else {
                    imgObj = textIcon.getFakeObject();
                    imgObj.setDecodedStream(DA);
                }
            }
            if (imgObj == null && DA == null && type == 607471684) {
                AnnotationFactory.renderFlattenedAnnotation(form, pdfStreamDecoder.current, pageNumber, pdfStreamDecoder.pageData.getRotation(pageNumber));
            }
        }
        if (imgObj != null) {
            currentPdfFile.checkResolved(imgObj);
        }
        return imgObj;
    }

    private static float[] setupBBox(PdfObject form, ParserOptions parserOptions, PdfObject imgObj) {
        Rectangle rect;
        float[] BBox = form.getFloatArray(573911876);
        if (imgObj != null && imgObj.getObjectType() == 129 && (rect = ((FormObject)form).getBoundingRectangle()) != null) {
            BBox = new float[]{rect.x, rect.y, rect.width, rect.height};
        }
        if (BBox == null) {
            BBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        }
        if (BBox[1] > BBox[3]) {
            float t = BBox[1];
            BBox[1] = BBox[3];
            BBox[3] = t;
        }
        if (BBox[0] > BBox[2]) {
            float t = BBox[0];
            BBox[0] = BBox[2];
            BBox[2] = t;
        }
        if (parserOptions.isFlattenedForm()) {
            parserOptions.setOffsets(BBox[0], BBox[1]);
        }
        return BBox;
    }

    private static Area setClipAndCTM(PdfStreamDecoder pdfStreamDecoder, PdfObject form, PdfObject imgObj, float[] BBox, float x, float y) {
        Area newClip;
        if (imgObj != null && form.getParameterConstant(1147962727) == 876043389) {
            float[] values2;
            float[] BoundingBox = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            PdfObject temp = form.getDictionary(4384);
            if (temp != null && (temp = temp.getDictionary(30)) != null && (BoundingBox = temp.getFloatArray(303185736)) == null) {
                BoundingBox = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            }
            if ((values2 = imgObj.getFloatArray(303185736)) != null) {
                float yScale;
                float xScale = (BBox[2] - BBox[0]) / (values2[2] - values2[0]);
                if (xScale < 0.0f) {
                    xScale = -xScale;
                }
                if ((yScale = (BBox[3] - BBox[1]) / (values2[3] - values2[1])) < 0.0f) {
                    yScale = -yScale;
                }
                pdfStreamDecoder.gs.CTM = new float[][]{{xScale, 0.0f, 0.0f}, {0.0f, yScale, 0.0f}, {x - BoundingBox[0], y - BoundingBox[1], 1.0f}};
            } else {
                pdfStreamDecoder.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
            }
            newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
        } else {
            pdfStreamDecoder.gs.CTM = form.getParameterConstant(1147962727) == 1654331 ? (Object)new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x - BBox[0], y - BBox[1], 1.0f}} : (float[][])new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {x, y, 1.0f}};
            newClip = new Area(new Rectangle((int)BBox[0], (int)BBox[1], (int)BBox[2], (int)BBox[3]));
        }
        return newClip;
    }

    void drawForm(PdfObject imgObj, PdfObject form, PdfStreamDecoder pdfStreamDecoder, Area newClip, boolean isHTML, float[] BBox, float x, float y, byte[] formData, GraphicsState oldGS) throws PdfException {
        if (newClip != null) {
            pdfStreamDecoder.gs.updateClip(new Area(newClip));
        }
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, pdfStreamDecoder.parserOptions.defaultClip, false);
        TextState oldState = pdfStreamDecoder.gs.getTextState();
        pdfStreamDecoder.gs.setTextState(new TextState());
        if (isHTML) {
            int w = (int)(BBox[2] - BBox[0]);
            int h = (int)(BBox[3] - BBox[1]);
            if (w > 0 && h > 0) {
                BufferedImage image = MaskUtils.createTransparentForm(imgObj, 0, w, h, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
                pdfStreamDecoder.gs.CTM = new float[][]{{image.getWidth() / 4, 0.0f, 1.0f}, {0.0f, image.getHeight() / 4, 1.0f}, {0.0f, 0.0f, 0.0f}};
                pdfStreamDecoder.gs.x = x;
                pdfStreamDecoder.gs.y = y;
                pdfStreamDecoder.gs.CTM[2][0] = x;
                pdfStreamDecoder.gs.CTM[2][1] = y;
                int previousUse = ((FormObject)form).isAddedToHTML() ? -3 : -2;
                pdfStreamDecoder.current.drawImage(pdfStreamDecoder.parserOptions.getPageNumber(), image, pdfStreamDecoder.gs, false, form.getObjectRefAsString(), previousUse);
            }
        } else if (formData != null) {
            pdfStreamDecoder.decodeStreamIntoObjects(formData, false);
        }
        pdfStreamDecoder.gs.updateClip(null);
        pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, null, true);
        pdfStreamDecoder.gs = oldGS;
        pdfStreamDecoder.gs.setTextState(oldState);
    }

    private static boolean showForm(PdfObject form) {
        switch (exclusionOption) {
            case ExcludeFormsAndAnnotations: {
                return false;
            }
            case ExcludeAnnotations: {
                if (form.getParameterConstant(608780341) != 1044266837 || form.getNameAsConstant(5668) != -1) break;
                return false;
            }
            case ExcludeForms: {
                if (form.getNameAsConstant(5668) == -1) break;
                return false;
            }
        }
        return true;
    }

    static {
        String value = System.getProperty("org.jpedal.removeForms");
        exclusionOption = value != null && !value.isEmpty() ? FormExclusion.valueOf(value) : FormExclusion.ExcludeNone;
    }

    private static enum FormExclusion {
        ExcludeNone,
        ExcludeForms,
        ExcludeAnnotations,
        ExcludeFormsAndAnnotations;

    }
}

