/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.output.HTMLFontHandler;
import org.jpedal.utils.LogWriter;

public class FontResolver {
    public static PdfFont resolveFont(GraphicsState gs, PdfStreamDecoder pdfStreamDecoder, String fontID, PdfFontFactory pdfFontFactory, PdfObjectCache cache) {
        PdfFont restoredFont;
        PdfObjectReader currentPdfFile = pdfStreamDecoder.currentPdfFile;
        ParserOptions parserOptions = pdfStreamDecoder.parserOptions;
        String fontKey = fontID;
        if (gs != null && cache.resolvedFonts.get("t-" + fontID) != null) {
            fontKey = fontID + ':' + gs.nonstrokeColorSpace.getColor().getRGB();
        }
        if ((restoredFont = cache.resolvedFonts.get(fontKey)) == null) {
            FontObject newFont = null;
            byte[] newFontData = cache.unresolvedFonts.get(fontID);
            if (newFontData == null) {
                cache.directFonts.remove(fontID);
            } else {
                String objRef;
                String key;
                boolean isRef;
                boolean bl = isRef = newFontData[0] != 60;
                if (isRef && (restoredFont = cache.resolvedFonts.get(key = cache.objRef2FontKey.get(objRef = new String(newFontData)))) != null && restoredFont.getFontType() == 1228944679) {
                    restoredFont = null;
                }
                if (restoredFont == null) {
                    newFont = FontResolver.getFontObjectFromRefOrDirect(currentPdfFile, newFontData);
                    if (isRef) {
                        cache.objRef2FontKey.put(new String(newFontData), fontKey);
                    }
                }
            }
            if (restoredFont == null) {
                if (parserOptions.isFlattenedForm() && newFont == null) {
                    newFont = new FontObject("0 0 R");
                    fontID = FontResolver.resolveFlattenedFont(fontID, newFont);
                }
                if (newFont != null) {
                    currentPdfFile.checkResolved(newFont);
                    try {
                        DynamicVectorRenderer current = pdfStreamDecoder.current;
                        boolean fallbackToArialOrLiberationSans = false;
                        boolean isHTML = current.isHTMLorSVG();
                        if (isHTML && !current.getBooleanValue(46)) {
                            fallbackToArialOrLiberationSans = true;
                        }
                        restoredFont = pdfFontFactory.createFont(fallbackToArialOrLiberationSans, newFont, fontID, pdfStreamDecoder.objectStoreStreamRef, parserOptions.isRenderPage(), pdfStreamDecoder.errorTracker, isHTML);
                        if (isHTML) {
                            HTMLFontHandler.processFont(restoredFont, current, newFont, currentPdfFile);
                        }
                    }
                    catch (PdfException e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            if (restoredFont != null && !pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                cache.resolvedFonts.put(fontKey, restoredFont);
                if (restoredFont.getFontType() == 1228944679) {
                    cache.resolvedFonts.put("t-" + fontID, new PdfFont());
                }
            }
        }
        return restoredFont;
    }

    private static String resolveFlattenedFont(String fontID, PdfObject newFont) {
        String name = StandardFonts.expandName(fontID.replace(",", "-"));
        if (FontMappings.fontSubstitutionAliasTable.get(name) == null && FontMappings.fontSubstitutionTable != null && FontMappings.fontSubstitutionTable.get(name) == null) {
            String rawName = name.toLowerCase();
            name = rawName.contains("bold") ? "Arial-Bold" : (rawName.contains("italic") ? "Arial-Italic" : "Arial");
        }
        newFont.setConstant(1147962727, 1217103210);
        fontID = StandardFonts.expandName(name);
        return fontID;
    }

    private static FontObject getFontObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        FontObject obj = new FontObject(new String(data));
        if (data[0] == 60) {
            obj.setStatus(2);
        } else {
            obj.setStatus(1);
        }
        obj.setUnresolvedData(data, 373243460);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(obj);
        return obj;
    }
}

