/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MarkedContentGenerator {
    private PdfObjectReader currentPdfFile;
    private DocumentBuilder db;
    private Document doc;
    private Element root;
    private PdfResources res;
    private PdfLayerList layers;
    private PdfPageData pdfPageData;
    private boolean isDecoding;
    private static boolean debug;
    private static String indent;
    private final Map<String, String> rolemapLookup = new HashMap<String, String>();

    public Document getMarkedContentTree(PdfResources res, PdfPageData pdfPageData, PdfObjectReader currentPdfFile) {
        boolean hasTree;
        PdfObject structTreeRootObj = res.getPdfObject(3);
        this.res = res;
        this.layers = res.getPdfLayerList();
        this.pdfPageData = pdfPageData;
        this.currentPdfFile = currentPdfFile;
        this.currentPdfFile.checkResolved(structTreeRootObj);
        this.setupTree();
        boolean bl = hasTree = structTreeRootObj != null && structTreeRootObj.getDictionary(1719112618) != null;
        if (debug) {
            System.out.println("hastree=" + hasTree);
        }
        if (hasTree) {
            this.buildTree(structTreeRootObj);
        } else {
            try {
                this.decodePageForMarkedContent(1, null, this.doc);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return this.doc;
    }

    private void setupTree() {
        try {
            SecureDocumentBuilderFactory dbf = new SecureDocumentBuilderFactory();
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.doc = this.db.newDocument();
        this.doc.appendChild(this.doc.createComment(" Created from JPedal "));
        this.doc.appendChild(this.doc.createComment(" http://www.idrsolutions.com "));
    }

    private void buildTree(PdfObject structTreeRootObj) {
        PdfObject RoleMap = structTreeRootObj.getDictionary(893350012);
        if (RoleMap != null) {
            this.readRoleMap(RoleMap);
        }
        this.root = this.doc.createElement("TaggedPDF-doc");
        this.doc.appendChild(this.root);
        this.traverseContentTree(structTreeRootObj);
    }

    private void readRoleMap(PdfObject roleMap) {
        PdfKeyPairsIterator keyPairs = roleMap.getKeyPairsIterator();
        while (keyPairs.hasMorePairs()) {
            String key = keyPairs.getNextKeyAsString();
            String value = keyPairs.getNextValueAsString();
            this.rolemapLookup.put(key, value);
            keyPairs.nextPair();
        }
    }

    private void traverseContentTree(PdfObject structTreeRootObj) {
        PdfObject K2 = structTreeRootObj.getDictionary(27);
        if (K2 == null) {
            PdfArrayIterator Karray = structTreeRootObj.getMixedArray(27);
            if (debug) {
                System.out.println("Karray=");
            }
            this.readKarray(Karray, this.root, null, "");
            if (debug) {
                System.out.println("Karray read");
            }
        } else {
            if (debug) {
                System.out.println("read child=" + K2.getObjectRefAsString());
            }
            this.readChildNode(K2, this.root, null, "");
        }
    }

    private void readChildNode(PdfObject K2, Element root, Map<String, String> pageStream, String fullS) {
        PdfObject Pg;
        if (debug) {
            indent = indent + "   ";
            System.out.println(indent + "read child node " + K2.getObjectRefAsString() + ' ' + K2.getInt(27));
        }
        PdfArrayIterator Karray = K2.getMixedArray(27);
        int Kint = K2.getInt(27);
        PdfObject Kdict = K2.getDictionary(27);
        String lang = K2.getTextStreamValue(472989239);
        String S2 = K2.getName(35);
        if (this.rolemapLookup.containsKey(S2)) {
            S2 = this.rolemapLookup.get(S2);
        }
        fullS = fullS + '.' + S2;
        Element child = null;
        if (debug) {
            System.out.println(indent + "S= " + S2 + ' ');
            if (S2 == null) {
                System.out.println("S is null in " + K2.getObjectRefAsString());
            }
        }
        if (S2 != null) {
            if (S2.equals("Span")) {
                child = root;
            } else {
                if (this.doc != null) {
                    child = this.doc.createElement(MarkedContentGenerator.cleanName(S2));
                }
                if (lang != null && child != null) {
                    child.setAttribute("xml:lang", lang);
                }
                if (root != null) {
                    root.appendChild(child);
                }
            }
        }
        if ((Pg = K2.getDictionary(8247)) != null && pageStream == null) {
            if (debug) {
                System.out.println(indent + "decode page ");
            }
            pageStream = new HashMap<String, String>();
            try {
                this.decodePageForMarkedContent(-1, Pg, pageStream);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (debug) {
            System.out.println(indent + "page decoded karray" + Karray + " Kdict=" + Kdict + " kint=" + Kint);
        }
        if (Karray != null) {
            this.readKarray(Karray, child, pageStream, fullS);
        } else if (Kdict != null) {
            this.readChildNode(Kdict, child, pageStream, fullS);
        } else if (Kint != -1) {
            this.addContentToNode(pageStream, String.valueOf(Kint), child);
        } else if (K2.getTextStreamValue(36) == null && debug) {
            System.out.println("unimplemented " + K2.getObjectRefAsString());
        }
        if (debug) {
            System.out.println(indent + "child node read " + K2.getObjectRefAsString());
            indent = indent.substring(0, indent.length() - 3);
        }
    }

    private void addContentToNode(Map<String, String> pageStream, String Kint, Element child) {
        String text = pageStream.get(Kint);
        if (text != null) {
            text = MarkedContentGenerator.handleXMLCharacters(text);
            if (this.doc != null) {
                Text textNode = this.doc.createTextNode(text);
                child.appendChild(textNode);
            }
        }
        if (debug) {
            System.out.println(indent + " added " + text);
        }
    }

    private static String handleXMLCharacters(String text) {
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        return text;
    }

    private void readKarray(PdfArrayIterator Karray, Element root, Map<String, String> pageStream, String fullS) {
        int count = Karray.getTokenCount();
        for (int i = 0; i < count; ++i) {
            byte[] Kbyte = Karray.getNextValueAsByte(true);
            String KValue = new String(Kbyte);
            if (debug) {
                System.out.println(indent + "aK value=" + KValue);
            }
            if (KValue.contains("R")) {
                MCObject kidObj = MarkedContentGenerator.getMCObjectFromRefOrDirect(this.currentPdfFile, Kbyte);
                this.currentPdfFile.readObject(kidObj);
                this.readChildNode(kidObj, root, pageStream, fullS);
                continue;
            }
            this.addContentToNode(pageStream, KValue, root);
        }
    }

    private static String cleanName(String s) {
        StringBuilder cleanedS = new StringBuilder(10);
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (c == 35) {
                StringBuilder num = new StringBuilder(2);
                for (int j = 0; j < 2; ++j) {
                    num.append(s.charAt(++i));
                }
                c = (char)Integer.parseInt(num.toString(), 16);
                if (!Character.isLetterOrDigit((char)c)) {
                    c = 45;
                }
            }
            if (c == 32) {
                cleanedS.append('-');
                continue;
            }
            if (c == 45) {
                cleanedS.append('-');
                continue;
            }
            if (c == 95) {
                cleanedS.append('_');
                continue;
            }
            if (!Character.isLetterOrDigit((char)c)) continue;
            cleanedS.append((char)c);
        }
        s = cleanedS.toString();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decodePageForMarkedContent(int pageNumber, PdfObject pdfObject, Object pageStream) {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
        } else {
            if (pdfObject == null) {
                String currentPageOffset = this.currentPdfFile.getReferenceforPage(pageNumber);
                pdfObject = new PageObject(currentPageOffset);
                this.currentPdfFile.readObject(pdfObject);
            } else {
                pageNumber = this.currentPdfFile.convertObjectToPageNumber(new String(pdfObject.getUnresolvedData()));
                this.currentPdfFile.checkResolved(pdfObject);
            }
            try {
                this.isDecoding = true;
                ObjectStore objectStoreRef = new ObjectStore();
                PdfStreamDecoder current = new PdfStreamDecoder(this.currentPdfFile, this.layers);
                current.setParameters(true, false, 0, 7, false, false);
                current.setXMLExtraction(false);
                current.setObjectValue(-9, "markedContent");
                current.setObjectValue(-8, objectStoreRef);
                current.setObjectValue(-3, null);
                current.setObjectValue(-18, this.pdfPageData);
                current.setIntValue(-10, pageNumber);
                current.setRenderer(new SwingDisplay(pageNumber, objectStoreRef, false));
                this.res.setupResources(current, false, pdfObject.getDictionary(2004251818), pageNumber, this.currentPdfFile);
                current.setObjectValue(-5, pageStream);
                if (debug) {
                    System.out.println(indent + " about to decode page " + pdfObject.getObjectRefAsString());
                }
                current.decodePageContent(pdfObject);
                objectStoreRef.flush();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            finally {
                this.isDecoding = false;
            }
        }
    }

    private static MCObject getMCObjectFromRefOrDirect(PdfObjectReader currentPdfFile, byte[] data) {
        MCObject mcObj = new MCObject(new String(data));
        if (data[0] == 60) {
            mcObj.setStatus(2);
        } else {
            mcObj.setStatus(1);
        }
        mcObj.setUnresolvedData(data, 487790868);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(mcObj);
        return mcObj;
    }

    static {
        indent = "";
    }
}

