/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

class ComboAP {
    private static final Color acrobatColor = new Color(255, 255, 255);

    ComboAP() {
    }

    static void draw(BufferedImage image, FormAppearanceObject XObject2) {
        int[] mattes = XObject2.getMatteBorderDetails();
        if (mattes != null) {
            ComboAP.drawMattedComboBox(image, mattes);
        } else {
            int stroke = XObject2.getBorderStroke();
            switch (stroke) {
                case 0: {
                    ComboAP.drawComboBox(image);
                }
            }
        }
    }

    private static void drawMattedComboBox(BufferedImage image, int[] mattes) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color color = acrobatColor;
        if (color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255) {
            g2.setColor(color);
            g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        }
        g2.setColor(Color.BLACK);
        block6: for (int i = 0; i < mattes.length; ++i) {
            if (mattes[i] == 0) continue;
            switch (i) {
                case 0: {
                    g2.drawLine(0, 0, width, 0);
                    continue block6;
                }
                case 1: {
                    g2.drawLine(width, 0, width, height);
                    continue block6;
                }
                case 2: {
                    g2.drawLine(width, height, 0, height);
                    continue block6;
                }
                case 3: {
                    g2.drawLine(0, height, 0, 0);
                }
            }
        }
    }

    private static void drawComboBox(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        Color lightGrey = new Color(212, 208, 200);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
        g2.setColor(lightGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(acrobatColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
    }
}

