/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class SoundObject
extends PdfObject {
    private byte[] rawE;
    private String E;
    private int B = -1;
    private int Cint = -1;
    private int R = -1;

    public SoundObject(String ref) {
        super(ref);
    }

    public SoundObject(int ref, int gen) {
        super(ref, gen);
    }

    @Override
    public void setIntNumber(int id, int value) {
        switch (id) {
            case 18: {
                this.B = value;
                break;
            }
            case 19: {
                this.Cint = value;
                break;
            }
            case 34: {
                this.R = value;
                break;
            }
            default: {
                super.setIntNumber(id, value);
            }
        }
    }

    @Override
    public int getInt(int id) {
        switch (id) {
            case 18: {
                return this.B;
            }
            case 19: {
                return this.Cint;
            }
            case 34: {
                return this.R;
            }
        }
        return super.getInt(id);
    }

    @Override
    public void setName(int id, byte[] value) {
        switch (id) {
            case 21: {
                this.rawE = value;
                break;
            }
            default: {
                super.setName(id, value);
            }
        }
    }

    @Override
    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 21: {
                this.rawE = value;
                break;
            }
            default: {
                super.setTextStreamValue(id, value);
            }
        }
    }

    @Override
    public String getName(int id) {
        switch (id) {
            case 21: {
                if (this.E == null && this.rawE != null) {
                    this.E = StringUtils.getTextString(this.rawE, false);
                }
                return this.E;
            }
        }
        return super.getName(id);
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    @Override
    public int getNameAsConstant(int id) {
        byte[] raw;
        switch (id) {
            case 21: {
                raw = this.rawE;
                break;
            }
            default: {
                return super.getNameAsConstant(id);
            }
        }
        if (raw == null) {
            return super.getNameAsConstant(id);
        }
        return PdfDictionary.generateChecksum(0, raw.length, raw);
    }

    @Override
    public int getObjectType() {
        return 1061502534;
    }
}

