/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.utils.LogWriter;

public class SwingFormCreator {
    private static final ClassLoader loader = SwingFormCreator.class.getClassLoader();
    private static final String viewerClassPath = "org/jpedal/objects/acroforms/creation/SwingFormFactory.class";
    private static final String viewerClassName = "org.jpedal.objects.acroforms.creation.SwingFormFactory";
    private static final String dataClassPath = "org/jpedal/objects/acroforms/SwingData.class";
    private static final String dataClassName = "org.jpedal.objects.acroforms.SwingData";

    public GUIData getData() {
        GUIData newData = null;
        if (loader.getResource(dataClassPath) != null) {
            try {
                newData = (GUIData)loader.loadClass(dataClassName).newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                newData = null;
                LogWriter.writeLog("[PDF] Unable to instance SwingData " + ex);
            }
        }
        if (newData == null) {
            newData = new GUIData();
        }
        return newData;
    }

    public FormFactory createFormFactory() {
        FormFactory newFormFactory = null;
        if (loader.getResource(viewerClassPath) != null) {
            try {
                newFormFactory = (FormFactory)loader.loadClass(viewerClassName).newInstance();
            }
            catch (Exception ex) {
                LogWriter.writeLog("[PDF] Unable to instance Form Factory " + ex);
            }
        }
        if (newFormFactory == null) {
            newFormFactory = new GenericFormFactory();
        }
        return newFormFactory;
    }
}

