/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class AnnotationFactory {
    private static final int STYLE_KEY_FONT = 1718578804;
    private static final int STYLE_KEY_TEXT = 1952807028;
    private static final int STYLE_KEY_COLOR = 1668246639;

    public static BufferedImage getIcon(PdfObject form) {
        return AnnotationFactory.getIcon(form, 1.0f);
    }

    public static BufferedImage getIcon(PdfObject form, float scaling) {
        switch (form.getParameterConstant(1147962727)) {
            case 607471684: {
                return AnnotationFactory.getTextIcon(form);
            }
            case 1919840408: {
                return AnnotationFactory.getHightlightIcon(form, scaling);
            }
            case 1160865142: {
                return AnnotationFactory.getSquareIcon(form, scaling);
            }
            case 2053993372: {
                return AnnotationFactory.getUnderLineIcon(form);
            }
            case 2036432546: {
                return AnnotationFactory.getStrikeOutIcon(form);
            }
            case 826422615: {
                return AnnotationFactory.getCaretIcon(form);
            }
            case -1113876231: {
                return AnnotationFactory.getFileAttachmentIcon();
            }
            case 473513525: {
                return AnnotationFactory.getLineIcon(form, scaling);
            }
            case 1230470778: {
                return AnnotationFactory.getPolyIcon(form, false, scaling);
            }
            case 1014528638: {
                return AnnotationFactory.getPolyIcon(form, true, scaling);
            }
            case 1110658926: {
                return AnnotationFactory.getCircleIcon(form, scaling);
            }
            case 1517846914: {
                return AnnotationFactory.getSquigglyIcon(form);
            }
            case 1061502534: {
                return AnnotationFactory.getSoundIcon(form);
            }
            case 1654331: {
                return AnnotationFactory.getInkIcon((FormObject)form, scaling);
            }
        }
        return null;
    }

    private static BufferedImage getInkIcon(FormObject form, float scaling) {
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds(form, quad, scaling);
            float[][] InkListArray = form.getFloat2DArray(475169151);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon1 = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g2 = (Graphics2D)icon1.getGraphics();
                AnnotationFactory.setStroke(form, g2, scaling);
                float[] r = AnnotationFactory.scanInkListFloatTree(InkListArray, form, g2, scaling);
                if (r != null) {
                    form.setFloatArray(573911876, new float[]{r[0], r[1], r[2], r[3]});
                }
                return icon1;
            }
        }
        return null;
    }

    private static float[] scanInkListFloatTree(float[][] InkListArray, PdfObject form, Graphics g, float scaling) {
        float[] quad = form.getFloatArray(573911876);
        if (quad == null) {
            return null;
        }
        Rectangle2D bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
        Graphics2D g2 = (Graphics2D)g;
        AnnotationFactory.setStroke(form, g2, scaling);
        if (InkListArray != null) {
            if (g != null) {
                float[] underlineColor = form.getFloatArray(19);
                Color c1 = new Color(0);
                if (underlineColor != null) {
                    switch (underlineColor.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c1 = new Color(underlineColor[0], underlineColor[0], underlineColor[0], 1.0f);
                            break;
                        }
                        case 3: {
                            c1 = new Color(underlineColor[0], underlineColor[1], underlineColor[2], 1.0f);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(underlineColor, 4);
                            c1 = new Color(cmyk.getColor().getRGB());
                            break;
                        }
                    }
                }
                g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                g2.fillRect(0, 0, (int)((RectangularShape)bounds).getWidth(), (int)((RectangularShape)bounds).getHeight());
                g2.setColor(c1);
                g2.setPaint(c1);
            }
            for (float[] coords : InkListArray) {
                if (coords.length < 4) {
                    if (g2 == null) continue;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Line2D.Float line = new Line2D.Float(coords[0], coords[1], coords[0], coords[1]);
                    g2.draw(line);
                    continue;
                }
                if (coords.length < 6) {
                    if (g2 == null) continue;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (int i = 0; i < coords.length; i += 4) {
                        Line2D.Float line = new Line2D.Float(coords[0], coords[1], coords[2], coords[3]);
                        g2.draw(line);
                    }
                    continue;
                }
                float[] values = AnnotationFactory.createInkCurve(coords);
                if (g2 == null) continue;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i = 0; i < values.length - 7; i += 6) {
                    CubicCurve2D.Double curve = new CubicCurve2D.Double(values[i], values[i + 1], values[i + 2], values[i + 3], values[i + 4], values[i + 5], values[i + 6], values[i + 7]);
                    g2.draw(curve);
                    bounds = ((Rectangle2D)bounds).createUnion(curve.getBounds2D());
                }
            }
        }
        form.setFloatArray(573911876, new float[]{(float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY()});
        return form.getFloatArray(573911876);
    }

    private static Color convertFloatArrayToColor(float[] values) {
        Color c = new Color(0, 0, 0, 0);
        if (values != null) {
            switch (values.length) {
                case 0: {
                    break;
                }
                case 1: {
                    c = new Color(values[0], values[0], values[0]);
                    break;
                }
                case 3: {
                    c = new Color(values[0], values[1], values[2]);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(values, 4);
                    c = new Color(cmyk.getColor().getRGB());
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue());
                    break;
                }
            }
        }
        return c;
    }

    private static Rectangle getFormBounds(FormObject form, float[] rect, float scaling) {
        Rectangle bounds = form.getBoundingRectangle();
        if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
            for (int i = 0; i != rect.length; ++i) {
                if (i % 2 == 0) {
                    if ((float)bounds.x > rect[i]) {
                        bounds.x = (int)rect[i];
                    }
                    if (!((float)(bounds.x + bounds.width) < rect[i])) continue;
                    bounds.width = (int)(rect[i] - (float)bounds.x);
                    continue;
                }
                if ((float)bounds.y > rect[i]) {
                    bounds.y = (int)rect[i];
                }
                if (!((float)(bounds.y + bounds.height) < rect[i])) continue;
                bounds.height = (int)(rect[i] - (float)bounds.y);
            }
        }
        bounds.x = (int)((float)bounds.x * scaling + 0.5f);
        bounds.y = (int)((float)bounds.y * scaling + 0.5f);
        bounds.width = (int)((float)bounds.width * scaling + 0.5f);
        bounds.height = (int)((float)bounds.height * scaling + 0.5f);
        return bounds;
    }

    private static BufferedImage getStrikeOutIcon(PdfObject form) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics g = icon.getGraphics();
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - bounds.x;
                    int y = (int)quad[hi + 5] - bounds.y;
                    y = bounds.height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    try {
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g.fillRect(0, 0, width, height);
                        g.setColor(color);
                        g.fillRect(x, y + height / 2, width, 1);
                        continue;
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getUnderLineIcon(PdfObject form) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics g = icon.getGraphics();
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - bounds.x;
                    int y = (int)quad[hi + 5] - bounds.y;
                    y = bounds.height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    try {
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        g.fillRect(x, y, width, height);
                        g.setColor(color);
                        g.fillRect(x, y + height - 1, width, 1);
                        continue;
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getSquigglyIcon(PdfObject form) {
        Color color = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
        if (bounds.width > 0 && bounds.height > 0) {
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics g = icon.getGraphics();
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - bounds.x;
                    int y = (int)quad[hi + 5] - bounds.y;
                    y = bounds.height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    int step = 6;
                    int bottom = y + height - 1;
                    int top = bottom - 3;
                    try {
                        g.setColor(color);
                        for (int i = 0; i < width; i += 6) {
                            g.drawLine(x + i, bottom, x + i + 3, top);
                            g.drawLine(x + i + 3, top, x + i + 6, bottom);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getSquareIcon(PdfObject form, float scaling) {
        Color c = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419));
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g = (Graphics2D)icon.getGraphics();
                int width = AnnotationFactory.setStroke(form, g, scaling);
                g.setColor(ic);
                g.fillRect(0, 0, bounds.width, bounds.height);
                g.setColor(c);
                g.drawRect(width / 2, width / 2, bounds.width - width, bounds.height - width);
                return icon;
            }
        }
        return null;
    }

    private static int setStroke(PdfObject form, Graphics2D g, float scaling) {
        int borderWidth = 1;
        PdfObject BS = form.getDictionary(4643);
        if (BS != null && g != null) {
            String s = BS.getName(35);
            borderWidth = BS.getInt(39);
            if (borderWidth == -1) {
                borderWidth = 1;
            }
            PdfArrayIterator d = BS.getMixedArray(20);
            if (s == null || s.equals("S")) {
                borderWidth = (int)((float)borderWidth * scaling);
                g.setStroke(new BasicStroke(borderWidth));
            } else if (s.equals("D")) {
                int count;
                float[] dash = new float[]{3.0f};
                if (d != null && d.hasMoreTokens() && (count = d.getTokenCount()) > 0) {
                    dash = d.getNextValueAsFloatArray();
                }
                borderWidth = (int)((float)borderWidth * scaling);
                g.setStroke(new BasicStroke(borderWidth, 2, 0, 10.0f, dash, 0.0f));
            }
        }
        if (borderWidth < 1) {
            borderWidth = 1;
        }
        return borderWidth;
    }

    private static BufferedImage getCircleIcon(PdfObject form, float scaling) {
        Color c = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419));
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g = (Graphics2D)icon.getGraphics();
                int width = AnnotationFactory.setStroke(form, g, scaling);
                g.setColor(ic);
                g.fillOval(width / 2, width / 2, bounds.width - width, bounds.height - width);
                g.setColor(c);
                g.drawOval(width / 2, width / 2, bounds.width - width, bounds.height - width);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getLineIcon(PdfObject form, float scaling) {
        Color c = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        float[] quad = form.getFloatArray(573911876);
        float[] line = form.getFloatArray(28);
        if (quad != null && line != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g = (Graphics2D)icon.getGraphics();
                AnnotationFactory.setStroke(form, g, scaling);
                g.setColor(c);
                g.drawLine((int)(line[0] * scaling) - bounds.x, (int)((float)bounds.height - (line[1] * scaling - (float)bounds.y)), (int)(line[2] * scaling) - bounds.x, (int)((float)bounds.height - (line[3] * scaling - (float)bounds.y)));
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getPolyIcon(PdfObject form, boolean line, float scaling) {
        Color c = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        Color ic = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(6419));
        float[] quad = form.getFloatArray(573911876);
        float[] vertices = form.getFloatArray(1600681863);
        if (quad != null && vertices != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, scaling);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g = (Graphics2D)icon.getGraphics();
                AnnotationFactory.setStroke(form, g, scaling);
                GeneralPath gPath = new GeneralPath(1);
                gPath.moveTo((int)(vertices[0] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[1] * scaling - (float)bounds.y)));
                for (int i = 2; i != vertices.length; i += 2) {
                    gPath.lineTo((int)(vertices[i] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[i + 1] * scaling - (float)bounds.y)));
                }
                if (!line) {
                    gPath.lineTo((int)(vertices[0] * scaling) - bounds.x, (int)((float)bounds.height - (vertices[1] * scaling - (float)bounds.y)));
                    g.setColor(ic);
                    g.fill(gPath);
                }
                g.setColor(c);
                g.draw(gPath);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getCaretIcon(PdfObject form) {
        Color c = AnnotationFactory.convertFloatArrayToColor(form.getFloatArray(19));
        float[] rd = form.getFloatArray(8724);
        float[] quad = form.getFloatArray(573911876);
        if (quad != null) {
            Rectangle bounds = AnnotationFactory.getFormBounds((FormObject)form, quad, 1.0f);
            if (bounds.width > 0 && bounds.height > 0) {
                BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
                Graphics2D g = (Graphics2D)icon.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.setStroke(new BasicStroke(rd[1]));
                g.setColor(c);
                g.drawLine(0, bounds.height, bounds.width / 2, 0);
                g.drawLine(bounds.width / 2, 0, bounds.width, bounds.height);
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getHightlightIcon(PdfObject form, float scaling) {
        float[] quad;
        float[] f = form.getFloatArray(19);
        Color c = new Color(0);
        if (f != null) {
            switch (f.length) {
                case 0: {
                    break;
                }
                case 1: {
                    c = new Color(f[0], f[0], f[0], 0.5f);
                    break;
                }
                case 3: {
                    c = new Color(f[0], f[1], f[2], 0.5f);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(f, 4);
                    c = new Color(cmyk.getColor().getRGB());
                    c = new Color((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue(), 0.5f);
                    break;
                }
            }
        }
        if ((quad = form.getFloatArray(1785890247)) != null) {
            Rectangle bounds = ((FormObject)form).getBoundingRectangle();
            if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                for (int i = 0; i != quad.length; ++i) {
                    if (i % 2 == 0) {
                        if ((float)bounds.x > quad[i]) {
                            bounds.x = (int)quad[i];
                        }
                        if (!((float)(bounds.x + bounds.width) < quad[i])) continue;
                        bounds.width = (int)(quad[i] - (float)bounds.x);
                        continue;
                    }
                    if ((float)bounds.y > quad[i]) {
                        bounds.y = (int)quad[i];
                    }
                    if (!((float)(bounds.y + bounds.height) < quad[i])) continue;
                    bounds.height = (int)(quad[i] - (float)bounds.y);
                }
            }
            int scaledWidth = (int)((float)bounds.width * scaling);
            int scaledHeight = (int)((float)bounds.height * scaling);
            if (scaledWidth > 0 && (float)scaledHeight * scaling > 0.0f) {
                BufferedImage icon = new BufferedImage(scaledWidth, scaledHeight, 6);
                Graphics g = icon.getGraphics();
                if (quad.length >= 8) {
                    for (int hi = 0; hi != quad.length; hi += 8) {
                        float x1 = quad[hi];
                        float x2 = quad[hi + 2];
                        float y1 = quad[hi + 1];
                        float y2 = quad[hi + 3];
                        for (int j = 0; j < 8; ++j) {
                            if (j % 2 == 0) {
                                if (quad[hi + j] < x1) {
                                    x1 = quad[hi + j];
                                }
                                if (!(quad[hi + j] > x2)) continue;
                                x2 = quad[hi + j];
                                continue;
                            }
                            if (quad[hi + j] < y1) {
                                y1 = quad[hi + j];
                            }
                            if (!(quad[hi + j] > y2)) continue;
                            y2 = quad[hi + j];
                        }
                        int x = (int)x1 - bounds.x;
                        int y = (int)y1 - bounds.y;
                        y = bounds.height - y - (int)(y2 - y1);
                        int width = (int)(x2 - x1);
                        int height = (int)(y2 - y1);
                        Rectangle rh = new Rectangle((int)((float)x * scaling), (int)((float)y * scaling), (int)((float)width * scaling), (int)((float)height * scaling));
                        g.setColor(c);
                        g.fillRect(rh.x, rh.y, rh.width, rh.height);
                    }
                }
                return icon;
            }
        }
        return null;
    }

    private static BufferedImage getTextIcon(PdfObject form) {
        String iconFile = AnnotationFactory.getPngImageForAnnotation(form);
        BufferedImage commentIcon = null;
        try {
            commentIcon = ImageIO.read(AnnotationFactory.class.getResource(iconFile));
            if (commentIcon != null) {
                float[] rect = form.getFloatArray(573911876);
                rect[1] = rect[3] - (float)commentIcon.getHeight();
                rect[2] = rect[0] + (float)commentIcon.getWidth();
                form.setFloatArray(573911876, rect);
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        AnnotationFactory.setColorForAnnotation(form, commentIcon);
        return commentIcon;
    }

    public static void loadFontValues(byte[] DS, Component textInput, float scaling) {
        Font font = new Font("Lucida", 0, 12);
        int position = 0;
        while (position < DS.length) {
            while (DS[position] == 32 || DS[position] == 10 || DS[position] == 13) {
                ++position;
            }
            int key = (DS[position++] << 24) + (DS[position++] << 16) + (DS[position++] << 8) + DS[position++];
            block0 : switch (key) {
                case 1718578804: {
                    switch (DS[position]) {
                        case 58: {
                            if (DS[++position] == 32) {
                                ++position;
                            }
                            StringBuilder name = new StringBuilder();
                            while (position < DS.length && DS[position] != 32) {
                                name.append((char)DS[position]);
                                ++position;
                            }
                            ++position;
                            StringBuilder size = new StringBuilder();
                            while (position < DS.length && DS[position] >= 48 && DS[position] <= 57) {
                                size.append((char)DS[position]);
                                ++position;
                            }
                            while (position < DS.length && DS[position] != 59) {
                                ++position;
                            }
                            ++position;
                            String fontName = StandardFonts.expandName(name.toString());
                            String altName = FontMappings.fontSubstitutionAliasTable.get(fontName.toLowerCase());
                            if (altName != null) {
                                fontName = altName;
                            }
                            fontName = StandardFonts.expandName(fontName);
                            if (size.length() <= 0) break block0;
                            int fontSize = (int)((float)Integer.parseInt(size.toString()) * scaling);
                            font = new Font(fontName, 0, fontSize);
                            break block0;
                        }
                        case 45: {
                            while (position < DS.length && DS[position] != 59) {
                                ++position;
                            }
                            ++position;
                            break block0;
                        }
                    }
                    LogWriter.writeLog("Unknown style key for FreeText annotation.");
                    break;
                }
                case 1952807028: {
                    while (position < DS.length && DS[position] != 59) {
                        ++position;
                    }
                    ++position;
                    break;
                }
                case 1668246639: {
                    while (position < DS.length && DS[position] != 58) {
                        ++position;
                    }
                    if (DS[++position] == 32) {
                        ++position;
                    }
                    if (DS[position] == 35) {
                        StringBuilder colString = new StringBuilder();
                        while (position < DS.length && DS[position] != 59) {
                            colString.append((char)DS[position]);
                            ++position;
                        }
                        Color c = new Color(Integer.valueOf(colString.substring(1, 3), 16), Integer.valueOf(colString.substring(3, 5), 16), Integer.valueOf(colString.substring(5, 7), 16));
                        textInput.setForeground(c);
                        break;
                    }
                    LogWriter.writeLog("Unknown color for FreeText annotation.");
                }
            }
        }
        textInput.setFont(font);
    }

    private static void setColorForAnnotation(PdfObject form, BufferedImage commentIcon) {
        float[] col = form.getFloatArray(19);
        if (col == null) {
            col = new float[]{1.0f, 1.0f, 1.0f};
        }
        Color c = new Color(col[0], col[1], col[2]);
        int rgb = c.getRGB();
        for (int x = 0; x != commentIcon.getWidth(); ++x) {
            for (int y = 0; y != commentIcon.getHeight(); ++y) {
                if (commentIcon.getRGB(x, y) != -256) continue;
                commentIcon.setRGB(x, y, rgb);
            }
        }
    }

    public static String getPngImageForAnnotation(PdfObject form) {
        String name = form.getName(506543413);
        if (name == null) {
            name = "Note";
        }
        if (name.equals("Comment")) {
            return "/org/jpedal/objects/acroforms/res/comment.png";
        }
        if (name.equals("Check")) {
            return "/org/jpedal/objects/acroforms/res/Check.png";
        }
        if (name.equals("Checkmark")) {
            return "/org/jpedal/objects/acroforms/res/Checkmark.png";
        }
        if (name.equals("Circle")) {
            return "/org/jpedal/objects/acroforms/res/Circle.png";
        }
        if (name.equals("Cross")) {
            return "/org/jpedal/objects/acroforms/res/Cross.png";
        }
        if (name.equals("CrossHairs")) {
            return "/org/jpedal/objects/acroforms/res/CrossHairs.png";
        }
        if (name.equals("Help")) {
            return "/org/jpedal/objects/acroforms/res/Help.png";
        }
        if (name.equals("Insert")) {
            return "/org/jpedal/objects/acroforms/res/InsertText.png";
        }
        if (name.equals("Key")) {
            return "/org/jpedal/objects/acroforms/res/Key.png";
        }
        if (name.equals("NewParagraph")) {
            return "/org/jpedal/objects/acroforms/res/NewParagraph.png";
        }
        if (name.equals("Paragraph")) {
            return "/org/jpedal/objects/acroforms/res/Paragraph.png";
        }
        if (name.equals("RightArrow")) {
            return "/org/jpedal/objects/acroforms/res/RightArrow.png";
        }
        if (name.equals("RightPointer")) {
            return "/org/jpedal/objects/acroforms/res/RightPointer.png";
        }
        if (name.equals("Star")) {
            return "/org/jpedal/objects/acroforms/res/Star.png";
        }
        if (name.equals("UpLeftArrow")) {
            return "/org/jpedal/objects/acroforms/res/Up-LeftArrow.png";
        }
        if (name.equals("UpArrow")) {
            return "/org/jpedal/objects/acroforms/res/UpArrow.png";
        }
        return "/org/jpedal/objects/acroforms/res/TextNote.png";
    }

    private static BufferedImage getFileAttachmentIcon() {
        String iconFile = "/org/jpedal/objects/acroforms/res/FileAttachment.png";
        BufferedImage icon = null;
        try {
            icon = ImageIO.read(AnnotationFactory.class.getResource("/org/jpedal/objects/acroforms/res/FileAttachment.png"));
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return icon;
    }

    private static BufferedImage getSoundIcon(PdfObject form) {
        String iconFile = "/org/jpedal/objects/acroforms/res/Speaker.png";
        String name = form.getName(506543413);
        if (name != null && name.equals("Mic")) {
            iconFile = "/org/jpedal/objects/acroforms/res/Microphone.png";
        }
        BufferedImage icon = null;
        try {
            icon = ImageIO.read(AnnotationFactory.class.getResource(iconFile));
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return icon;
    }

    public static void renderFlattenedAnnotation(PdfObject form, DynamicVectorRenderer current, int pageNumber, int rotation) {
        BufferedImage image = AnnotationFactory.getIcon(form);
        if (image != null) {
            GraphicsState gs = new GraphicsState();
            int iconHeight = image.getHeight();
            int iconWidth = image.getWidth();
            float[] rect = form.getFloatArray(573911876);
            if (form.getParameterConstant(1147962727) == 607471684) {
                rect[2] = rect[0] + (float)iconWidth;
                rect[1] = rect[3] - (float)iconHeight;
                form.setFloatArray(573911876, rect);
                switch (rotation % 360) {
                    case 0: {
                        gs.CTM = new float[][]{{iconWidth, 0.0f, 1.0f}, {0.0f, iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0];
                        gs.y = rect[3] - (float)iconHeight;
                        gs.CTM[2][0] = rect[0];
                        gs.CTM[2][1] = rect[3] - (float)iconHeight;
                        break;
                    }
                    case 90: {
                        gs.CTM = new float[][]{{0.0f, iconWidth, 1.0f}, {-iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0] + (float)iconHeight;
                        gs.y = rect[3];
                        gs.CTM[2][0] = rect[0] + (float)iconHeight;
                        gs.CTM[2][1] = rect[3];
                        break;
                    }
                    case 180: {
                        gs.CTM = new float[][]{{-iconWidth, 0.0f, 1.0f}, {0.0f, -iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0];
                        gs.y = rect[3] + (float)iconHeight;
                        gs.CTM[2][0] = rect[0];
                        gs.CTM[2][1] = rect[3] + (float)iconHeight;
                        break;
                    }
                    case 270: {
                        gs.CTM = new float[][]{{0.0f, -iconWidth, 1.0f}, {iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                        gs.x = rect[0] - (float)iconHeight;
                        gs.y = rect[3];
                        gs.CTM[2][0] = rect[0] - (float)iconHeight;
                        gs.CTM[2][1] = rect[3];
                    }
                }
            } else {
                gs.CTM = new float[][]{{iconWidth, 0.0f, 1.0f}, {0.0f, iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                gs.x = rect[0];
                gs.y = rect[3] - (float)iconHeight;
                gs.CTM[2][0] = rect[0];
                gs.CTM[2][1] = rect[3] - (float)iconHeight;
            }
            if (form.getParameterConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111181679);
                current.setGraphicsState(2, gs.getAlpha(2), 1111181679);
            }
            current.drawImage(pageNumber, image, gs, false, form.getObjectRefAsString(), -1);
            if (form.getParameterConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
                current.setGraphicsState(2, gs.getAlpha(2), 1111314299);
            }
        }
    }

    public static String getCurrentDateAsString() {
        Calendar cal = Calendar.getInstance();
        String date = "D:" + cal.get(1) + String.format("%02d", cal.get(2) + 1) + String.format("%02d", cal.get(5)) + String.format("%02d", cal.get(11)) + String.format("%02d", cal.get(12)) + String.format("%02d", cal.get(13));
        int offset = cal.getTimeZone().getOffset(System.currentTimeMillis());
        if (offset > 0) {
            date = date + '+';
        }
        if (offset != 0) {
            date = date + String.format("%02d", offset / 1000 / 3600);
            date = date + '\'';
            date = date + String.format("%02d", offset / 1000 % 3600 / 60);
            date = date + '\'';
        }
        return date;
    }

    public static float[] createInkCurve(float[] points) {
        float[] inkPoint = new float[points.length];
        inkPoint[0] = points[0];
        inkPoint[1] = points[1];
        int duplicateIDX = 2;
        for (int i = 2; i != points.length; i += 2) {
            if (inkPoint[duplicateIDX - 2] == points[i] && inkPoint[duplicateIDX - 1] == points[i + 1]) continue;
            inkPoint[duplicateIDX] = points[i];
            inkPoint[duplicateIDX + 1] = points[i + 1];
            duplicateIDX += 2;
        }
        inkPoint = Arrays.copyOf(inkPoint, duplicateIDX);
        float[] curvePoints = new float[inkPoint.length * 3 - 4];
        curvePoints[0] = inkPoint[0];
        curvePoints[1] = inkPoint[1];
        float[] controlPoints = AnnotationFactory.getControlPoints(inkPoint[0], inkPoint[1], inkPoint[0], inkPoint[1], inkPoint[2], inkPoint[3]);
        curvePoints[2] = controlPoints[2];
        curvePoints[3] = controlPoints[3];
        int idx = 4;
        for (int i = 2; i != inkPoint.length - 2; i += 2) {
            controlPoints = AnnotationFactory.getControlPoints(inkPoint[i - 2], inkPoint[i - 1], inkPoint[i], inkPoint[i + 1], inkPoint[i + 2], inkPoint[i + 3]);
            curvePoints[idx] = controlPoints[0];
            curvePoints[++idx] = controlPoints[1];
            curvePoints[++idx] = inkPoint[i];
            curvePoints[++idx] = inkPoint[i + 1];
            curvePoints[++idx] = controlPoints[2];
            curvePoints[++idx] = controlPoints[3];
            ++idx;
        }
        controlPoints = AnnotationFactory.getControlPoints(inkPoint[inkPoint.length - 4], inkPoint[inkPoint.length - 3], inkPoint[inkPoint.length - 2], inkPoint[inkPoint.length - 1], inkPoint[inkPoint.length - 2], inkPoint[inkPoint.length - 1]);
        curvePoints[curvePoints.length - 4] = controlPoints[0];
        curvePoints[curvePoints.length - 3] = controlPoints[1];
        curvePoints[curvePoints.length - 2] = inkPoint[inkPoint.length - 2];
        curvePoints[curvePoints.length - 1] = inkPoint[inkPoint.length - 1];
        return curvePoints;
    }

    private static float[] getControlPoints(float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
        float[] controls = new float[4];
        float sideA = p1x - p3x;
        float sideB = p1y - p3y;
        float sideC = (float)Math.sqrt(sideA * sideA + sideB * sideB);
        float length1 = (float)Math.sqrt((p1x - p2x) * (p1x - p2x) + (p1y - p2y) * (p1y - p2y)) / 3.0f;
        float scale1 = length1 / sideC;
        controls[0] = p2x + sideA * scale1;
        controls[1] = p2y + sideB * scale1;
        float length2 = (float)Math.sqrt((p2x - p3x) * (p2x - p3x) + (p2y - p3y) * (p2y - p3y)) / 3.0f;
        float scale2 = length2 / sideC;
        controls[2] = p2x - sideA * scale2;
        controls[3] = p2y - sideB * scale2;
        return controls;
    }
}

