/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class DestHandler {
    public static PdfArrayIterator getDestFromObject(PdfObject formObj, PdfObjectReader currentPdfFile) {
        String DestString;
        PdfArrayIterator Dest = formObj.getMixedArray(339034948);
        if (Dest == null || Dest.getTokenCount() == 0) {
            PdfObject Dobj;
            PdfObject Aobj = formObj.getDictionary(17);
            if (Aobj == null) {
                Aobj = formObj.getDictionary(4369);
            }
            if (Aobj != null) {
                formObj = Aobj;
            }
            if ((Dobj = formObj.getDictionary(20)) != null) {
                formObj = Dobj;
            }
            Dest = formObj.getMixedArray(20);
        }
        if ((DestString = formObj.getTextStreamValue(20)) != null) {
            Dest = DestHandler.decodeDest(DestString, currentPdfFile, Dest);
        } else if (Dest != null && Dest.getTokenCount() > 0 && !Dest.isNextValueRef()) {
            Dest = DestHandler.decodeDest(Dest.getNextValueAsString(false), currentPdfFile, Dest);
        }
        return Dest;
    }

    public static int getPageNumberFromLink(PdfArrayIterator dest, PdfObjectReader currentPdfFile) {
        int page = -1;
        if (dest.hasMoreTokens()) {
            int possiblePage;
            String pageRef = dest.getNextValueAsString(false);
            page = currentPdfFile.convertObjectToPageNumber(pageRef);
            if (page == -1 && dest.getTokenCount() > 2 && !pageRef.contains(" R") && !pageRef.isEmpty() && dest.hasMoreTokens() && (possiblePage = dest.getNextValueAsInteger(false) + 1) > 0) {
                page = possiblePage;
            }
            if (page == -1 && dest.isNextValueNumber() && (possiblePage = dest.getNextValueAsInteger(false) + 1) > 0) {
                page = possiblePage;
            }
        }
        return page;
    }

    private static PdfArrayIterator convertRef(String ref, PdfObjectReader currentPdfFile) {
        if (ref.charAt(0) == '[') {
            return DestHandler.converDestStringToMixedArray(ref, currentPdfFile, new OutlineObject(ref));
        }
        return DestHandler.decodeDest(ref, currentPdfFile, null);
    }

    private static PdfArrayIterator converDestStringToMixedArray(String ref, PdfObjectReader currentPdfFile, PdfObject aData) {
        byte[] raw = StringUtils.toBytes(ref);
        Array objDecoder = new Array(currentPdfFile.getObjectReader(), 0, 18, raw);
        objDecoder.readArray(aData, 339034948);
        return aData.getMixedArray(339034948);
    }

    private static PdfArrayIterator decodeDest(String nameString, PdfObjectReader currentPdfFile, PdfArrayIterator DestObj) {
        byte[] rawRef;
        if (nameString.startsWith("/")) {
            nameString = nameString.substring(1);
        }
        if (!StreamReaderUtils.isRef(rawRef = nameString.getBytes(), 0)) {
            nameString = currentPdfFile.convertNameToRef(nameString);
        }
        if (nameString != null && StreamReaderUtils.isRef(rawRef = nameString.getBytes(), 0)) {
            int[] values = StreamReaderUtils.readRefFromStream(rawRef, 0);
            int ref2 = values[0];
            int generation = values[1];
            OutlineObject obj = new OutlineObject(new String(rawRef));
            PdfFileReader objectReader = currentPdfFile.getObjectReader();
            rawRef = objectReader.readObjectAsByteArray(obj, objectReader.isCompressed(ref2, generation), ref2, generation);
            if (rawRef == null) {
                return null;
            }
            int startArray = 0;
            while (rawRef[startArray] != 91 && rawRef[startArray] != 60) {
                ++startArray;
            }
            if (rawRef[startArray] == 91) {
                int length = rawRef.length;
                int newLength = length - startArray;
                byte[] strippedData = new byte[length];
                System.arraycopy(rawRef, startArray, strippedData, 0, newLength);
                nameString = new String(strippedData);
            } else {
                OutlineObject Aobj = new OutlineObject(nameString);
                currentPdfFile.readObject(Aobj);
                DestObj = Aobj.getMixedArray(20);
                String DestString = Aobj.getTextStreamValue(20);
                if (DestString != null) {
                    nameString = DestString;
                }
            }
        }
        if (nameString != null && nameString.startsWith("[")) {
            DestObj = DestHandler.converDestStringToMixedArray(nameString, currentPdfFile, new OutlineObject(nameString));
        }
        return DestObj;
    }

    public static PdfArrayIterator resolveIfIndirect(PdfObject formObj, PdfArrayIterator dest, PdfObjectReader currentPdfFile) {
        byte[] rawName = formObj.getTextStreamValueAsByte(20);
        if (rawName != null) {
            String name = new String(rawName);
            String ref = currentPdfFile.convertNameToRef(name);
            dest = ref != null ? DestHandler.convertRef(ref, currentPdfFile) : DestHandler.decodeDest(name, currentPdfFile, dest);
        } else if (dest.getTokenCount() == 1) {
            String ref = currentPdfFile.convertNameToRef(dest.getNextValueAsString(false));
            dest = ref != null ? DestHandler.convertRef(ref, currentPdfFile) : DestHandler.decodeDest(dest.getNextValueAsString(false), currentPdfFile, dest);
        }
        return dest;
    }

    private static Float getFloatOrNull(PdfObjectReader currentPdfFile, PdfArrayIterator dest) {
        if (!dest.hasMoreTokens()) {
            return null;
        }
        if (dest.getNextValueAsString(false).equals("null")) {
            dest.getNextValueAsString(true);
            return null;
        }
        if (StreamReaderUtils.isRef(dest.getNextValueAsByte(false), 0)) {
            PdfObject obj = new PdfObject(dest.getNextValueAsString(true));
            byte[] objData = currentPdfFile.getObjectReader().readObjectData(obj);
            int[] ptrs = NumberValue.extractNumberFromIndirectRef(objData);
            return Float.valueOf(NumberUtils.parseFloat(ptrs[0], ptrs[1], objData));
        }
        return Float.valueOf(dest.getNextValueAsFloat());
    }

    public static Object[] getZoomFromDest(PdfObjectReader currentPdfFile, PdfArrayIterator dest) {
        while (dest.hasMoreTokens()) {
            int key = dest.getNextValueAsKey();
            switch (key) {
                case 2631978: {
                    Object[] action = new Object[]{key, "XYZ", DestHandler.getFloatOrNull(currentPdfFile, dest), DestHandler.getFloatOrNull(currentPdfFile, dest), DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
                case 1456452: {
                    Object[] action = new Object[]{key, "Fit"};
                    return action;
                }
                case 372851736: {
                    Object[] action = new Object[]{key, "FitH", DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
                case 372851750: {
                    Object[] action = new Object[]{key, "FitV", DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
                case 372851746: {
                    Object[] action = new Object[]{key, "FitR", DestHandler.getFloatOrNull(currentPdfFile, dest), DestHandler.getFloatOrNull(currentPdfFile, dest), DestHandler.getFloatOrNull(currentPdfFile, dest), DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
                case 372851730: {
                    Object[] action = new Object[]{key, "FitB"};
                    return action;
                }
                case 960762414: {
                    Object[] action = new Object[]{key, "FitBH", DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
                case 960762428: {
                    Object[] action = new Object[]{key, "FitBV", DestHandler.getFloatOrNull(currentPdfFile, dest)};
                    return action;
                }
            }
        }
        return null;
    }

    public static String convertZoomArrayToString(Object[] zoomArray) {
        StringBuilder zoom = new StringBuilder();
        zoom.append(zoomArray[1]);
        for (int i = 2; i < zoomArray.length; ++i) {
            zoom.append(' ').append(zoomArray[i]);
        }
        return zoom.toString();
    }
}

