/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TextStream {
    public static int readTextStream(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        try {
            DecryptionFactory decryption;
            byte[] newString;
            if (raw[i] != 60 && raw[i] != 40) {
                ++i;
            }
            boolean isRef = raw[i = StreamReaderUtils.skipSpaces(raw, i)] != 60 && raw[i] != 40;
            int j = i;
            byte[] data = raw;
            if (isRef) {
                int[] values = StreamReaderUtils.readRefFromStream(raw, i);
                int number = values[0];
                int generation = values[1];
                i = StreamReaderUtils.skipSpaces(raw, values[2]);
                if (raw[i] != 82) {
                    return raw.length;
                }
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                    return raw.length;
                }
                if (data[0] == 40) {
                    j = 0;
                } else {
                    j = 3;
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        ++j;
                    }
                    j = StreamReaderUtils.skipSpaces(data, j);
                }
            }
            while (data[j] != 40 && data[j] != 60) {
                ++j;
            }
            int start = j;
            j = TextStream.skipToEnd(data, j);
            if (data[start] == 60) {
                int byteCount = j - ++start >> 1;
                newString = new byte[byteCount];
                int byteReached = 0;
                while (start != j) {
                    start = StreamReaderUtils.skipSpaces(data, start);
                    int topHex = TextStream.toNumber(data[start]);
                    start = StreamReaderUtils.skipSpaces(data, start + 1);
                    int bottomHex = TextStream.toNumber(data[start]);
                    ++start;
                    newString[byteReached] = (byte)(bottomHex + (topHex << 4));
                    ++byteReached;
                }
            } else {
                if (data[start] == 40) {
                    ++start;
                }
                boolean lbKeepReturns = false;
                switch (PDFkeyInt) {
                    case 1216184967: {
                        lbKeepReturns = pdfObject.getParameterConstant(1147962727) == 980909433;
                        break;
                    }
                    case 6420: {
                        lbKeepReturns = true;
                        break;
                    }
                    case 31: 
                    case 37: {
                        lbKeepReturns = pdfObject.getObjectType() == 1113489015;
                    }
                }
                newString = ObjectUtils.readEscapedValue(j, data, start, lbKeepReturns);
            }
            if (!(pdfObject.getObjectType() == 1113489015 || pdfObject.getObjectType() == 487790868 || pdfObject.isInCompressedStream() && PDFkeyInt != 506543413 && PDFkeyInt != 826499443 && PDFkeyInt != 1618506351 && PDFkeyInt != 29 || (decryption = objectReader.getDecryptionObject()) == null)) {
                newString = decryption.decryptString(newString, pdfObject.getObjectRefAsString());
            }
            pdfObject.setTextStreamValue(PDFkeyInt, newString);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "TextStream=" + new String(newString) + " in pdfObject=" + pdfObject);
            }
            if (!isRef) {
                i = j;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return i;
    }

    static int skipToEnd(byte[] data, int j) {
        byte startChar = data[j];
        int bracketCount = 1;
        while (j < data.length - 1) {
            if (!(startChar != 40 || data[++j] != 41 && data[j] != 40 || ObjectUtils.isEscaped(data, j))) {
                if (data[j] == 40) {
                    ++bracketCount;
                } else if (data[j] == 41) {
                    --bracketCount;
                }
                if (bracketCount == 0) break;
            }
            if (startChar != 60 || data[j] != 62 && data[j] != 0) continue;
            break;
        }
        return j;
    }

    private static int toNumber(int rawVal) {
        if (rawVal >= 65 && rawVal <= 70) {
            rawVal -= 55;
        } else if (rawVal >= 97 && rawVal <= 102) {
            rawVal -= 87;
        } else if (rawVal >= 48 && rawVal <= 57) {
            rawVal -= 48;
        }
        return rawVal;
    }

    public static int setTextStreamValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (raw[i + 1] == 40 && raw[i + 2] == 41) {
            pdfObject.setTextStreamValue(PDFkeyInt, new byte[1]);
            if (raw[i += 3] == 47) {
                --i;
            }
        } else {
            i = TextStream.readTextStream(pdfObject, i, raw, PDFkeyInt, objectReader);
        }
        return i;
    }
}

