/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.security.BaseDecryption;
import org.jpedal.io.security.CachedDataHelper;
import org.jpedal.io.security.JCADecryption;
import org.jpedal.io.security.SetSecurity;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;

public class DecryptionFactory {
    private Map<String, String> cachedObjects = new HashMap<String, String>();
    private boolean extractionIsAllowed = true;
    private boolean isInitialised;
    private boolean isMetaDataEncypted = true;
    private boolean isPasswordSupplied;
    private boolean stringsEncoded;
    private boolean isEncrypted;
    private byte[] encryptionKey;
    private int rev;
    private int P;
    private byte[] O;
    private byte[] U;
    private byte[] OE;
    private byte[] Perms;
    private byte[] UE;
    private Cipher cipher;
    private boolean isAES;
    private PdfObject StmFObj;
    private PdfObject StrFObj;
    private static boolean alwaysReinitCipher;
    private final String[] pad = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private boolean isAESIdentity;
    private int keyLength = 5;
    private boolean isFileViewable = true;
    private int passwordStatus;
    private final byte[] ID;
    private byte[] encryptionPassword;
    private Certificate certificate;
    private Key key;
    private BaseDecryption decryptionMethods;

    public static String getDynamicPassword() {
        Random r = new Random(System.currentTimeMillis());
        int length = 10 + r.nextInt(10) * 10;
        StringBuilder password = new StringBuilder();
        password.setLength(length);
        for (int i = 0; i < length; ++i) {
            password.setCharAt(i, (char)r.nextInt(255));
        }
        return password.toString();
    }

    public DecryptionFactory(byte[] ID2, byte[] encryptionPassword) {
        this.ID = ID2;
        this.encryptionPassword = encryptionPassword;
    }

    public DecryptionFactory(byte[] id, Certificate certificate, PrivateKey key) {
        this.ID = id;
        this.certificate = certificate;
        this.key = key;
    }

    private boolean testPassword(byte[] valueToMatch) throws PdfSecurityException {
        int count = 32;
        byte[] rawValue = new byte[32];
        for (int i = 0; i < 32; ++i) {
            rawValue[i] = (byte)Integer.parseInt(this.pad[i], 16);
        }
        byte[] encrypted = ObjectCloneFactory.cloneArray(rawValue);
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            encrypted = this.decrypt(encrypted, "", true, null, false, false);
        } else if (this.rev >= 3) {
            MessageDigest md;
            int keyLength = this.keyLength;
            count = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byte[] originalKey = ObjectCloneFactory.cloneArray(this.encryptionKey);
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                throw new PdfSecurityException("Exception " + e + " with digest");
            }
            md.update(encrypted);
            byte[] keyValue = md.digest(this.ID);
            keyValue = this.decrypt(keyValue, "", true, null, true, false);
            byte[] nextKey = new byte[keyLength];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < keyLength; ++j) {
                    nextKey[j] = (byte)(originalKey[j] ^ i);
                }
                this.encryptionKey = nextKey;
                keyValue = this.decrypt(keyValue, "", true, null, true, false);
            }
            this.encryptionKey = originalKey;
            encrypted = new byte[32];
            System.arraycopy(keyValue, 0, encrypted, 0, 16);
            System.arraycopy(rawValue, 0, encrypted, 16, 16);
        }
        return DecryptionFactory.compareKeys(valueToMatch, encrypted, count);
    }

    private static boolean compareKeys(byte[] U, byte[] encrypted, int count) {
        boolean match = true;
        for (int i = 0; i < count; ++i) {
            if (U[i] == encrypted[i]) continue;
            match = false;
            i = U.length;
        }
        return match;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        byte[] key = this.getPaddedKey(this.encryptionPassword, this.encryptionPassword);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.encryptionKey = md.digest(key);
            if (this.rev >= 3) {
                for (int ii = 0; ii < 50; ++ii) {
                    this.encryptionKey = md.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception e) {
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        byte[] originalPassword = this.encryptionPassword;
        byte[] userPasswd = new byte[this.keyLength];
        byte[] inputValue = ObjectCloneFactory.cloneArray(this.O);
        this.computeEncryptionKey();
        byte[] originalKey = ObjectCloneFactory.cloneArray(this.encryptionKey);
        if (this.rev == 2) {
            userPasswd = this.decrypt(ObjectCloneFactory.cloneArray(this.O), "", false, null, false, false);
        } else if (this.rev >= 3) {
            int keyLength = this.keyLength;
            userPasswd = inputValue;
            byte[] nextKey = new byte[keyLength];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < keyLength; ++j) {
                    nextKey[j] = (byte)(originalKey[j] ^ i);
                }
                this.encryptionKey = nextKey;
                userPasswd = this.decrypt(userPasswd, "", false, null, true, false);
            }
        }
        this.encryptionPassword = userPasswd;
        this.computeEncryptionKey();
        boolean isMatch = this.testPassword(this.U);
        if (!isMatch) {
            this.encryptionPassword = originalPassword;
            this.computeEncryptionKey();
        }
        return isMatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean isOwnerPassword = false;
        boolean isUserPassword = false;
        if (this.rev < 5) {
            isOwnerPassword = this.testOwnerPassword();
            isUserPassword = this.testPassword(this.U);
        } else if (this.rev == 5) {
            try {
                isOwnerPassword = DecryptionFactory.compareKeys(this.O, this.getV5Key(true, 32), 32);
                if (isOwnerPassword) {
                    this.encryptionKey = this.v5Decrypt(this.OE, this.getV5Key(true, 32));
                } else {
                    isUserPassword = DecryptionFactory.compareKeys(this.U, this.getV5Key(false, 32), 32);
                    if (isUserPassword) {
                        this.encryptionKey = this.v5Decrypt(this.UE, this.getV5Key(false, 40));
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        } else {
            if (this.rev != 6) throw new PdfSecurityException("Encryption version " + this.rev + " not supported");
            Object[] keyData = this.getR6Key();
            boolean isOwner = (Boolean)keyData[0];
            this.encryptionKey = (byte[])keyData[1];
            if (isOwner) {
                isOwnerPassword = true;
            } else {
                isUserPassword = true;
            }
        }
        if (isOwnerPassword) {
            this.passwordStatus = 2;
        }
        if (isUserPassword) {
            ++this.passwordStatus;
        }
        if (!isOwnerPassword || isUserPassword) {
            if (!isUserPassword) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword != null && this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private byte[] v5Decrypt(byte[] rawValue, byte[] key) throws PdfSecurityException {
        return this.decryptionMethods.v5Decrypt(rawValue, key);
    }

    private byte[] getV5Key(boolean isOwner, int offset) throws NoSuchAlgorithmException {
        int passwordLength;
        byte[] password = this.encryptionPassword;
        if (password == null) {
            password = new byte[]{};
        }
        if ((passwordLength = password.length) > 127) {
            passwordLength = 127;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(password, 0, passwordLength);
        if (isOwner) {
            md.update(this.O, offset, 8);
            md.update(this.U, 0, 48);
        } else {
            md.update(this.U, offset, 8);
        }
        return md.digest();
    }

    private Object[] getR6Key() throws PdfSecurityException {
        byte[] temp;
        byte[] password = this.encryptionPassword;
        if (password == null) {
            password = new byte[]{};
        }
        if (this.O.length > 48) {
            temp = new byte[48];
            System.arraycopy(this.O, 0, temp, 0, 48);
            this.O = temp;
        }
        if (this.U.length > 48) {
            temp = new byte[48];
            System.arraycopy(this.U, 0, temp, 0, 48);
            this.U = temp;
        }
        byte[] O_Hash = Arrays.copyOfRange(this.O, 0, 32);
        byte[] O_ValSalt = Arrays.copyOfRange(this.O, 32, 40);
        byte[] O_KeySalt = Arrays.copyOfRange(this.O, 40, 48);
        byte[] U_Hash = Arrays.copyOfRange(this.U, 0, 32);
        byte[] U_ValSalt = Arrays.copyOfRange(this.U, 32, 40);
        byte[] U_KeySalt = Arrays.copyOfRange(this.U, 40, 48);
        byte[] processedBytes = null;
        try {
            String passwordString = new String(password, "UTF-8");
            Normalizer.normalize(passwordString, Normalizer.Form.NFKC);
            processedBytes = passwordString.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (processedBytes == null) {
            throw new PdfSecurityException("Error processing input password");
        }
        if (processedBytes.length > 127) {
            processedBytes = Arrays.copyOf(processedBytes, 127);
        }
        int processedBytesLen = processedBytes.length;
        byte[] input = new byte[processedBytesLen + O_ValSalt.length + this.U.length];
        System.arraycopy(processedBytes, 0, input, 0, processedBytesLen);
        System.arraycopy(O_ValSalt, 0, input, processedBytesLen, O_ValSalt.length);
        System.arraycopy(this.U, 0, input, processedBytesLen + O_ValSalt.length, this.U.length);
        byte[] hash = null;
        try {
            hash = this.computeR6Hash(processedBytes, input, true);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
        }
        if (hash == null) {
            throw new PdfSecurityException("Error generating owner hash");
        }
        if (Arrays.equals(O_Hash, hash)) {
            return this.getR6OwnerFileEncryptionKey(processedBytes, O_KeySalt);
        }
        input = new byte[processedBytesLen + U_ValSalt.length];
        System.arraycopy(processedBytes, 0, input, 0, processedBytesLen);
        System.arraycopy(U_ValSalt, 0, input, processedBytesLen, U_ValSalt.length);
        try {
            hash = this.computeR6Hash(processedBytes, input, false);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
        }
        if (hash == null) {
            throw new PdfSecurityException("Error generating user hash");
        }
        if (Arrays.equals(U_Hash, hash)) {
            return this.getR6UserFileEncryptionKey(processedBytes, U_KeySalt);
        }
        throw new PdfSecurityException("No valid password supplied");
    }

    private Object[] getR6OwnerFileEncryptionKey(byte[] processedBytes, byte[] O_KeySalt) throws PdfSecurityException {
        Object[] keyData = new Object[2];
        keyData[0] = true;
        LogWriter.writeLog("Correct owner password supplied");
        int processedBytesLen = processedBytes.length;
        byte[] input = new byte[processedBytesLen + O_KeySalt.length + this.U.length];
        System.arraycopy(processedBytes, 0, input, 0, processedBytesLen);
        System.arraycopy(O_KeySalt, 0, input, processedBytesLen, O_KeySalt.length);
        System.arraycopy(this.U, 0, input, processedBytesLen + O_KeySalt.length, this.U.length);
        byte[] interOwnerKey = null;
        try {
            interOwnerKey = this.computeR6Hash(processedBytes, input, true);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
        }
        if (interOwnerKey == null) {
            throw new PdfSecurityException("Error generating intermediate owner key");
        }
        byte[] ivData = new byte[16];
        byte[] ownerFileEncryptionKey = new byte[32];
        try {
            ownerFileEncryptionKey = this.decryptionMethods.r6Cryptographer(this.OE, interOwnerKey, ivData, 2);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
        }
        keyData[1] = ownerFileEncryptionKey;
        return keyData;
    }

    private Object[] getR6UserFileEncryptionKey(byte[] processedBytes, byte[] U_KeySalt) throws PdfSecurityException {
        Object[] keyData = new Object[2];
        keyData[0] = false;
        LogWriter.writeLog("Correct user password supplied");
        int processedBytesLen = processedBytes.length;
        byte[] input = new byte[processedBytesLen + U_KeySalt.length];
        System.arraycopy(processedBytes, 0, input, 0, processedBytesLen);
        System.arraycopy(U_KeySalt, 0, input, processedBytesLen, U_KeySalt.length);
        byte[] interUserKey = null;
        try {
            interUserKey = this.computeR6Hash(processedBytes, input, false);
        }
        catch (Exception e) {
            LogWriter.writeLog(e.getMessage());
        }
        if (interUserKey == null) {
            throw new PdfSecurityException("Error generating intermediate user key");
        }
        byte[] iv = new byte[16];
        byte[] userFileEncryptionKey = new byte[32];
        try {
            userFileEncryptionKey = this.decryptionMethods.r6Cryptographer(this.UE, interUserKey, iv, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogWriter.writeLog(e.getMessage());
        }
        keyData[1] = userFileEncryptionKey;
        return keyData;
    }

    private byte[] computeR6Hash(byte[] inputPassword, byte[] inputString, boolean isOwner) throws PdfSecurityException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] K2 = digest.digest(inputString);
        int round = 0;
        while (true) {
            int lastByteVal;
            byte[] sequence;
            byte[] K1;
            if (isOwner) {
                K1 = new byte[(inputPassword.length + K2.length + this.U.length) * 64];
                sequence = new byte[inputPassword.length + K2.length + this.U.length];
                System.arraycopy(inputPassword, 0, sequence, 0, inputPassword.length);
                System.arraycopy(K2, 0, sequence, inputPassword.length, K2.length);
                System.arraycopy(this.U, 0, sequence, inputPassword.length + K2.length, this.U.length);
            } else {
                K1 = new byte[(inputPassword.length + K2.length) * 64];
                sequence = new byte[inputPassword.length + K2.length];
                System.arraycopy(inputPassword, 0, sequence, 0, inputPassword.length);
                System.arraycopy(K2, 0, sequence, inputPassword.length, K2.length);
            }
            for (int j = 0; j < K1.length; ++j) {
                K1[j] = sequence[j % sequence.length];
            }
            byte[] keyBytes = new byte[16];
            System.arraycopy(K2, 0, keyBytes, 0, 16);
            byte[] iv = new byte[16];
            System.arraycopy(K2, 16, iv, 0, 16);
            byte[] E = this.decryptionMethods.r6Cryptographer(K1, keyBytes, iv, 1);
            if (E == null) {
                throw new PdfSecurityException("Error generating hash");
            }
            byte[] uintBytes = new byte[17];
            System.arraycopy(E, 0, uintBytes, 1, 16);
            BigInteger uint = new BigInteger(uintBytes);
            uint = uint.mod(new BigInteger("3"));
            int remainder = uint.intValue();
            switch (remainder) {
                case 0: {
                    digest = MessageDigest.getInstance("SHA-256");
                    break;
                }
                case 1: {
                    digest = MessageDigest.getInstance("SHA-384");
                    break;
                }
                case 2: {
                    digest = MessageDigest.getInstance("SHA-512");
                }
            }
            K2 = digest.digest(E);
            if (round >= 63 && (lastByteVal = 0xFF & E[E.length - 1]) <= round - 32) {
                byte[] hash = new byte[32];
                System.arraycopy(K2, 0, hash, 0, 32);
                return hash;
            }
            ++round;
        }
    }

    private byte[] getPaddedKey(byte[] password, byte[] encryptionPassword) {
        byte[] key = new byte[32];
        int passwordLength = 0;
        if (password != null && (passwordLength = password.length) > 32) {
            passwordLength = 32;
        }
        if (encryptionPassword != null) {
            System.arraycopy(encryptionPassword, 0, key, 0, passwordLength);
        }
        for (int ii = passwordLength; ii < 32; ++ii) {
            key[ii] = (byte)Integer.parseInt(this.pad[ii - passwordLength], 16);
        }
        return key;
    }

    private byte[] calculateKey(byte[] O, int P, byte[] ID2) throws PdfSecurityException {
        byte[] keyValue;
        byte[] key = this.getPaddedKey(this.encryptionPassword, this.encryptionPassword);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(key);
            md.update(O);
            md.update(new byte[]{(byte)(P & 0xFF), (byte)(P >> 8 & 0xFF), (byte)(P >> 16 & 0xFF), (byte)(P >> 24 & 0xFF)});
            if (ID2 != null) {
                md.update(ID2);
            }
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            byte[] digest = new byte[this.keyLength];
            System.arraycopy(md.digest(), 0, digest, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(md.digest(digest), 0, digest, 0, this.keyLength);
                }
            }
            keyValue = new byte[this.keyLength];
            System.arraycopy(digest, 0, keyValue, 0, this.keyLength);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            throw new PdfSecurityException("Exception " + e + " generating encryption key");
        }
        byte[] returnKey = new byte[this.keyLength];
        System.arraycopy(keyValue, 0, returnKey, 0, this.keyLength);
        return returnKey;
    }

    public void readEncryptionObject(PdfObject encyptionObj, PdfFileReader pdfFileReader) throws PdfSecurityException {
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        this.StmFObj = null;
        this.StrFObj = null;
        this.isAES = false;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        this.decryptionMethods = new JCADecryption();
        int v = encyptionObj.getInt(38);
        PdfArrayIterator filters = encyptionObj.getMixedArray(1011108731);
        int firstValue = 1467315058;
        if (filters != null && filters.hasMoreTokens()) {
            firstValue = filters.getNextValueAsConstant(false);
        }
        if (v == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method");
        }
        if (v > 4 && firstValue != 1467315058) {
            throw new PdfSecurityException("Unsupported Encryption method");
        }
        int newLength = encyptionObj.getInt(1043816557) >> 3;
        if (newLength != -1) {
            this.keyLength = newLength;
        }
        this.rev = encyptionObj.getInt(34);
        this.P = encyptionObj.getInt(32);
        this.O = encyptionObj.getTextStreamValueAsByte(31);
        this.U = encyptionObj.getTextStreamValueAsByte(37);
        this.OE = encyptionObj.getTextStreamValueAsByte(7957);
        this.UE = encyptionObj.getTextStreamValueAsByte(9493);
        this.Perms = encyptionObj.getTextStreamValueAsByte(893533539);
        if (v >= 4) {
            String CFkey;
            PdfKeyPairsIterator keyPairs;
            this.isAES = true;
            PdfObject CF = encyptionObj.getDictionary(4886);
            if (v == 4) {
                this.isMetaDataEncypted = encyptionObj.getBoolean(-1815804199);
            }
            this.isAESIdentity = false;
            String key = encyptionObj.getName(591675926);
            if (key != null) {
                this.isAESIdentity = key.equals("Identity");
                this.stringsEncoded = true;
                keyPairs = CF.getKeyPairsIterator();
                while (keyPairs.hasMorePairs()) {
                    CFkey = keyPairs.getNextKeyAsString();
                    if (CFkey.equals(key)) {
                        this.StrFObj = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new EncryptionObject(encyptionObj.getObjectRefAsString()), pdfFileReader, keyPairs.getNextValueAsBytes(), 4886);
                    }
                    keyPairs.nextPair();
                }
            }
            if ((key = encyptionObj.getName(591674646)) != null) {
                this.isAESIdentity = key.equals("Identity");
                keyPairs = CF.getKeyPairsIterator();
                while (keyPairs.hasMorePairs()) {
                    CFkey = keyPairs.getNextKeyAsString();
                    if (CFkey.equals(key)) {
                        this.StmFObj = PdfObjectFactory.getPDFObjectObjectFromRefOrDirect(new EncryptionObject(encyptionObj.getObjectRefAsString()), pdfFileReader, keyPairs.getNextValueAsBytes(), 4886);
                    }
                    keyPairs.nextPair();
                }
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        if (firstValue == 1467315058) {
            try {
                this.verifyAccess();
            }
            catch (PdfSecurityException e) {
                LogWriter.writeLog("File requires password " + e);
            }
        } else if (this.certificate != null) {
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
        if (this.encryptionKey != null) {
            if (this.rev == 5) {
                this.Perms = this.v5Decrypt(this.Perms, this.encryptionKey);
                this.isMetaDataEncypted = this.Perms[8] == 84;
                this.P = this.Perms[0] & 0xFF | (this.Perms[1] & 0xFF) << 8 | (this.Perms[2] & 0xFF) << 16 | (this.Perms[2] & 0xFF) << 24;
            } else if (this.rev == 6) {
                this.decodeR6Permissions();
            }
        }
    }

    private void decodeR6Permissions() throws PdfSecurityException {
        this.Perms = this.decryptionMethods.r6PermissionsDecoder(this.Perms, this.encryptionKey);
        if ((char)this.Perms[9] != 'a' || (char)this.Perms[10] != 'd' || (char)this.Perms[11] != 'b') {
            LogWriter.writeLog("WARNING: Permissions do not match those specified in the PDF");
        } else {
            byte[] decrypted_P = new byte[4];
            System.arraycopy(this.Perms, 0, decrypted_P, 0, 4);
            ByteBuffer byteBuffer = ByteBuffer.wrap(decrypted_P);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int p_value = 0;
            while (byteBuffer.hasRemaining()) {
                p_value = byteBuffer.getInt();
            }
            if (p_value == 0 || p_value != this.P) {
                LogWriter.writeLog("WARNING: Decrypted permissions do not match those specified in the PDF");
            } else {
                LogWriter.writeLog("Decrypted permissions match those specified in the PDF");
            }
            this.isMetaDataEncypted = this.Perms[8] == 84;
        }
    }

    private void setPasswordFromCertificate(PdfObject AESObj) {
        byte[] envelopedData;
        byte[][] recipients = AESObj.getStringArray(1752671921);
        if (recipients != null && (envelopedData = this.extractCertificateData(recipients, this.certificate, this.key)) != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(envelopedData, 0, 20);
                for (byte[] recipient : recipients) {
                    md.update(recipient);
                }
                if (!this.isMetaDataEncypted) {
                    md.update(new byte[]{-1, -1, -1, -1});
                }
                this.encryptionKey = md.digest();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private byte[] extractCertificateData(byte[][] recipients, Certificate certificate, Key key) {
        return this.decryptionMethods.readCertificate(recipients, certificate, key);
    }

    public byte[] decrypt(byte[] data, String ref, boolean isEncryption, String cacheName, boolean alwaysUseRC4, boolean isString) throws PdfSecurityException {
        if (this.getBooleanValue(101) || isEncryption) {
            String cryptName;
            boolean isAES = false;
            byte[] AESData = null;
            CachedDataHelper cachedData = null;
            if (cacheName != null) {
                cachedData = new CachedDataHelper(this.cachedObjects);
                AESData = cachedData.init(data, cacheName, this.encryptionPassword);
            }
            int keyLength = this.keyLength;
            String algorithm = "RC4";
            String keyType = "RC4";
            IvParameterSpec ivSpec = null;
            PdfObject AESObj = !isString ? this.StmFObj : this.StrFObj;
            if (this.certificate != null) {
                this.setPasswordFromCertificate(AESObj);
                AESObj.setIntNumber(1043816557, 16);
            }
            if (!alwaysUseRC4 && AESObj == null && this.isAESIdentity) {
                return data;
            }
            if (AESObj != null && (cryptName = AESObj.getName(1250845)) != null && !alwaysUseRC4 && (cryptName.equals("AESV2") || cryptName.equals("AESV3"))) {
                this.cipher = null;
                algorithm = "AES/CBC/PKCS5Padding";
                keyType = "AES";
                isAES = true;
                byte[] iv = new byte[16];
                if (AESData != null) {
                    System.arraycopy(AESData, 0, iv, 0, 16);
                } else if (data.length >= 16) {
                    System.arraycopy(data, 0, iv, 0, 16);
                } else {
                    return data;
                }
                ivSpec = new IvParameterSpec(iv);
                if (data == null) {
                    cachedData.skip();
                } else {
                    int origLen = data.length;
                    int newLen = origLen - 16;
                    byte[] newData = new byte[newLen];
                    System.arraycopy(data, 16, newData, 0, newLen);
                    data = newData;
                    int diff = data.length & 0xF;
                    int newLength = data.length;
                    if (diff > 0) {
                        newLength = newLength + 16 - diff;
                        newData = new byte[newLength];
                        System.arraycopy(data, 0, newData, 0, data.length);
                        data = newData;
                    }
                    if (this.rev == 5 || this.rev == 6) {
                        try {
                            byte[] finalKey = new byte[32];
                            System.arraycopy(this.encryptionKey, 0, finalKey, 0, finalKey.length);
                            return this.decodeAES(finalKey, data, iv);
                        }
                        catch (Exception e) {
                            throw new PdfSecurityException("Exception " + e + " decrypting content in AES revision " + this.rev);
                        }
                    }
                }
            }
            byte[] currentKey = new byte[keyLength];
            if (!ref.isEmpty()) {
                currentKey = new byte[keyLength + 5];
            }
            System.arraycopy(this.encryptionKey, 0, currentKey, 0, keyLength);
            try {
                byte[] finalKey = DecryptionFactory.getkey(ref, isAES, keyLength, currentKey, this.rev);
                this.setCipher(isEncryption, algorithm, keyType, ivSpec, finalKey);
                if (cachedData != null) {
                    cachedData.writeOutCachedData(this.cipher);
                }
                if (data != null) {
                    data = this.cipher.doFinal(data);
                }
            }
            catch (Exception e) {
                throw new PdfSecurityException("Exception " + e + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return data;
    }

    private static byte[] getkey(String ref, boolean isAES, int keyLength, byte[] currentKey, int rev) throws NoSuchAlgorithmException {
        byte[] finalKey;
        if (rev == 5 || rev == 6) {
            finalKey = new byte[32];
            System.arraycopy(currentKey, 0, finalKey, 0, finalKey.length);
        } else {
            finalKey = DecryptionFactory.completeKey(ref, isAES, keyLength, currentKey);
        }
        return finalKey;
    }

    private void setCipher(boolean isEncryption, String algorithm, String keyType, IvParameterSpec ivSpec, byte[] finalKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipher == null) {
            this.cipher = Cipher.getInstance(algorithm);
        }
        SecretKeySpec testKey = new SecretKeySpec(finalKey, keyType);
        if (isEncryption) {
            this.cipher.init(1, testKey);
        } else if (ivSpec == null) {
            this.cipher.init(2, testKey);
        } else {
            this.cipher.init(2, (Key)testKey, ivSpec);
        }
    }

    private static byte[] completeKey(String ref, boolean isAES, int keyLength, byte[] currentKey) throws NoSuchAlgorithmException {
        if (!ref.isEmpty()) {
            int pointer = ref.indexOf(32);
            int pointer2 = ref.indexOf(32, pointer + 1);
            int obj = Integer.parseInt(ref.substring(0, pointer));
            int gen = Integer.parseInt(ref.substring(pointer + 1, pointer2));
            currentKey[keyLength] = (byte)(obj & 0xFF);
            currentKey[keyLength + 1] = (byte)(obj >> 8 & 0xFF);
            currentKey[keyLength + 2] = (byte)(obj >> 16 & 0xFF);
            currentKey[keyLength + 3] = (byte)(gen & 0xFF);
            currentKey[keyLength + 4] = (byte)(gen >> 8 & 0xFF);
        }
        byte[] finalKey = new byte[Math.min(currentKey.length, 16)];
        if (!ref.isEmpty()) {
            MessageDigest currentDigest = MessageDigest.getInstance("MD5");
            currentDigest.update(currentKey);
            if (isAES && keyLength >= 16) {
                byte[] salt = new byte[]{115, 65, 108, 84};
                currentDigest.update(salt);
            }
            System.arraycopy(currentDigest.digest(), 0, finalKey, 0, finalKey.length);
        } else {
            System.arraycopy(currentKey, 0, finalKey, 0, finalKey.length);
        }
        return finalKey;
    }

    public boolean getBooleanValue(int key) {
        switch (key) {
            case 100: {
                return this.isFileViewable;
            }
            case 101: {
                return this.isEncrypted;
            }
            case 102: {
                return this.isMetaDataEncypted;
            }
            case 103: {
                return this.extractionIsAllowed;
            }
            case 104: {
                return this.isPasswordSupplied;
            }
        }
        return false;
    }

    public byte[] decryptString(byte[] newString, String objectRef) {
        try {
            if (!this.isAES || this.stringsEncoded || this.isMetaDataEncypted) {
                newString = this.decrypt(newString, objectRef, false, null, false, true);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to decrypt string in Object " + objectRef + ' ' + new String(newString) + ' ' + e);
        }
        return newString;
    }

    public int getPDFflag(Integer flag) {
        if (flag.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (flag.equals(PDFflags.VALID_PASSWORD_SUPPLIED)) {
            return this.passwordStatus;
        }
        return -1;
    }

    public void reset(byte[] encryptionPassword) {
        this.encryptionPassword = encryptionPassword;
        this.cipher = null;
    }

    public void flush() {
        if (this.cachedObjects != null) {
            for (String o : this.cachedObjects.keySet()) {
                File file = new File(o);
                file.delete();
            }
        }
    }

    public void dispose() {
        this.cachedObjects = null;
    }

    public boolean hasPassword() {
        return this.O != null || this.U != null;
    }

    private byte[] decodeAES(byte[] encKey, byte[] encData, byte[] ivData) {
        return this.decryptionMethods.decodeAES(encKey, encData, ivData);
    }

    public void setCipherNull() {
        this.cipher = null;
    }

    public byte[] getEncHash() {
        return this.encryptionPassword;
    }

    static {
        String flag = System.getProperty("org.jpedal.cipher.reinit");
        if (flag != null && flag.equalsIgnoreCase("true")) {
            alwaysReinitCipher = true;
        }
    }
}

