/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jpedal.utils.LogWriter;

public class StatusBar {
    private static final int debug_level = 0;
    private int progress_size;
    private String current = "";
    private static final int progress_max_size = 100;
    private JProgressBar status;
    private boolean showMessages;
    public float percentageDone;
    private Color masterColor;
    private boolean reset;

    public StatusBar() {
        this.initialiseStatus("");
    }

    public StatusBar(Color newColor) {
        this.masterColor = newColor;
        this.initialiseStatus("");
    }

    public final void initialiseStatus(String current) {
        this.progress_size = 0;
        this.status = new JProgressBar();
        if (this.masterColor != null) {
            this.status.setForeground(this.masterColor);
        }
        this.status.setStringPainted(true);
        this.status.setMaximum(100);
        this.status.setMinimum(0);
        this.updateStatus(current, 4);
    }

    public final void updateStatus(String progress_bar, int debug_level_to_use) {
        this.current = progress_bar;
        if (this.showMessages) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.status.setString(StatusBar.this.current);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
        if (0 > debug_level_to_use) {
            LogWriter.writeLog(progress_bar);
        }
    }

    public final Component getStatusObject() {
        return this.status;
    }

    public final void setProgress(int size) {
        this.reset = false;
        if (this.status != null) {
            if (size == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < size) {
                this.progress_size = size;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void setProgress(final String message, int size) {
        this.reset = false;
        if (this.status != null) {
            if (size == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < size) {
                this.progress_size = size;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.status.setString(message);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void resetStatus(String current) {
        this.reset = true;
        this.progress_size = 0;
        this.updateStatus(current, 4);
    }

    public final void setClientDisplay() {
        this.showMessages = true;
    }

    public void setVisible(boolean visible) {
        this.status.setVisible(visible);
    }

    public void setEnabled(boolean enable) {
        this.status.setEnabled(enable);
    }

    public boolean isVisible() {
        return this.status.isVisible();
    }

    public boolean isEnabled() {
        return this.status.isEnabled();
    }

    public boolean isDone() {
        return this.reset || this.progress_size >= 100;
    }
}

