/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.io.security.TempStoreImage;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final Map<String, String> undeletedFiles = new ConcurrentHashMap<String, String>();
    public static boolean isMultiThreaded;
    private static boolean checkedThisSession;
    private static final String separator;
    private String currentFilename = "";
    private String currentFilePath = "";
    public static String temp_dir;
    public static String multiThreaded_root_dir;
    private String key = "jpedal" + Math.random() + '_';
    private final Map<String, String> image_type = new HashMap<String, String>();
    private final Map<String, String> tempFileNames = new HashMap<String, String>();
    public static final Integer IMAGE_WIDTH;
    public static final Integer IMAGE_HEIGHT;
    public static final Integer IMAGE_pX;
    public static final Integer IMAGE_pY;
    public static final Integer IMAGE_MASKCOL;
    public static final Integer IMAGE_DEPTH;
    public static final Integer IMAGE_COMPONENT_COUNT;
    public static long time;
    public String fullFileName;
    private static final Map<String, String> pagesOnDisk;
    private static final Map<String, String> pagesOnDiskAsBytes;
    private final Map<Integer, String> imagesOnDiskAsBytes = new HashMap<Integer, String>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesW = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesH = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesD = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytespX = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytespY = new HashMap<Integer, Integer>();
    private final Map<Integer, byte[]> imagesOnDiskMask = new HashMap<Integer, byte[]>();
    private final Map<Integer, Integer> imagesOnDiskCompCount = new HashMap<Integer, Integer>();
    private static final boolean storeMemoryObjects = false;
    private final Map<String, Integer> memoryImageMap = new HashMap<String, Integer>();
    private final byte[][] memoryImageData = new byte[6][];
    private final String[] memoryImageRefs = new String[]{"-1", "-1", "-1", "-1", "-1", "-1"};
    private int memoryImagePos;
    private static final boolean storeMemoryImages = true;
    private final Map<String, BufferedImage> memoryBufferMap = new HashMap<String, BufferedImage>();
    private int memoryBufferDim;
    private byte[] encHash;
    private byte[] idrPassword;

    public ObjectStore() {
        ObjectStore.setProperties();
        ObjectStore.init();
    }

    private static void setProperties() {
        String tempDir = System.getProperty("org.jpedal.tempDir");
        if (tempDir != null) {
            temp_dir = tempDir;
        }
    }

    private static void init() {
        try {
            if (temp_dir.isEmpty()) {
                temp_dir = System.getProperty("java.io.tmpdir");
            }
            if (isMultiThreaded) {
                temp_dir = multiThreaded_root_dir != null ? multiThreaded_root_dir + separator + "jpedal-" + System.currentTimeMillis() + separator : System.getProperty("java.io.tmpdir") + separator + "jpedal-" + System.currentTimeMillis() + separator;
            } else if (temp_dir.isEmpty()) {
                temp_dir = temp_dir + separator + "jpedal" + separator;
            } else if (!temp_dir.endsWith(separator)) {
                temp_dir = temp_dir + separator;
            }
            File f = new File(temp_dir);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir + ' ' + e);
        }
    }

    public void addMemoryData(String ref, byte[] data) {
    }

    private void addMemoryImage(String ref, BufferedImage image) {
        int ih;
        int iw = image.getWidth();
        int dim = iw * (ih = image.getHeight());
        if (dim < 65536) {
            if (this.memoryBufferDim > 0x1000000) {
                this.memoryBufferDim = dim;
                this.memoryBufferMap.clear();
            }
            this.memoryBufferMap.put(ref, image);
            this.memoryBufferDim += dim;
        }
    }

    private BufferedImage getMemoryImage(String ref) {
        return this.memoryBufferMap.get(ref);
    }

    public byte[] getMemoryData(String ref) {
        return null;
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public String getCurrentFilepath() {
        return this.currentFilePath;
    }

    public final void storeFileName(String name) {
        this.fullFileName = name;
        int ptr = this.fullFileName.lastIndexOf(47);
        int ptr2 = this.fullFileName.lastIndexOf(92);
        if (ptr2 > ptr) {
            ptr = ptr2;
        }
        this.currentFilePath = ptr > 0 ? this.fullFileName.substring(0, ptr + 1) : "";
        int temp_pointer = name.indexOf(92);
        if (temp_pointer == -1) {
            temp_pointer = name.indexOf(47);
        }
        while (temp_pointer != -1) {
            if ((temp_pointer = (name = name.substring(temp_pointer + 1)).indexOf(92)) != -1) continue;
            temp_pointer = name.indexOf(47);
        }
        int pointer = name.lastIndexOf(46);
        if (pointer != -1) {
            name = name.substring(0, pointer);
        }
        name = Strip.stripAllSpaces(name);
        this.currentFilename = name.toLowerCase();
    }

    public final boolean saveStoredImageAsBytes(String currentImage, BufferedImage image, boolean file_name_is_path) {
        try {
            File checkDir = new File(temp_dir);
            if (!checkDir.exists()) {
                checkDir.mkdirs();
            }
            String fileName = currentImage + ".jpl";
            if (!file_name_is_path) {
                this.image_type.put(currentImage, "jpl");
                fileName = temp_dir + this.key + currentImage + ".jpl";
            }
            this.addMemoryImage(fileName, image);
            byte[] data = TempStoreImage.getBytes(image);
            ObjectStore.writeToFile(fileName, data, this.encHash);
            this.tempFileNames.put(fileName, "#");
            return false;
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " flushing files");
            return true;
        }
    }

    public final boolean saveStoredImage(String current_image, BufferedImage image, boolean file_name_is_path, String type) {
        boolean was_error = false;
        File checkDir = new File(temp_dir);
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
        if (type.contains("tif")) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "tif");
            }
            was_error = this.saveStoredImage("TIF", ".tif", ".tiff", current_image, image, file_name_is_path);
        } else if (type.contains("jpg")) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "jpg");
            }
            was_error = this.saveStoredJPEGImage(current_image, image, file_name_is_path);
        } else if (type.contains("png")) {
            if (!file_name_is_path) {
                this.image_type.put(current_image, "png");
            }
            was_error = this.saveStoredImage("PNG", ".png", ".png", current_image, image, file_name_is_path);
        }
        return was_error;
    }

    public final void init(String current_key) {
        this.key = current_key + System.currentTimeMillis();
        File f = new File(temp_dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public final BufferedImage loadStoredImage(String current_image) {
        if (current_image == null) {
            return null;
        }
        String flag = this.image_type.get(current_image);
        BufferedImage image = null;
        if (flag == null) {
            return null;
        }
        if (flag.equals("tif")) {
            image = this.loadStoredImage(current_image, ".tif");
        } else if (flag.equals("jpg")) {
            image = this.loadStoredJPEGImage(current_image);
        } else if (flag.equals("png")) {
            image = this.loadStoredImage(current_image, ".png");
        } else if (flag.equals("jpl")) {
            image = this.loadStoredImage(current_image, ".jpl");
        }
        return image;
    }

    public final void flush() {
        File delete_file;
        for (Integer n : this.imagesOnDiskAsBytes.keySet()) {
            if (n == null || !(delete_file = new File(this.imagesOnDiskAsBytes.get(n))).exists()) continue;
            delete_file.delete();
        }
        this.imagesOnDiskAsBytes.clear();
        this.imagesOnDiskAsBytesW.clear();
        this.imagesOnDiskAsBytesH.clear();
        this.imagesOnDiskAsBytesD.clear();
        this.imagesOnDiskAsBytespX.clear();
        this.imagesOnDiskAsBytespY.clear();
        this.imagesOnDiskMask.clear();
        this.imagesOnDiskCompCount.clear();
        Iterator<String> tempFilesToDelete = this.tempFileNames.keySet().iterator();
        while (tempFilesToDelete.hasNext()) {
            String string = tempFilesToDelete.next();
            if (!string.contains(this.key)) continue;
            delete_file = new File(string);
            if (delete_file.delete()) {
                tempFilesToDelete.remove();
                continue;
            }
            undeletedFiles.put(this.key, "x");
        }
        try {
            if (!checkedThisSession && temp_dir.length() > 2) {
                checkedThisSession = true;
                File file = new File(temp_dir);
                String[] file_list = file.list();
                File[] to_be_del = file.listFiles();
                if (file_list != null) {
                    for (int ii = 0; ii < file_list.length; ++ii) {
                        if (file_list[ii].contains(this.key)) {
                            File delete_file2 = new File(temp_dir + file_list[ii]);
                            delete_file2.delete();
                        }
                        if (file_list[ii].endsWith(".pdf") || to_be_del == null || System.currentTimeMillis() - to_be_del[ii].lastModified() < time) continue;
                        to_be_del[ii].delete();
                    }
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " flushing files");
        }
    }

    private boolean saveStoredJPEGImage(String file_name, BufferedImage image, boolean file_name_is_path) {
        String s;
        boolean wasError = false;
        if (!file_name_is_path) {
            file_name = temp_dir + this.key + file_name;
        }
        if (!(s = file_name.toLowerCase()).endsWith(".jpg") && !s.endsWith(".jpeg")) {
            file_name = file_name + ".jpg";
        }
        try {
            DefaultImageHelper.write(image, "jpg", file_name);
            this.tempFileNames.put(file_name, "#");
        }
        catch (Exception e) {
            wasError = true;
            LogWriter.writeLog("Exception " + e + " writing image " + image + " as " + file_name);
        }
        return wasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage loadStoredImage(String current_image, String ending) {
        String file_name = temp_dir + this.key + current_image + ending;
        if (ending.equals(".jpl")) {
            File file = new File(file_name);
            if (!file.exists()) {
                return null;
            }
            BufferedImage mem = this.getMemoryImage(file_name);
            if (mem != null) {
                return mem;
            }
            FileInputStream fis = null;
            try {
                byte[] data = new byte[(int)file.length()];
                fis = new FileInputStream(file_name);
                fis.read(data);
                if (this.encHash != null) {
                    CryptoIDR crypto = new CryptoIDR(this.encHash);
                    data = crypto.decrypt(data);
                }
                BufferedImage bufferedImage = TempStoreImage.getImage(data);
                return bufferedImage;
            }
            catch (Exception ex) {
                Logger.getLogger(ObjectStore.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(ObjectStore.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return DefaultImageHelper.read(file_name);
    }

    public final void saveAsCopy(String current_image, String destination) {
        String source = temp_dir + this.key + current_image;
        try {
            BufferedInputStream from = new BufferedInputStream(new FileInputStream(source));
            BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(destination));
            ObjectStore.copy(from, to);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File destination) {
        BufferedInputStream from = null;
        BufferedOutputStream to = null;
        try {
            from = new BufferedInputStream(new FileInputStream(source));
            to = new BufferedOutputStream(new FileOutputStream(destination));
        }
        catch (Exception e) {
            try {
                LogWriter.writeLog("Exception " + e + " copying file");
            }
            catch (Throwable throwable) {
                ObjectStore.copy(from, to);
                throw throwable;
            }
            ObjectStore.copy(from, to);
        }
        ObjectStore.copy(from, to);
    }

    public static void copy(String source, String destination) {
        ObjectStore.copy(new File(source), new File(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream from, OutputStream to) {
        int length = 0;
        try {
            int bytes_read;
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
                length += bytes_read;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        finally {
            if (to != null) {
                try {
                    to.close();
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception " + e + " closing files");
                }
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception " + e + " closing files");
                }
            }
        }
        return length;
    }

    public static int copyAndEncrypt(BufferedInputStream from, FileOutputStream to, byte[] password) {
        int bytesRead = 0;
        byte[] data = new byte[65535];
        try {
            int bytesToRead;
            CryptoIDR crypt = new CryptoIDR(password);
            while ((bytesToRead = from.read(data, 0, data.length)) != -1) {
                data = crypt.encrypt(data, bytesRead);
                to.write(data, 0, bytesToRead);
                bytesRead += bytesToRead;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing files");
        }
        return bytesRead;
    }

    private BufferedImage loadStoredJPEGImage(String current_image) {
        String file_name = temp_dir + this.key + current_image + ".jpg";
        BufferedImage image = null;
        File a = new File(file_name);
        if (a.exists()) {
            try {
                image = DefaultImageHelper.read(file_name);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading " + current_image);
            }
        } else {
            image = new BufferedImage(100, 100, 1);
        }
        return image;
    }

    private boolean saveStoredImage(String format, String ending1, String ending2, String current_image, BufferedImage image, boolean file_name_is_path) {
        String s;
        boolean was_error = false;
        String file_name = current_image;
        if (!file_name_is_path) {
            file_name = temp_dir + this.key + current_image;
        }
        if (!(s = file_name.toLowerCase()).endsWith(ending1) && !s.endsWith(ending2)) {
            file_name = file_name + ending1;
        }
        try {
            DefaultImageHelper.write(image, format, file_name);
            this.tempFileNames.put(file_name, "#");
        }
        catch (Exception e) {
            LogWriter.writeLog(" Exception " + e + " writing image " + image + " with type " + image.getType());
            was_error = true;
        }
        catch (Error ee) {
            LogWriter.writeLog("Error " + ee + " writing image " + image + " with type " + image.getType());
            was_error = true;
        }
        return was_error;
    }

    public static void flushPages() {
        try {
            File delete_file;
            for (String file : pagesOnDisk.keySet()) {
                if (file == null || !(delete_file = new File(pagesOnDisk.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDisk.clear();
            for (String file : pagesOnDiskAsBytes.keySet()) {
                if (file == null || !(delete_file = new File(pagesOnDiskAsBytes.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDiskAsBytes.clear();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " flushing files");
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.flush();
        for (String o : undeletedFiles.keySet()) {
            File delete_file = new File(o);
            if (!delete_file.delete()) continue;
            undeletedFiles.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCachedPageAsBytes(String key) {
        byte[] data = null;
        String cachedFile = pagesOnDiskAsBytes.get(key);
        if (cachedFile != null) {
            BufferedInputStream from = null;
            try {
                File fis = new File(cachedFile);
                from = new BufferedInputStream(new FileInputStream(fis));
                data = new byte[(int)fis.length()];
                from.read(data);
                from.close();
                CryptoIDR crypto = new CryptoIDR(key.getBytes());
                data = crypto.decrypt(data);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            finally {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (Exception e) {
                        LogWriter.writeLog(e.getMessage());
                    }
                }
            }
        }
        return data;
    }

    public static void cachePageAsBytes(String key, byte[] bytes) {
        try {
            File delete_file;
            if (pagesOnDiskAsBytes.containsKey(key) && (delete_file = new File(pagesOnDiskAsBytes.get(key))).exists()) {
                delete_file.delete();
            }
            String ff = File.createTempFile("bytes", ".bin", new File(temp_dir)).getAbsolutePath();
            ObjectStore.writeToFile(ff, bytes, key.getBytes());
            pagesOnDiskAsBytes.put(key, ff);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public void saveRawImageData(String pageImgCount, byte[] bytes, int w, int h, int bpc, int pX, int pY, byte[] maskCol, int componentCount) {
        try {
            String ff = File.createTempFile("image", ".bin", new File(temp_dir)).getAbsolutePath();
            ObjectStore.writeToFile(ff, bytes, this.encHash);
            Integer key = Integer.valueOf(pageImgCount);
            this.imagesOnDiskAsBytes.put(key, ff);
            this.imagesOnDiskAsBytesW.put(key, w);
            this.imagesOnDiskAsBytesH.put(key, h);
            this.imagesOnDiskAsBytesD.put(key, bpc);
            this.imagesOnDiskAsBytespX.put(key, pX);
            this.imagesOnDiskAsBytespY.put(key, pY);
            this.imagesOnDiskMask.put(key, maskCol);
            this.imagesOnDiskCompCount.put(key, componentCount);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    public boolean isRawImageDataSaved(String number) {
        return this.imagesOnDiskAsBytes.get(Integer.valueOf(number)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRawImageData(String i) {
        byte[] data = null;
        String cachedFile = this.imagesOnDiskAsBytes.get(Integer.valueOf(i));
        if (cachedFile != null) {
            BufferedInputStream from = null;
            try {
                File fis = new File(cachedFile);
                from = new BufferedInputStream(new FileInputStream(fis));
                data = new byte[(int)fis.length()];
                from.read(data);
                if (this.encHash != null) {
                    CryptoIDR crypto = new CryptoIDR(this.encHash);
                    data = crypto.decrypt(data);
                }
                from.close();
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            finally {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (Exception e) {
                        LogWriter.writeLog(e.getMessage());
                    }
                }
            }
        }
        return data;
    }

    public Object getRawImageDataParameter(String imageID, Integer key) {
        Integer lookup = Integer.valueOf(imageID);
        Object returnVal = null;
        if (key.equals(IMAGE_WIDTH)) {
            returnVal = this.imagesOnDiskAsBytesW.get(lookup);
        } else if (key.equals(IMAGE_HEIGHT)) {
            returnVal = this.imagesOnDiskAsBytesH.get(lookup);
        } else if (key.equals(IMAGE_DEPTH)) {
            returnVal = this.imagesOnDiskAsBytesD.get(lookup);
        } else if (key.equals(IMAGE_pX)) {
            returnVal = this.imagesOnDiskAsBytespX.get(lookup);
        } else if (key.equals(IMAGE_pY)) {
            returnVal = this.imagesOnDiskAsBytespY.get(lookup);
        } else if (key.equals(IMAGE_MASKCOL)) {
            returnVal = this.imagesOnDiskMask.get(lookup);
        } else if (key.equals(IMAGE_COMPONENT_COUNT)) {
            returnVal = this.imagesOnDiskCompCount.get(lookup);
        }
        return returnVal;
    }

    public static File createTempFile(String filename) throws IOException {
        StringBuilder prefix = new StringBuilder(filename.substring(0, filename.lastIndexOf(46)));
        while (prefix.length() < 3) {
            prefix.append('a');
        }
        String suffix = filename.substring(filename.lastIndexOf(46));
        if (suffix.length() < 3) {
            suffix = "pdf";
        }
        File tempURLFile = File.createTempFile(prefix.toString(), suffix, new File(temp_dir));
        return tempURLFile;
    }

    public void setFileToDeleteOnFlush(String rawFileName) {
        this.tempFileNames.put(rawFileName, "#");
    }

    public String getKey() {
        return this.key;
    }

    public void setEncHash(byte[] pass) {
        this.encHash = pass;
    }

    public static void writeToFile(String fileName, byte[] data) throws IOException {
        ObjectStore.writeToFile(fileName, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String fileName, byte[] data, byte[] password) throws IOException {
        if (password != null) {
            CryptoIDR crypto = new CryptoIDR(password);
            try {
                data = crypto.encrypt(data);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(fileName)));
        try {
            fos.write(data);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFromFile(String fileName, byte[] password) throws IOException {
        File file = new File(fileName);
        byte[] data = new byte[(int)file.length()];
        BufferedInputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file));
            fis.read(data);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    LogWriter.writeLog(e.getMessage());
                }
            }
        }
        if (password != null) {
            CryptoIDR crypto = new CryptoIDR(password);
            try {
                data = crypto.decrypt(data);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return data;
    }

    public void flushPageLevelCaches() {
        this.memoryBufferMap.clear();
    }

    public void setIdrPassword(byte[] idrPassword) {
        this.idrPassword = idrPassword;
    }

    public byte[] getIdrPassword() {
        return this.idrPassword;
    }

    static {
        separator = System.getProperty("file.separator");
        temp_dir = "";
        IMAGE_WIDTH = 1;
        IMAGE_HEIGHT = 2;
        IMAGE_pX = 3;
        IMAGE_pY = 4;
        IMAGE_MASKCOL = 5;
        IMAGE_DEPTH = 7;
        IMAGE_COMPONENT_COUNT = 8;
        time = 14400000L;
        pagesOnDisk = new ConcurrentHashMap<String, String>();
        pagesOnDiskAsBytes = new ConcurrentHashMap<String, String>();
        ObjectStore.setProperties();
    }
}

