/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    public static boolean isUsingARGB;

    public static BufferedImage convertFromICCCMYK(int width, int height, byte[] data) {
        int size = width * height * 4;
        if (data.length < size) {
            byte[] newData = new byte[size];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        int dim = width * height;
        byte[] bp = ExternalHandlers.ImageLib.convertCMYK2RGB(width, height, size, data);
        if (bp == null) {
            bp = DeviceCMYKColorSpace.convertCMYK2RGBWithSimple(width, height, size, data);
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int i = 0; i < dim; ++i) {
            int r = bp[pos++] & 0xFF;
            int g = bp[pos++] & 0xFF;
            int b = bp[pos++] & 0xFF;
            pixels[i] = r << 16 | g << 8 | b;
        }
        return img;
    }

    public static BufferedImage convertToRGB(BufferedImage image) {
        if (image.getType() != 1) {
            try {
                if (image.getType() == 2) {
                    return ColorSpaceConvertor.convertARGBToRGB(image);
                }
                BufferedImage raw_image = image;
                image = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                new ColorConvertOp(ColorSpaces.hints).filter(raw_image, image);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " converting to RGB");
            }
            catch (Error ee) {
                LogWriter.writeLog("Error " + ee + " converting to RGB");
                image = null;
            }
        }
        return image;
    }

    private static BufferedImage convertARGBToRGB(BufferedImage image) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        int[] pixelsOut = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        System.arraycopy(pixels, 0, pixelsOut, 0, pixels.length);
        return result;
    }

    public static BufferedImage convertToARGB(BufferedImage image) {
        if (image.getType() != 2) {
            try {
                BufferedImage raw_image = image;
                image = new BufferedImage(raw_image.getWidth(), raw_image.getHeight(), 2);
                ColorConvertOp xformOp = new ColorConvertOp(null);
                xformOp.filter(raw_image, image);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " creating argb image");
            }
        }
        isUsingARGB = true;
        return image;
    }

    public static BufferedImage algorithmicConvertYCbCrToRGB(byte[] buffer, int w, int h) {
        BufferedImage image = null;
        byte[] new_data = new byte[w * h * 3];
        int pixelCount = w * h * 3;
        if (pixelCount > buffer.length) {
            pixelCount = buffer.length;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int lastY = -1;
        int lastCb = -1;
        int lastCr = -1;
        int pixelReached = 0;
        for (int i = 0; i < pixelCount; i += 3) {
            int Y = buffer[i] & 0xFF;
            int Cb = buffer[1 + i] & 0xFF;
            int Cr = buffer[2 + i] & 0xFF;
            if (lastY != Y || lastCb != Cb || lastCr != Cr) {
                float val1 = 298.082f * (float)Y;
                r = (int)((double)((val1 + 408.583f * (float)Cr) / 256.0f) - 222.921);
                if (r < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if ((g = (int)((val1 - 100.291f * (float)Cb - 208.12f * (float)Cr) / 256.0f + 135.576f)) < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if ((b = (int)((val1 + 516.412f * (float)Cb) / 256.0f - 276.836f)) < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                lastY = Y;
                lastCb = Cb;
                lastCr = Cr;
            }
            new_data[pixelReached++] = (byte)r;
            new_data[pixelReached++] = (byte)g;
            new_data[pixelReached++] = (byte)b;
        }
        try {
            image = new BufferedImage(w, h, 1);
            Raster raster = ColorSpaceConvertor.createInterleavedRaster(new_data, w, h);
            image.setData(raster);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
        }
        return image;
    }

    public static BufferedImage convertIndexedToFlat(int d, int w, int h, byte[] data, byte[] index, boolean isARGB, boolean isDownsampled) {
        int[] bands;
        int[] bandsRGB = new int[]{0, 1, 2};
        int[] bandsARGB = new int[]{0, 1, 2, 3};
        int components = 3;
        if (isARGB) {
            bands = bandsARGB;
            components = 4;
        } else {
            bands = bandsRGB;
        }
        byte[] newData = ColorSpaceConvertor.convertIndexToRGBByte(index, w, h, d, data, isDownsampled, isARGB);
        BufferedImage image = isARGB ? new BufferedImage(w, h, 2) : new BufferedImage(w, h, 1);
        DataBufferByte db = new DataBufferByte(newData, newData.length);
        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * components, components, bands, null);
        image.setData(raster);
        return image;
    }

    public static byte[] normaliseTo8Bit(int d, int w, int h, byte[] data) throws RuntimeException {
        if (d != 8) {
            int newSize = w * h;
            byte[] newData = new byte[newSize];
            switch (d) {
                case 1: {
                    ColorSpaceConvertor.flatten1bpc(w, data, null, false, newSize, 0, newData);
                    break;
                }
                case 2: {
                    ColorSpaceConvertor.flatten2bpc(w, data, null, false, newSize, newData);
                    break;
                }
                case 4: {
                    ColorSpaceConvertor.flatten4bpc(w, data, newSize, newData);
                    break;
                }
                case 16: {
                    for (int ptr = 0; ptr < newSize; ++ptr) {
                        newData[ptr] = data[ptr * 2];
                    }
                    break;
                }
                default: {
                    LogWriter.writeLog("unknown comp= " + d);
                }
            }
            data = newData;
        }
        return data;
    }

    public static byte[] convertIndexToRGBByte(byte[] index, int w, int h, int d, byte[] data, boolean isDownsampled, boolean isARGB) {
        int indexLength = 0;
        if (index != null) {
            indexLength = index.length;
        }
        int length = isARGB ? w * h * 4 : w * h * 3;
        byte[] newData = new byte[length];
        switch (d) {
            case 8: {
                ColorSpaceConvertor.flatten8bpc(data, isDownsampled, length, newData, index, indexLength, isARGB);
                break;
            }
            case 4: {
                ColorSpaceConvertor.flatten4bpc(w, data, index, isARGB, length, newData);
                break;
            }
            case 2: {
                ColorSpaceConvertor.flatten2bpc(w, data, index, isARGB, length, newData);
                break;
            }
            case 1: {
                ColorSpaceConvertor.flatten1bpc(w, data, index, isARGB, length, 255, newData);
            }
        }
        return newData;
    }

    private static void flatten8bpc(byte[] data, boolean isDownsampled, int length, byte[] newData, byte[] index, int indexLength, boolean isARGB) {
        int pt = 0;
        int id = 0;
        float ratio = 0.0f;
        for (byte currentByte : data) {
            if (pt >= length) break;
            if (isDownsampled) {
                ratio = (float)(currentByte & 0xFF) / 255.0f;
                if (ratio > 0.0f) {
                    newData[pt++] = (byte)((float)(255 - index[0]) * ratio);
                    newData[pt++] = (byte)((float)(255 - index[1]) * ratio);
                    newData[pt++] = (byte)((float)(255 - index[2]) * ratio);
                } else {
                    pt += 3;
                }
            } else {
                id = (currentByte & 0xFF) * 3;
                if (id < indexLength) {
                    newData[pt++] = index[id];
                    newData[pt++] = index[id + 1];
                    newData[pt++] = index[id + 2];
                }
            }
            if (!isARGB) continue;
            newData[pt++] = id == 0 && ratio == 0.0f ? -1 : 0;
        }
    }

    private static void flatten4bpc(int w, byte[] data, byte[] index, boolean isARGB, int length, byte[] newData) {
        int pt = 0;
        int[] shift = new int[]{4, 0};
        int widthReached = 0;
        block0: for (byte aData : data) {
            for (int samples = 0; samples < 2; ++samples) {
                int id1 = (aData >> shift[samples] & 0xF) * 3;
                if (pt >= length) continue block0;
                newData[pt++] = index[id1];
                newData[pt++] = index[id1 + 1];
                newData[pt++] = index[id1 + 2];
                if (isARGB) {
                    newData[pt++] = 0;
                }
                if (++widthReached != w) continue;
                widthReached = 0;
                samples = 8;
            }
        }
    }

    public static void flatten1bpc(int w, byte[] data, byte[] index, boolean isARGB, int length, int transparency, byte[] newData) {
        int pt = 0;
        int widthReached = 0;
        block0: for (byte aData : data) {
            for (int bits = 0; bits < 8; ++bits) {
                int id = aData >> 7 - bits & 1;
                if (pt >= length) continue block0;
                if (isARGB) {
                    newData[pt++] = index[id *= 3];
                    newData[pt++] = index[id + 1];
                    newData[pt++] = index[id + 2];
                    newData[pt++] = id == 0 ? (byte)transparency : (byte)0;
                } else if (index == null) {
                    newData[pt++] = id == 1 ? -1 : 0;
                } else {
                    int comp = isARGB ? 4 : 3;
                    if (index.length == 2 && comp == 3) {
                        byte v = index[id];
                        for (int i = 0; i < comp; ++i) {
                            newData[pt++] = v;
                        }
                    } else {
                        id *= comp;
                        for (int ii = 0; ii < comp; ++ii) {
                            newData[pt++] = index[id + ii];
                        }
                    }
                }
                if (++widthReached != w) continue;
                widthReached = 0;
                bits = 8;
            }
        }
    }

    private static void flatten2bpc(int w, byte[] data, byte[] index, boolean isARGB, int length, byte[] newData) {
        int pt = 0;
        int[] shift = new int[]{6, 4, 2, 0};
        int widthReached = 0;
        for (byte aData : data) {
            for (int samples = 0; samples < 4 && pt < length; ++samples) {
                int id1;
                if (index == null) {
                    id1 = aData << shift[3 - samples] & 0xC0;
                    if (id1 == 192) {
                        id1 = 255;
                    }
                    newData[pt++] = (byte)id1;
                } else {
                    id1 = (aData >> shift[samples] & 3) * 3;
                    newData[pt++] = index[id1];
                    newData[pt++] = index[id1 + 1];
                    newData[pt++] = index[id1 + 2];
                    if (isARGB) {
                        newData[pt++] = 0;
                    }
                }
                if (++widthReached != w) continue;
                widthReached = 0;
                samples = 8;
            }
        }
    }

    public static BufferedImage iccConvertCMYKImageToRGB(byte[] buffer, int w, int h) {
        int pixelCount = w * h * 4;
        int lastY = -1;
        int lastCb = -1;
        int lastCr = -1;
        int lastCENTER = -1;
        int outputC = 0;
        int outputM = 0;
        int outputY = 0;
        for (int i = 0; i < pixelCount; i += 4) {
            int Y = buffer[i] & 0xFF;
            int Cb = buffer[i + 1] & 0xFF;
            int Cr = buffer[i + 2] & 0xFF;
            int CENTER = buffer[i + 3] & 0xFF;
            if (Y != lastY || Cb != lastCb || Cr != lastCr || CENTER != lastCENTER) {
                double R = (double)Y + 1.402 * (double)Cr - 179.456;
                if (R < 0.0) {
                    R = 0.0;
                } else if (R > 255.0) {
                    R = 255.0;
                }
                double G2 = (double)Y - 0.34414 * (double)Cb - 0.71414 * (double)Cr + 135.45984;
                if (G2 < 0.0) {
                    G2 = 0.0;
                } else if (G2 > 255.0) {
                    G2 = 255.0;
                }
                double B2 = (double)Y + 1.772 * (double)Cb - 226.816;
                if (B2 < 0.0) {
                    B2 = 0.0;
                } else if (B2 > 255.0) {
                    B2 = 255.0;
                }
                outputC = 255 - (int)R;
                outputM = 255 - (int)G2;
                outputY = 255 - (int)B2;
                lastY = Y;
                lastCb = Cb;
                lastCr = Cr;
                lastCENTER = CENTER;
            }
            buffer[i] = (byte)outputC;
            buffer[i + 1] = (byte)outputM;
            buffer[i + 2] = (byte)outputY;
        }
        return ExternalHandlers.ImageLib.convert(buffer, w, h);
    }

    public static BufferedImage convertColorspace(BufferedImage image, int newType) {
        try {
            BufferedImage raw_image = image;
            image = new BufferedImage(raw_image.getWidth(), raw_image.getHeight(), newType);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(raw_image, image);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " converting image");
        }
        return image;
    }

    private static double clip01(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }

    public static Raster createInterleavedRaster(byte[] data, int w, int h) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2};
        return Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
    }

    private static void flatten4bpc(int w, byte[] data, int newSize, byte[] newData) {
        int origSize = data.length;
        int ptr = 0;
        int currentLine = 0;
        boolean oddValues = (w & 1) == 1;
        for (int ii = 0; ii < origSize; ++ii) {
            byte rawByte = data[ii];
            currentLine += 2;
            newData[ptr] = (byte)(rawByte & 0xF0);
            if (newData[ptr] == -16) {
                newData[ptr] = -1;
            }
            ++ptr;
            if (oddValues && currentLine > w) {
                currentLine = 0;
            } else {
                newData[ptr] = (byte)((rawByte & 0xF) << 4);
                if (newData[ptr] == -16) {
                    newData[ptr] = -1;
                }
                ++ptr;
            }
            if (ptr != newSize) continue;
            ii = origSize;
        }
    }

    public static BufferedImage createARGBImage(int width, int height, byte[] data) {
        DataBufferByte db = new DataBufferByte(data, data.length);
        int[] bands = new int[]{0, 1, 2, 3};
        BufferedImage image = new BufferedImage(width, height, 2);
        WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 4, 4, bands, null);
        image.setData(raster);
        return image;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] buffer, int w, int h) {
        BufferedImage image = null;
        byte[] new_data = new byte[w * h * 3];
        int pixelCount = w * h * 4;
        double lastC = -1.0;
        double lastM = -1.12;
        double lastY = -1.12;
        double lastK = -1.21;
        double x = 255.0;
        double outRed = 0.0;
        double outGreen = 0.0;
        double outBlue = 0.0;
        int pixelReached = 0;
        for (int i = 0; i < pixelCount; i += 4) {
            double inCyan = (double)(buffer[i] & 0xFF) / 255.0;
            double inMagenta = (double)(buffer[i + 1] & 0xFF) / 255.0;
            double inYellow = (double)(buffer[i + 2] & 0xFF) / 255.0;
            double inBlack = (double)(buffer[i + 3] & 0xFF) / 255.0;
            if (lastC != inCyan || lastM != inMagenta || lastY != inYellow || lastK != inBlack) {
                double k = 1.0;
                double c = ColorSpaceConvertor.clip01(inCyan + inBlack);
                double m = ColorSpaceConvertor.clip01(inMagenta + inBlack);
                double y = ColorSpaceConvertor.clip01(inYellow + inBlack);
                double aw = (1.0 - c) * (1.0 - m) * (1.0 - y);
                double ac = c * (1.0 - m) * (1.0 - y);
                double am = (1.0 - c) * m * (1.0 - y);
                double ay = (1.0 - c) * (1.0 - m) * y;
                double ar = (1.0 - c) * m * y;
                double ag = c * (1.0 - m) * y;
                double ab = c * m * (1.0 - y);
                outRed = 255.0 * ColorSpaceConvertor.clip01(aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                outGreen = 255.0 * ColorSpaceConvertor.clip01(aw + 0.6196 * ac + ay + 0.5176 * ag);
                outBlue = 255.0 * ColorSpaceConvertor.clip01(aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                lastC = inCyan;
                lastM = inMagenta;
                lastY = inYellow;
                lastK = inBlack;
            }
            new_data[pixelReached++] = (byte)outRed;
            new_data[pixelReached++] = (byte)outGreen;
            new_data[pixelReached++] = (byte)outBlue;
        }
        try {
            image = new BufferedImage(w, h, 1);
            Raster raster = ColorSpaceConvertor.createInterleavedRaster(new_data, w, h);
            image.setData(raster);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
        }
        return image;
    }
}

