/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

class PostScriptCompiler {
    private static final int C_ABS = 96370;
    private static final int C_ADD = 96417;
    private static final int C_ATAN = 3004320;
    private static final int C_CEILING = 660387005;
    private static final int C_COS = 98695;
    private static final int C_CVI = 98902;
    private static final int C_CVR = 98911;
    private static final int C_DIV = 99473;
    private static final int C_EXP = 100893;
    private static final int C_FLOOR = 97526796;
    private static final int C_IDIV = 3227528;
    private static final int C_LN = 3458;
    private static final int C_LOG = 107332;
    private static final int C_MOD = 108290;
    private static final int C_MUL = 108484;
    private static final int C_NEG = 108944;
    private static final int C_SIN = 113880;
    private static final int C_SQRT = 3538208;
    private static final int C_SUB = 114240;
    private static final int C_ROUND = 108704142;
    private static final int C_TRUNCATE = 1852984678;
    private static final int C_AND = 96727;
    private static final int C_BITSHIFT = 1125715861;
    private static final int C_EQ = 3244;
    private static final int C_FALSE = 97196323;
    private static final int C_GE = 3294;
    private static final int C_GT = 3309;
    private static final int C_LE = 3449;
    private static final int C_LT = 3464;
    private static final int C_NE = 3511;
    private static final int C_NOT = 109267;
    private static final int C_OR = 3555;
    private static final int C_TRUE = 3569038;
    private static final int C_XOR = 118875;
    private static final int C_IF = 3357;
    private static final int C_IFELSE = -1191590954;
    private static final int C_COPY = 3059573;
    private static final int C_EXCH = 3127384;
    private static final int C_POP = 111185;
    private static final int C_DUP = 99839;
    private static final int C_INDEX = 100346066;
    private static final int C_ROLL = 3506301;
    private static final int T_COMMAND = 1;
    private static final int T_NUMBER = 2;
    private static final int T_BOOLEAN = 3;
    private static final int T_SBRACE = 123;
    private static final int T_EBRACE = 125;
    private static final double radToDegrees = 57.29577951308232;
    private static final double toBase10 = Math.log(10.0);
    private static final byte[] CHAR256 = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private double[] dValues = new double[50];
    private int[] dTypes = new int[50];
    private final int[] dInts;
    private final double[] cValues;
    private final int[] cTypes;
    private int sp;
    private int dp;
    private int cp;
    private final int maxP;
    public final Map<Integer, Integer> endBraces = new HashMap<Integer, Integer>();
    public final Map<Integer, Integer> startBraces = new HashMap<Integer, Integer>();

    PostScriptCompiler(byte[] stream) {
        this.parseStream(stream);
        this.maxP = this.dp;
        this.cValues = new double[Math.max(50, this.maxP)];
        this.cTypes = new int[this.cValues.length];
        this.dInts = new int[this.dValues.length];
        int ii = this.dValues.length;
        for (int i = 0; i < ii; ++i) {
            this.dInts[i] = (int)this.dValues[i];
        }
    }

    private void parseStream(byte[] stream) {
        Stack<Integer> braces = new Stack<Integer>();
        int len = stream.length;
        while (this.sp < len) {
            int com;
            StringBuilder sb;
            int cc;
            if ((cc = stream[this.sp++] & 0xFF) == 123) {
                if (!braces.empty()) {
                    this.pushDefault(123.0, 123);
                }
                braces.push(1);
                continue;
            }
            if (cc == 125) {
                braces.pop();
                if (braces.empty()) continue;
                this.pushDefault(125.0, 125);
                continue;
            }
            if (PostScriptCompiler.isDigit(cc) || PostScriptCompiler.isFullStop(cc) || cc == 43 || cc == 45) {
                sb = new StringBuilder();
                while (this.sp < len) {
                    if (PostScriptCompiler.isWhiteSpace(cc) || PostScriptCompiler.isDelimiter(cc)) {
                        --this.sp;
                        break;
                    }
                    sb.append((char)cc);
                    cc = stream[this.sp++] & 0xFF;
                }
                this.pushDefault(Double.parseDouble(sb.toString()), 2);
                continue;
            }
            if (cc <= 96 || cc >= 123) continue;
            sb = new StringBuilder();
            while (this.sp < len) {
                if (PostScriptCompiler.isWhiteSpace(cc) || PostScriptCompiler.isDelimiter(cc)) {
                    --this.sp;
                    break;
                }
                sb.append((char)cc);
                cc = stream[this.sp++] & 0xFF;
            }
            if ((com = PostScriptCompiler.getCommand(sb.toString())) == -1) continue;
            this.pushDefault(com, 1);
        }
        braces.clear();
        block7: for (int i = 0; i < this.dp; ++i) {
            switch (this.dTypes[i]) {
                case 123: {
                    braces.push(i);
                    continue block7;
                }
                case 125: {
                    int start = (Integer)braces.pop();
                    this.endBraces.put(i, start);
                    this.startBraces.put(start, i);
                }
            }
        }
    }

    private static int getCommand(String s) {
        int sh = s.hashCode();
        switch (sh) {
            case -1191590954: 
            case 3244: 
            case 3294: 
            case 3309: 
            case 3357: 
            case 3449: 
            case 3458: 
            case 3464: 
            case 3511: 
            case 3555: 
            case 96370: 
            case 96417: 
            case 96727: 
            case 98695: 
            case 98902: 
            case 98911: 
            case 99473: 
            case 99839: 
            case 100893: 
            case 107332: 
            case 108290: 
            case 108484: 
            case 108944: 
            case 109267: 
            case 111185: 
            case 113880: 
            case 114240: 
            case 118875: 
            case 3004320: 
            case 3059573: 
            case 3127384: 
            case 3227528: 
            case 3506301: 
            case 3538208: 
            case 3569038: 
            case 97196323: 
            case 97526796: 
            case 100346066: 
            case 108704142: 
            case 660387005: 
            case 1125715861: 
            case 1852984678: {
                return sh;
            }
        }
        return -1;
    }

    private void pushDefault(double value, int type) {
        if (this.dp >= this.dValues.length) {
            int len = this.dValues.length;
            double[] tempV = new double[len << 1];
            System.arraycopy(this.dValues, 0, tempV, 0, len);
            this.dValues = tempV;
            int[] tempT = new int[len << 1];
            System.arraycopy(this.dTypes, 0, tempT, 0, len);
            this.dTypes = tempT;
        }
        this.dValues[this.dp] = value;
        this.dTypes[this.dp] = type;
        ++this.dp;
    }

    private static boolean isWhiteSpace(int ch) {
        return CHAR256[ch] == 1;
    }

    private static boolean isDigit(int ch) {
        return CHAR256[ch] == 4;
    }

    private static boolean isFullStop(int ch) {
        return ch == 46;
    }

    private static boolean isDelimiter(int ch) {
        return CHAR256[ch] == 2;
    }

    private void executeCommand(int cmd) {
        switch (cmd) {
            case 99839: {
                this.C_DUP();
                break;
            }
            case 111185: {
                this.popItem();
                break;
            }
            case 96370: {
                this.C_ABS();
                break;
            }
            case 96417: {
                this.C_ADD();
                break;
            }
            case 3004320: {
                this.C_ATAN();
                break;
            }
            case 660387005: {
                this.C_CEILING();
                break;
            }
            case 98695: {
                this.C_COS_OR_SIN();
                break;
            }
            case 98902: {
                this.C_CVI();
                break;
            }
            case 98911: {
                this.C_CVR();
                break;
            }
            case 99473: {
                this.C_DIV();
                break;
            }
            case 100893: {
                this.C_EXP();
                break;
            }
            case 97526796: {
                this.C_FLOOR();
                break;
            }
            case 3227528: {
                this.C_IDIV();
                break;
            }
            case 3458: {
                this.C_LN();
                break;
            }
            case 107332: {
                this.C_LOG();
                break;
            }
            case 108290: {
                this.C_MOD();
                break;
            }
            case 108484: {
                this.C_MUL();
                break;
            }
            case 108944: {
                this.C_NEG();
                break;
            }
            case 113880: {
                this.C_COS_OR_SIN();
                break;
            }
            case 3538208: {
                this.C_SORT();
                break;
            }
            case 114240: {
                this.C_SUB();
                break;
            }
            case 108704142: {
                this.C_ROUND();
                break;
            }
            case 1852984678: {
                this.C_TRUNCATE();
                break;
            }
            case 96727: {
                this.C_AND();
                break;
            }
            case 1125715861: {
                this.C_BITSHIFT();
                break;
            }
            case 3244: {
                this.C_EQ();
                break;
            }
            case 97196323: {
                this.C_FALSE();
                break;
            }
            case 3294: {
                this.C_GE();
                break;
            }
            case 3309: {
                this.C_GT();
                break;
            }
            case 3449: {
                this.C_LE();
                break;
            }
            case 3464: {
                this.C_LT();
                break;
            }
            case 3511: {
                this.C_NE();
                break;
            }
            case 109267: {
                this.C_NOT();
                break;
            }
            case 3555: {
                this.C_OR();
                break;
            }
            case 3569038: {
                this.C_TRUE();
                break;
            }
            case 118875: {
                this.C_XOR();
                break;
            }
            case 3357: {
                this.C_IF();
                break;
            }
            case -1191590954: {
                this.C_IFELSE();
                break;
            }
            case 3059573: {
                this.C_COPY();
                break;
            }
            case 3127384: {
                this.C_EXCH();
                break;
            }
            case 100346066: {
                this.C_INDEX();
                break;
            }
            case 3506301: {
                this.C_ROLL();
            }
        }
    }

    private void C_ABS() {
        this.popItem();
        this.cValues[this.cp] = Math.abs(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_ATAN() {
        double tt;
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        double sv = this.cValues[this.cp];
        double tangent = sv / fv;
        if (fv >= 0.0 && sv >= 0.0) {
            tt = Math.toDegrees(Math.atan(tangent));
        } else if (fv > 0.0) {
            double tmp = Math.abs(Math.toDegrees(Math.atan(tangent)));
            tt = tmp + 90.0;
        } else if (sv <= 0.0) {
            double tmp = Math.abs(Math.toDegrees(Math.atan(tangent)));
            tt = tmp + 180.0;
        } else {
            double tmp = Math.abs(Math.toDegrees(Math.atan(tangent)));
            tt = tmp + 270.0;
        }
        this.cValues[this.cp] = tt;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_ADD() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        int n = this.cp;
        this.cValues[n] = this.cValues[n] + fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_CEILING() {
        this.popItem();
        this.cValues[this.cp] = Math.ceil(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_COS_OR_SIN() {
        this.popItem();
        this.cValues[this.cp] = Math.sin(this.cValues[this.cp] / 57.29577951308232);
        ++this.cp;
    }

    private void C_CVI() {
        this.popItem();
        this.cValues[this.cp] = (int)this.cValues[this.cp];
        ++this.cp;
    }

    private void C_CVR() {
        this.popItem();
        ++this.cp;
    }

    private void C_DIV() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        int n = this.cp;
        this.cValues[n] = this.cValues[n] / fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_EXP() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        this.cValues[this.cp] = Math.pow(this.cValues[this.cp], fv);
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_FLOOR() {
        this.popItem();
        this.cValues[this.cp] = Math.floor(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_IDIV() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        this.cValues[this.cp] = (int)this.cValues[this.cp] / (int)fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_LN() {
        this.popItem();
        this.cValues[this.cp] = Math.log(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_LOG() {
        this.popItem();
        this.cValues[this.cp] = Math.log(this.cValues[this.cp]) / toBase10;
        ++this.cp;
    }

    private void C_MOD() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        this.cValues[this.cp] = (int)this.cValues[this.cp] % (int)fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_MUL() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        this.cValues[this.cp] = fv * this.cValues[this.cp];
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_NEG() {
        this.popItem();
        this.cValues[this.cp] = -this.cValues[this.cp];
        ++this.cp;
    }

    private void C_SORT() {
        this.cValues[this.cp] = Math.sqrt(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_SUB() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        int n = this.cp;
        this.cValues[n] = this.cValues[n] - fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_ROUND() {
        this.popItem();
        this.cValues[this.cp] = Math.round(this.cValues[this.cp]);
        ++this.cp;
    }

    private void C_TRUNCATE() {
        this.popItem();
        this.cValues[this.cp] = (int)this.cValues[this.cp];
        ++this.cp;
    }

    private void C_AND() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        double sv = this.cValues[this.cp];
        int st = this.cTypes[this.cp];
        if (ft == 2 && st == 2) {
            this.cValues[this.cp] = (int)sv & (int)fv;
            this.cTypes[this.cp] = 2;
        } else {
            this.cValues[this.cp] = fv == sv ? 1.0 : 0.0;
            this.cTypes[this.cp] = 3;
        }
        ++this.cp;
    }

    private void C_BITSHIFT() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        this.cValues[this.cp] = (int)this.cValues[this.cp] << (int)fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_EQ() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = fv == this.cValues[this.cp] ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_FALSE() {
        this.cValues[this.cp] = 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_GE() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = this.cValues[this.cp] >= fv ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_GT() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = this.cValues[this.cp] > fv ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_LE() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = this.cValues[this.cp] <= fv ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_LT() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = this.cValues[this.cp] < fv ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_NE() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.popItem();
        this.cValues[this.cp] = this.cValues[this.cp] != fv ? 1.0 : 0.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_NOT() {
        this.popItem();
        double fv = this.cValues[this.cp];
        this.cValues[this.cp] = this.cTypes[this.cp] == 2 ? (double)(~((int)fv)) : (fv != 1.0 ? 1.0 : 0.0);
        ++this.cp;
    }

    private void C_OR() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        double sv = this.cValues[this.cp];
        int st = this.cTypes[this.cp];
        if (ft == 2 && st == 2) {
            this.cValues[this.cp] = (int)sv | (int)fv;
            this.cTypes[this.cp] = 2;
        } else {
            this.cValues[this.cp] = fv == 1.0 || sv == 1.0 ? 1.0 : 0.0;
            this.cTypes[this.cp] = 3;
        }
        ++this.cp;
    }

    private void C_TRUE() {
        this.cValues[this.cp] = 1.0;
        this.cTypes[this.cp] = 3;
        ++this.cp;
    }

    private void C_XOR() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        double sv = this.cValues[this.cp];
        int st = this.cTypes[this.cp];
        this.cValues[this.cp] = (int)sv ^ (int)fv;
        this.cTypes[this.cp] = ft == 2 && st == 2 ? 2 : 3;
        ++this.cp;
    }

    private void C_IF() {
        int old = this.dp;
        this.popItem();
        if (this.cValues[this.cp] == 1.0) {
            int braceCount = 0;
            while ((this.dTypes[this.dp] != 123 || braceCount > 0) && this.dp > 0) {
                --this.dp;
                if (this.dTypes[this.dp] == 125) {
                    ++braceCount;
                    continue;
                }
                if (this.dTypes[this.dp] != 123) continue;
                --braceCount;
            }
            ++this.dp;
            this.executeInterval(old);
        }
        this.dp = old;
    }

    private void C_IFELSE() {
        int old = this.dp;
        this.popItem();
        if (this.cValues[this.cp] == 1.0) {
            int cdp;
            while (this.dp > 0) {
                if ((cdp = this.dTypes[this.dp--]) != 125) continue;
                int v = this.endBraces.get(this.dp + 1);
                this.dp = v - 1;
                break;
            }
            int end = this.dp;
            while (this.dp > 0) {
                if ((cdp = this.dTypes[this.dp--]) != 125) continue;
                int v = this.endBraces.get(this.dp + 1);
                this.dp = v - 1;
                break;
            }
            this.dp += 2;
            this.executeInterval(end);
        } else {
            while (this.dp > 0) {
                int cdp;
                if ((cdp = this.dTypes[this.dp--]) != 125) continue;
                int v = this.endBraces.get(this.dp + 1);
                this.dp = v - 1;
                break;
            }
            this.dp += 2;
            this.executeInterval(old);
        }
        this.dp = old;
    }

    private void C_COPY() {
        this.popItem();
        if (this.cValues[this.cp] > 0.0) {
            int n = (int)this.cValues[this.cp];
            double[] values = new double[n];
            int[] types = new int[n];
            System.arraycopy(this.cValues, this.cValues.length - n, values, 0, n);
            System.arraycopy(this.cTypes, this.cValues.length - n, types, 0, n);
            for (int i = 0; i < n; ++i) {
                this.cValues[this.cp] = values[0];
                this.cTypes[this.cp] = types[1];
                ++this.cp;
            }
        }
    }

    private void C_EXCH() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        this.popItem();
        double sv = this.cValues[this.cp];
        int st = this.cTypes[this.cp];
        this.cValues[this.cp] = fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
        this.cValues[this.cp] = sv;
        this.cTypes[this.cp] = st;
        ++this.cp;
    }

    private void C_DUP() {
        this.popItem();
        double fv = this.cValues[this.cp];
        int ft = this.cTypes[this.cp];
        ++this.cp;
        this.cValues[this.cp] = fv;
        this.cTypes[this.cp] = ft;
        ++this.cp;
    }

    private void C_INDEX() {
        this.popItem();
        int n = (int)this.cValues[this.cp];
        this.cValues[this.cp] = this.cValues[this.cp - 1 - n];
        this.cTypes[this.cp] = this.cTypes[this.cp - 1 - n];
        ++this.cp;
    }

    private void C_ROLL() {
        int t;
        int i;
        this.popItem();
        double fv = this.cValues[this.cp];
        int j = (int)fv;
        this.popItem();
        int n = (int)this.cValues[this.cp];
        if (n == 0 || j == 0 || n > this.cp) {
            return;
        }
        LinkedList<Double> listV = new LinkedList<Double>();
        LinkedList<Integer> listT = new LinkedList<Integer>();
        for (i = 0; i < n; ++i) {
            this.popItem();
            fv = this.cValues[this.cp];
            int ft = this.cTypes[this.cp];
            listV.add(fv);
            listT.add(ft);
        }
        if (j > 0) {
            for (i = 0; i < j; ++i) {
                double v = (Double)listV.removeFirst();
                t = (Integer)listT.removeFirst();
                listV.addLast(v);
                listT.addLast(t);
            }
        } else {
            j *= -1;
            for (i = 0; i < j; ++i) {
                double v = (Double)listV.removeLast();
                t = (Integer)listT.removeLast();
                listV.addFirst(v);
                listT.addFirst(t);
            }
        }
        for (i = 0; i < n; ++i) {
            this.cValues[this.cp] = (Double)listV.removeLast();
            this.cTypes[this.cp] = (Integer)listT.removeLast();
            ++this.cp;
        }
    }

    private void popItem() {
        --this.cp;
    }

    public double[] executeScript(float[] inp) {
        this.cp = inp.length;
        this.dp = 0;
        int ii = inp.length;
        for (int i = 0; i < ii; ++i) {
            this.cValues[i] = inp[i];
            this.cTypes[i] = 2;
        }
        this.executeInterval(this.maxP);
        return this.cValues;
    }

    private void executeInterval(int maxDP) {
        block5: while (this.dp < maxDP) {
            int type = this.dTypes[this.dp];
            switch (type) {
                case 1: {
                    this.executeCommand(this.dInts[this.dp]);
                    ++this.dp;
                    continue block5;
                }
                case 2: {
                    this.cValues[this.cp] = this.dValues[this.dp];
                    this.cTypes[this.cp] = type;
                    ++this.cp;
                    ++this.dp;
                    continue block5;
                }
                case 123: {
                    this.dp = this.startBraces.get(this.dp);
                    continue block5;
                }
            }
            ++this.dp;
        }
    }
}

