/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.text.NumberFormat;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

class Cvt
extends Table {
    private final short[] unscaledCvt;
    private final int[] cvt;
    private double scale;
    private static boolean messageDisplayed;

    Cvt(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(9);
        if (startPointer != 0) {
            int len = currentFontFile.getOffset(9) / 2;
            this.unscaledCvt = new short[len];
            this.cvt = new int[len];
            for (int i = 0; i < len; ++i) {
                this.unscaledCvt[i] = currentFontFile.getFWord();
            }
        } else {
            this.unscaledCvt = new short[0];
            this.cvt = new int[0];
        }
    }

    public void scale(double scale) {
        this.scale = scale;
        for (int i = 0; i < this.unscaledCvt.length; ++i) {
            this.cvt[i] = (int)(scale * (double)this.unscaledCvt[i] + 0.5);
        }
    }

    public void putInPixels(int key, int value) {
        if (key >= 0 && key < this.cvt.length) {
            this.cvt[key] = value;
        } else if (LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.putInPixels(): Key out of range. (" + key + ')');
        }
    }

    public void putInFUnits(int key, int value) {
        value = (int)((double)value * this.scale + 0.5);
        if (key >= 0 && key < this.cvt.length) {
            this.cvt[key] = value;
        } else if (LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.putInFUnits(): Key out of range. (" + key + ')');
        }
    }

    public int get(int key) {
        if (key >= 0 && key < this.cvt.length) {
            return this.cvt[key];
        }
        if (!messageDisplayed && LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.get(): Key out of range. (" + key + ')');
            messageDisplayed = true;
        }
        return 0;
    }

    String[] getCVTForDebug() {
        String[] result = new String[this.cvt.length];
        for (int i = 0; i < this.cvt.length; ++i) {
            result[i] = i + ": " + this.cvt[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.cvt[i] / 64.0) + ')';
        }
        return result;
    }
}

