/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.PathData;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class TTGlyph
extends BaseTTGlyph
implements Serializable {
    private Area glyphShape;
    private boolean hasEndCurve;

    public void setPaths(Vector_Path vp) {
        this.paths = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.paths != null) {
            int i;
            GeneralPath[] generalPaths = this.paths.get();
            int count = 0;
            for (i = 0; i < generalPaths.length; ++i) {
                if (generalPaths[i] != null) continue;
                count = i;
                break;
            }
            os.writeObject(count);
            for (i = 0; i < count; ++i) {
                PathIterator pathIterator = generalPaths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    public TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName) {
        super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, baseFontName);
    }

    public TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm) {
        super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, vm);
    }

    @Override
    public void render(int type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        AffineTransform restore = g2.getTransform();
        BasicStroke oldStroke = (BasicStroke)g2.getStroke();
        float strokeWidth = oldStroke.getLineWidth();
        if (strokeWidth < 0.0f) {
            strokeWidth = -strokeWidth;
        }
        if (this.hasHinting()) {
            g2.scale(0.01, 0.01);
            strokeWidth *= 100.0f;
        }
        g2.setStroke(new BasicStroke(strokeWidth, 0, 1, oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase()));
        for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
            if ((type & 2) == 2) {
                g2.fill(this.paths.elementAt(jj));
                continue;
            }
            if ((type & 1) != 1 || this.hasEndCurve && ((BasicStroke)g2.getStroke()).getDashPhase() == 0.0f && ((BasicStroke)g2.getStroke()).getDashArray() != null) continue;
            g2.draw(this.paths.elementAt(jj));
        }
        if (this.hasHinting()) {
            g2.setStroke(oldStroke);
            g2.setTransform(restore);
        }
    }

    @Override
    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath path = this.paths.elementAt(0);
            if (path != null) {
                path = (GeneralPath)path.clone();
                for (int jj = 1; jj < this.paths.size() - 1; ++jj) {
                    GeneralPath nextPath = this.paths.elementAt(jj);
                    if (nextPath == null) continue;
                    path.append(nextPath, false);
                }
            } else {
                return null;
            }
            this.glyphShape = new Area(path);
        }
        return this.glyphShape;
    }

    @Override
    public void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex) {
        if (endOfContour == null) {
            return;
        }
        TTGlyph.setFirstPoint(endOfContour, onCurve, pX, pY);
        int c = pX.length;
        int fc = TTGlyph.getEndofFirstContour(endOfContour, c);
        PathData pathData = new PathData(pX, pY, onCurve, endOfContour);
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < endIndex; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                fc = TTGlyph.findNextContour(endOfContour, c, fc, j);
            }
            if (lc == fc && onCurve[p] && p - endIndex > 1) {
                j = c;
                continue;
            }
            if (onCurve[p] && onCurve[p1]) {
                pathData.straightLine(p1);
            } else if (j < c - 3 && (fc - lc >= 1 || fc == lc)) {
                j = pathData.calcCurvePoints(p, p1, p2, pm1, fc, j);
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    this.hasEndCurve = true;
                    pathData.completeCurve();
                }
                if (pathData.checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    fc = TTGlyph.findNextContour(endOfContour, c, fc, j);
                }
            }
            if (endOfContour[p]) {
                pathData.closePath();
            }
            if (!isEnd) continue;
            pathData.moveTo(xs, ys);
            isEnd = false;
        }
        this.paths.addElement(pathData.getPath());
    }

    private static int findNextContour(boolean[] endOfContour, int c, int fc, int j) {
        for (int jj = j + 1; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return fc;
    }

    private static int getEndofFirstContour(boolean[] endOfContour, int c) {
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return fc;
    }

    private static void setFirstPoint(boolean[] endOfContour, boolean[] onCurve, int[] pX, int[] pY) {
        int ptCount = endOfContour.length;
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    TTGlyph.setPoint(pX, pY, onCurve, start, firstPt, ii);
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
    }

    private static void setPoint(int[] pX, int[] pY, boolean[] onCurve, int start, int firstPt, int ii) {
        int diff = firstPt - start;
        int pXlength = pX.length;
        int[] old_pX = new int[pXlength];
        System.arraycopy(pX, 0, old_pX, 0, pXlength);
        int[] old_pY = new int[pXlength];
        System.arraycopy(pY, 0, old_pY, 0, pXlength);
        boolean[] old_onCurve = new boolean[pXlength];
        System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
        for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
            int newPos = oldPos + diff;
            if (newPos > ii) {
                newPos -= ii - start + 1;
            }
            pX[oldPos] = old_pX[newPos];
            pY[oldPos] = old_pY[newPos];
            onCurve[oldPos] = old_onCurve[newPos];
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    void clearPaths() {
        this.paths.clear();
    }
}

