/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import org.jpedal.fonts.EncodingUCS2;
import org.jpedal.utils.LogWriter;

class UnicodeReader {
    private static final int[] powers = new int[]{1, 16, 256, 4096};
    private int dataLen;
    private final byte[] data;
    private boolean hasDoubleBytes;

    UnicodeReader(byte[] data) {
        this.data = data;
        if (data != null) {
            this.dataLen = data.length;
        }
    }

    public String[] readUnicode() {
        String[] unicodeMappings;
        block18: {
            if (this.data == null) {
                return null;
            }
            int defType = 0;
            int ptr = 0;
            unicodeMappings = new String[65536];
            boolean inDef = false;
            try {
                while (true) {
                    block21: {
                        block19: {
                            block20: {
                                if (ptr < this.dataLen && this.data[ptr] == 9) {
                                    ++ptr;
                                    continue;
                                }
                                if (ptr >= this.dataLen) break block18;
                                if (ptr + 4 < this.dataLen && this.data[ptr] == 101 && this.data[ptr + 1] == 110 && this.data[ptr + 2] == 100 && this.data[ptr + 3] == 98 && this.data[ptr + 4] == 102) {
                                    defType = 0;
                                    inDef = false;
                                } else if (inDef) {
                                    ptr = this.readLineValue(unicodeMappings, defType, ptr);
                                }
                                if (ptr >= this.dataLen) break block18;
                                if (this.data[ptr] != 98 || this.data[ptr + 1] != 101 || this.data[ptr + 2] != 103 || this.data[ptr + 3] != 105 || this.data[ptr + 4] != 110 || this.data[ptr + 5] != 98 || this.data[ptr + 6] != 102) break block19;
                                if (this.data[ptr + 7] != 99 || this.data[ptr + 8] != 104 || this.data[ptr + 9] != 97 || this.data[ptr + 10] != 114) break block20;
                                defType = 1;
                                ptr += 10;
                                inDef = true;
                                break block21;
                            }
                            if (this.data[ptr + 7] != 114 || this.data[ptr + 8] != 97 || this.data[ptr + 9] != 110 || this.data[ptr + 10] != 103 || this.data[ptr + 11] != 101) break block21;
                            defType = 2;
                            ptr += 11;
                            inDef = true;
                            break block21;
                        }
                        if (ptr - 20 > 0 && this.data[ptr] == 117 && this.data[ptr + 1] == 115 && this.data[ptr + 2] == 101 && this.data[ptr + 3] == 99 && this.data[ptr + 4] == 109 && this.data[ptr + 5] == 97 && this.data[ptr + 6] == 112) {
                            byte[] strBytes = new byte[20];
                            System.arraycopy(this.data, ptr - 19, strBytes, 0, 20);
                            String str = new String(strBytes);
                            EncodingUCS2 ucs2 = null;
                            if (str.startsWith("/Adobe-Korea1-UCS2")) {
                                ucs2 = new EncodingUCS2("Adobe-Korea1-UCS2");
                            } else if (str.startsWith("/Adobe-Japan1-UCS2")) {
                                ucs2 = new EncodingUCS2("Adobe-Japan1-UCS2");
                            } else if (str.startsWith("/Adobe-CNS1-UCS2")) {
                                ucs2 = new EncodingUCS2("Adobe-CNS1-UCS2");
                            } else if (str.startsWith("/Adobe-GB1-UCS2")) {
                                ucs2 = new EncodingUCS2("Adobe-GB1-UCS2");
                            }
                            if (ucs2 != null) {
                                for (int i = 0; i < 65535; ++i) {
                                    unicodeMappings[i] = String.valueOf((char)ucs2.getUnicodeValue(i));
                                }
                            }
                        }
                    }
                    ++ptr;
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception setting up text object " + e);
            }
        }
        return unicodeMappings;
    }

    private int readLineValue(String[] unicodeMappings, int type, int ptr) {
        int entryCount = type + 1;
        int[][] value = new int[2000][4];
        boolean isMultipleValues = false;
        for (int vals = 0; vals < entryCount; ++vals) {
            if (!isMultipleValues) {
                while (ptr < this.dataLen && this.data[ptr] != 60) {
                    if (vals == 2 && entryCount == 3 && this.data[ptr] == 91) {
                        type = 4;
                        int ii = ptr;
                        while (this.data[ii] != 93) {
                            if (this.data[ii] == 60) {
                                ++entryCount;
                            }
                            ++ii;
                        }
                        --entryCount;
                    }
                    ++ptr;
                }
                ++ptr;
            }
            int count = 0;
            int charsFound = 0;
            while (ptr < this.dataLen && this.data[ptr] != 62) {
                if (this.data[ptr] != 10 && this.data[ptr] != 13 && this.data[ptr] != 32) {
                    ++charsFound;
                }
                ++ptr;
                ++count;
                if (charsFound != 5 || type == 4) continue;
                count = 4;
                --ptr;
                ++entryCount;
                isMultipleValues = true;
                break;
            }
            int byteAccessed = 0;
            while (count > 0) {
                int nextVal;
                value[vals][byteAccessed] = nextVal = this.getNextVal(ptr, count);
                ++byteAccessed;
                count -= 4;
            }
        }
        while (ptr < this.dataLen && (this.data[ptr] == 62 || this.data[ptr] == 32 || this.data[ptr] == 10 || this.data[ptr] == 13 || this.data[ptr] == 93)) {
            ++ptr;
        }
        this.fillValues(unicodeMappings, entryCount, value, type);
        return --ptr;
    }

    private int getNextVal(int ptr, int count) {
        int disp = 0;
        if (count > 4) {
            count = 4;
            disp = 4;
        }
        int pos = 0;
        int nextVal = 0;
        for (int jj = 0; jj < count; ++jj) {
            int raw;
            while ((raw = this.data[ptr - 1 - jj - disp]) == 10 || raw == 13 || raw == 32) {
                ++jj;
            }
            if (raw >= 65 && raw <= 70) {
                raw -= 55;
            } else if (raw >= 97 && raw <= 102) {
                raw -= 87;
            } else if (raw >= 48 && raw <= 57) {
                raw -= 48;
            } else {
                throw new RuntimeException("Unexpected number " + (char)raw);
            }
            nextVal += raw * powers[pos];
            ++pos;
        }
        return nextVal;
    }

    private void fillValues(String[] unicodeMappings, int entryCount, int[][] value, int type) {
        switch (type) {
            case 1: {
                if (value[0][0] > 255) {
                    this.hasDoubleBytes = true;
                }
                char[] str = new char[entryCount - 1];
                for (int aa = 0; aa < entryCount - 1; ++aa) {
                    str[aa] = (char)value[1 + aa][0];
                }
                unicodeMappings[value[0][0]] = new String(str);
                break;
            }
            case 2: {
                for (int i = value[0][0]; i < value[1][0] + 1; ++i) {
                    int disp;
                    int val;
                    if (i > 255) {
                        this.hasDoubleBytes = true;
                    }
                    if ((val = value[2][0] + (disp = i - value[0][0])) <= 0) continue;
                    if (unicodeMappings[i] == null) {
                        unicodeMappings[i] = String.valueOf((char)val);
                        continue;
                    }
                    int n = i;
                    unicodeMappings[n] = unicodeMappings[n] + String.valueOf((char)val);
                }
                break;
            }
            case 4: {
                int j = 2;
                for (int i = value[0][0]; i < value[1][0] + 1; ++i) {
                    if (i > 255) {
                        this.hasDoubleBytes = true;
                    }
                    if (value[0][0] == value[1][0]) {
                        UnicodeReader.setValue(i, 2, value, unicodeMappings);
                    } else {
                        UnicodeReader.setValue(i, j, value, unicodeMappings);
                    }
                    ++j;
                }
                break;
            }
        }
    }

    private static void setValue(int i, int j, int[][] value, String[] unicodeMappings) {
        for (int jj = 0; jj < 4; ++jj) {
            int val = value[j][jj];
            if (val <= 0) continue;
            if (unicodeMappings[i] == null) {
                unicodeMappings[i] = String.valueOf((char)val);
                continue;
            }
            int n = i;
            unicodeMappings[n] = unicodeMappings[n] + String.valueOf((char)val);
        }
    }

    public boolean hasDoubleByteValues() {
        return this.hasDoubleBytes;
    }
}

