/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class DeviceRGBColorSpace
extends GenericColorSpace {
    public DeviceRGBColorSpace(boolean isARGB) {
        this.setType(1785221209);
        if (isARGB) {
            this.componentCount = 4;
        }
    }

    public DeviceRGBColorSpace() {
        this.setType(1785221209);
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        if (length == 1) {
            if (this.IndexedColorMap == null) {
                float val = operand[0];
                this.currentColor = new PdfColor(val, val, val);
            } else {
                int[] val = new int[3];
                int id = (int)(operand[0] * 3.0f);
                for (int i = 0; i < 3; ++i) {
                    int value;
                    val[i] = value = this.getIndexedColorComponent(id + i);
                }
                this.currentColor = new PdfColor(val[0], val[1], val[2]);
            }
        } else if (length > 2) {
            float[] val = new float[3];
            for (int i = 0; i < 3; ++i) {
                val[i] = operand[i];
                if (val[i] < 0.0f) {
                    val[i] = 0.0f;
                }
                if (!(val[i] > 1.0f)) continue;
                val[i] = 1.0f;
            }
            this.currentColor = new PdfColor(val[0], val[1], val[2]);
        }
    }
}

