/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

public class CompositeUtil {
    public static float composite(float aS, float aB, float aR, float cS, float cB, float blendRes) {
        float ratioA = aS / aR;
        return (1.0f - ratioA) * cB + ratioA * ((1.0f - aB) * cS + aB * blendRes);
    }

    public static float blendMultiply(float cS, float cB) {
        return cB * cS;
    }

    public static float blendScreen(float cS, float cB) {
        return cB + cS - cB * cS;
    }

    public static float blendOverLay(float cS, float cB) {
        return CompositeUtil.blendHardLight(cB, cS);
    }

    public static float blendDarken(float cS, float cB) {
        return Math.min(cS, cB);
    }

    public static float blendLighten(float cS, float cB) {
        return Math.max(cS, cB);
    }

    public static float blendColorDodge(float cS, float cB) {
        if (cS == 1.0f) {
            return 1.0f;
        }
        return Math.min(1.0f, cB / (1.0f - cS));
    }

    public static float blendColorBurn(float cS, float cB) {
        if (cS == 0.0f) {
            return 0.0f;
        }
        return 1.0f - Math.min(1.0f, (1.0f - cB) / cS);
    }

    public static float blendHardLight(float cS, float cB) {
        if (cS <= 0.5f) {
            return CompositeUtil.blendMultiply(cB, 2.0f * cS);
        }
        return CompositeUtil.blendScreen(cB, 2.0f * cS - 1.0f);
    }

    public static float blendSoftLight(float cS, float cB) {
        if (cS <= 0.5f) {
            return cB - (1.0f - 2.0f * cS) * cB * (1.0f - cB);
        }
        return cB + (2.0f * cS - 1.0f) * (CompositeUtil.blendDX(cB) - cB);
    }

    private static float blendDX(float x) {
        if (x <= 0.25f) {
            return ((16.0f * x - 12.0f) * x + 4.0f) * x;
        }
        return (float)Math.sqrt(x);
    }

    public static float blendDifference(float cS, float cB) {
        return Math.abs(cB - cS);
    }

    public static float blendExclusion(float cS, float cB) {
        return cB + cS - 2.0f * cB * cS;
    }
}

