/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;

public class CalGrayColorSpace
extends GenericColorSpace {
    public CalGrayColorSpace(float[] whitepoint, float[] gamma) {
        this.componentCount = 1;
        this.setCIEValues(whitepoint, null, null, gamma);
        this.setType(391471749);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        byte[] newData = new byte[data.length * 3];
        int ptr = 0;
        for (byte aData : data) {
            newData[ptr++] = aData;
            newData[ptr++] = aData;
            newData[ptr++] = aData;
        }
        return newData;
    }

    @Override
    public final void setColor(String[] number_values, int opCount) {
        float[] colValues = new float[]{Float.parseFloat(number_values[0])};
        this.setColor(colValues, 1);
    }

    @Override
    public final void setColor(float[] number_values, int opCount) {
        float A = number_values[0];
        float AG = (float)Math.pow(A, this.G[0]);
        float lum = this.W[1] * AG;
        int val = (int)Math.max(295.8 * Math.pow(lum, 0.3333333333333333) - 40.8, 0.0);
        this.currentColor = new PdfColor(val, val, val);
    }
}

