/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class Shape67 {
    private final GeneralPath shape = new GeneralPath();
    final float minX;
    final float minY;
    final float maxX;
    final float maxY;
    private float[] triCoords;
    private int[] triColors;
    private int foundI;

    public Shape67(Point2D[] sp, Color[] colors, int nSteps) {
        this.shape.moveTo(sp[0].getX(), sp[0].getY());
        this.shape.curveTo(sp[1].getX(), sp[1].getY(), sp[2].getX(), sp[2].getY(), sp[3].getX(), sp[3].getY());
        this.shape.curveTo(sp[4].getX(), sp[4].getY(), sp[5].getX(), sp[5].getY(), sp[6].getX(), sp[6].getY());
        this.shape.curveTo(sp[7].getX(), sp[7].getY(), sp[8].getX(), sp[8].getY(), sp[9].getX(), sp[9].getY());
        this.shape.curveTo(sp[10].getX(), sp[10].getY(), sp[11].getX(), sp[11].getY(), sp[0].getX(), sp[0].getY());
        this.shape.closePath();
        Rectangle2D bounds = this.shape.getBounds2D();
        this.mapBilinear(sp, colors, nSteps);
        this.minY = (float)bounds.getMinY();
        this.minX = (float)bounds.getMinX();
        this.maxX = (float)bounds.getMaxX();
        this.maxY = (float)bounds.getMaxY();
    }

    private void mapBilinear(Point2D[] pointsArr, Color[] colors, int nSteps) {
        Point2D[] C1 = Shape67.curvePoints(pointsArr[0], pointsArr[11], pointsArr[10], pointsArr[9], nSteps);
        Point2D[] C2 = Shape67.curvePoints(pointsArr[3], pointsArr[4], pointsArr[5], pointsArr[6], nSteps);
        Point2D[] D1 = Shape67.curvePoints(pointsArr[0], pointsArr[1], pointsArr[2], pointsArr[3], nSteps);
        Point2D[] D2 = Shape67.curvePoints(pointsArr[9], pointsArr[8], pointsArr[7], pointsArr[6], nSteps);
        int szu = C1.length;
        int szv = D1.length;
        int uvDim = szv * szu;
        float[] xPoints = new float[uvDim];
        float[] yPoints = new float[uvDim];
        int[] cc = new int[uvDim];
        float stepV = 1.0f / (float)(szv - 1);
        float stepU = 1.0f / (float)(szu - 1);
        float v = -stepV;
        int[][] pointColors = new int[4][3];
        for (int i = 0; i < 4; ++i) {
            pointColors[i] = new int[]{colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()};
        }
        int p = 0;
        int[] temp = new int[3];
        for (int i = 0; i < szv; ++i) {
            float vMinus = 1.0f - (v += stepV);
            float u = -stepU;
            for (int j = 0; j < szu; ++j) {
                float uMinus = 1.0f - (u += stepU);
                float scx = (float)((double)vMinus * C1[j].getX() + (double)v * C2[j].getX());
                float scy = (float)((double)vMinus * C1[j].getY() + (double)v * C2[j].getY());
                float sdx = (float)((double)uMinus * D1[i].getX() + (double)u * D2[i].getX());
                float sdy = (float)((double)uMinus * D1[i].getY() + (double)u * D2[i].getY());
                float sbx = (float)((double)vMinus * ((double)uMinus * C1[0].getX() + (double)u * C1[C1.length - 1].getX()) + (double)v * ((double)uMinus * C2[0].getX() + (double)u * C2[C2.length - 1].getX()));
                float sby = (float)((double)vMinus * ((double)(1.0f - u) * C1[0].getY() + (double)u * C1[C1.length - 1].getY()) + (double)v * ((double)uMinus * C2[0].getY() + (double)u * C2[C2.length - 1].getY()));
                float sx = scx + sdx - sbx;
                float sy = scy + sdy - sby;
                xPoints[p] = sx;
                yPoints[p] = sy;
                for (int ci = 0; ci < 3; ++ci) {
                    temp[ci] = (int)(vMinus * (uMinus * (float)pointColors[0][ci] + u * (float)pointColors[3][ci]) + v * (uMinus * (float)pointColors[1][ci] + u * (float)pointColors[2][ci]));
                }
                cc[p] = temp[0] << 16 | temp[1] << 8 | temp[2];
                ++p;
            }
        }
        int d = szv - 1;
        this.triColors = new int[d * d * 6];
        this.triCoords = new float[d * d * 12];
        int tc = 0;
        int tp = 0;
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                int p1 = i * szv + j;
                int p2 = i * szv + j + 1;
                int p3 = (i + 1) * szv + j;
                int p4 = (i + 1) * szv + j + 1;
                this.triCoords[tp++] = xPoints[p1];
                this.triCoords[tp++] = yPoints[p1];
                this.triCoords[tp++] = xPoints[p2];
                this.triCoords[tp++] = yPoints[p2];
                this.triCoords[tp++] = xPoints[p3];
                this.triCoords[tp++] = yPoints[p3];
                this.triCoords[tp++] = xPoints[p2];
                this.triCoords[tp++] = yPoints[p2];
                this.triCoords[tp++] = xPoints[p4];
                this.triCoords[tp++] = yPoints[p4];
                this.triCoords[tp++] = xPoints[p3];
                this.triCoords[tp++] = yPoints[p3];
                this.triColors[tc++] = cc[p1];
                this.triColors[tc++] = cc[p2];
                this.triColors[tc++] = cc[p3];
                this.triColors[tc++] = cc[p2];
                this.triColors[tc++] = cc[p4];
                this.triColors[tc++] = cc[p3];
            }
        }
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    private static Point2D[] curvePoints(Point2D p1, Point2D p2, Point2D p3, Point2D p4, int nSteps) {
        Point2D[] arr = new Point2D[nSteps + 1];
        arr[0] = p1;
        for (int i = 1; i <= nSteps; ++i) {
            Point2D p;
            float t = 1.0f / (float)nSteps * (float)i;
            arr[i] = p = ShadingUtils.findDistancedPoint(t, p1, p2, p3, p4);
        }
        return arr;
    }

    public Color findPointColor(float x, float y) {
        int rec = this.triCoords.length / 6;
        int i = 0;
        if (this.foundI != 0 && Shape67.isPointInPoly(this.triCoords, x, y, this.foundI * 6)) {
            i = this.foundI;
        }
        while (i < rec) {
            int p = i * 6;
            float x1 = this.triCoords[p];
            float y1 = this.triCoords[p + 1];
            float x2 = this.triCoords[p + 2];
            float y2 = this.triCoords[p + 3];
            float x3 = this.triCoords[p + 4];
            float y3 = this.triCoords[p + 5];
            float d1 = x - x3;
            float d2 = x3 - x2;
            float d3 = x1 - x3;
            float d4 = y - y3;
            float d5 = y2 - y3;
            float d = d5 * d3 + d2 * (y1 - y3);
            if (d != 0.0f) {
                float w1 = (d5 * d1 + d2 * d4) / d;
                float w2 = ((y3 - y1) * d1 + d3 * d4) / d;
                float w3 = 1.0f - w1 - w2;
                if (!(w1 < 0.0f || w2 < 0.0f || w3 < 0.0f)) {
                    int ip = i * 3;
                    int c1 = this.triColors[ip];
                    int c2 = this.triColors[ip + 1];
                    int c3 = this.triColors[ip + 2];
                    int v1 = c1 >> 16 & 0xFF;
                    int v2 = c2 >> 16 & 0xFF;
                    int v3 = c3 >> 16 & 0xFF;
                    int red = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    v1 = c1 >> 8 & 0xFF;
                    v2 = c2 >> 8 & 0xFF;
                    v3 = c3 >> 8 & 0xFF;
                    int green = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    v1 = c1 & 0xFF;
                    v2 = c2 & 0xFF;
                    v3 = c3 & 0xFF;
                    int blue = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
                    this.foundI = i;
                    return new Color(red, green, blue);
                }
            }
            ++i;
        }
        this.foundI = 0;
        return null;
    }

    private static boolean isPointInPoly(float[] triCoords, float x, float y, int p) {
        float x1 = triCoords[p];
        float y1 = triCoords[p + 1];
        float x2 = triCoords[p + 2];
        float y2 = triCoords[p + 3];
        float x3 = triCoords[p + 4];
        float y3 = triCoords[p + 5];
        float d1 = x - x3;
        float d2 = x3 - x2;
        float d3 = x1 - x3;
        float d4 = y - y3;
        float d5 = y2 - y3;
        float d = d5 * d3 + d2 * (y1 - y3);
        if (d == 0.0f) {
            return false;
        }
        float w1 = (d5 * d1 + d2 * d4) / d;
        float w2 = ((y3 - y1) * d1 + d3 * d4) / d;
        float w3 = 1.0f - w1 - w2;
        return !(w1 < 0.0f || w2 < 0.0f || w3 < 0.0f);
    }
}

