/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.AxialShadeContext;
import com.idrsolutions.pdf.color.shading.CoonsContext;
import com.idrsolutions.pdf.color.shading.FreeFormShadeContext;
import com.idrsolutions.pdf.color.shading.FunctionShadeContext;
import com.idrsolutions.pdf.color.shading.LatticeFormShadeContext;
import com.idrsolutions.pdf.color.shading.RadialContext;
import com.idrsolutions.pdf.color.shading.Shape67;
import com.idrsolutions.pdf.color.shading.TensorContext;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class ShadedPaint
implements PdfPaint,
Serializable {
    private static final int FUNCTION = 1;
    private static final int AXIAL = 2;
    private static final int RADIAL = 3;
    private static final int FREEFORM = 4;
    private static final int LATTICEFORM = 5;
    private static final int COONS = 6;
    private static final int TENSOR = 7;
    private static final boolean debug = false;
    private PDFFunction[] function;
    private GenericColorSpace shadingColorSpace;
    private PdfObject Shading;
    private float[] coords;
    private int type;
    protected float scaling;
    protected int cropX;
    protected int textX;
    protected int textY;
    protected int cropH;
    private float[] background;
    private float[][] matrix;
    private float[][] gtm;
    private ArrayList<Shape67> shapesList = new ArrayList();

    public ShadedPaint(PdfObject Shading, GenericColorSpace shadingColorSpace, PdfObjectReader currentPdfFile, float[][] matrix) {
        this.type = Shading.getInt(1487255197);
        this.matrix = matrix;
        this.shadingColorSpace = shadingColorSpace;
        this.Shading = Shading;
        this.background = Shading.getFloatArray(1921025959);
        PdfArrayIterator keys = Shading.getMixedArray(1518239089);
        int functionCount = keys.getTokenCount();
        if (functionCount > 0) {
            PdfObject[] subFunction = new PdfObject[functionCount];
            for (int i = 0; i < functionCount; ++i) {
                byte[] nextValue = keys.getNextValueAsByte(true);
                subFunction[i] = ColorspaceFactory.getFunctionObjectFromRefOrDirect(currentPdfFile, nextValue);
            }
            this.function = new PDFFunction[subFunction.length];
            int imax = subFunction.length;
            for (int i1 = 0; i1 < imax; ++i1) {
                this.function[i1] = FunctionFactory.getFunction(subFunction[i1], currentPdfFile);
            }
        }
    }

    protected ShadedPaint() {
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        PaintContext pt = null;
        switch (this.type) {
            case 1: {
                pt = new FunctionShadeContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.gtm, this.function);
                break;
            }
            case 2: {
                pt = new AxialShadeContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.gtm, this.function);
                break;
            }
            case 3: {
                pt = new RadialContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function);
                break;
            }
            case 4: {
                pt = new FreeFormShadeContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.gtm, this.function);
                break;
            }
            case 5: {
                pt = new LatticeFormShadeContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.gtm, this.function);
                break;
            }
            case 6: {
                if (!this.shapesList.isEmpty()) {
                    pt = new CoonsContext(xform, this.shadingColorSpace, this.shapesList, this.background, this.matrix, this.function);
                    break;
                }
                CoonsContext ct = new CoonsContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function);
                this.shapesList = ct.getShapes();
                pt = ct;
                break;
            }
            case 7: {
                if (!this.shapesList.isEmpty()) {
                    pt = new TensorContext(xform, this.shadingColorSpace, this.shapesList, this.background, this.matrix, this.function);
                    break;
                }
                TensorContext tt = new TensorContext(xform, this.shadingColorSpace, this.background, this.Shading, this.matrix, this.function);
                this.shapesList = tt.getShapes();
                pt = tt;
            }
        }
        return pt;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public void setScaling(double cropX, double cropH, float scaling, float textX, float textY) {
        this.scaling = scaling;
        this.cropX = (int)cropX;
        this.cropH = (int)cropH;
        this.textX = (int)textX;
        this.textY = (int)textY;
    }

    @Override
    public boolean isPattern() {
        return true;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public boolean isTexture() {
        return false;
    }

    @Override
    public void setGlyphMatrix(float[][] gtm) {
        this.gtm = gtm;
    }
}

