/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class FunctionShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final PDFFunction[] function;
    private final float[] background;
    private float[] domain = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
    private final float[][] toUserSpace;
    private final float[][] toShadeSpace;

    FunctionShadeContext(AffineTransform xform, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, float[][] gm, PDFFunction[] function) {
        float[] inputs;
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        float[] newDomain = shadingObject.getFloatArray(1026641277);
        if (newDomain != null) {
            this.domain = newDomain;
        }
        this.background = background;
        Object caller = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[][] shadeMatrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        if (mm != null) {
            caller = mm;
        }
        if ((inputs = shadingObject.getFloatArray(1145198201)) != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        Object xformMatrix = new float[][]{{(float)xform.getScaleX(), (float)xform.getShearX(), 0.0f}, {(float)xform.getShearY(), (float)xform.getScaleY(), 0.0f}, {(float)xform.getTranslateX(), (float)xform.getTranslateY(), 1.0f}};
        if (gm != null) {
            float[][] g100 = new float[][]{{gm[0][0] / 100.0f, gm[0][1] / 100.0f, 0.0f}, {gm[1][0] / 100.0f, gm[1][1] / 100.0f, 0.0f}, {gm[2][0], gm[2][1], 1.0f}};
            xformMatrix = Matrix.concatenate(xformMatrix, Matrix.inverse(g100));
        }
        this.toUserSpace = Matrix.inverse(xformMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        float d0 = this.domain[0];
        float d1 = this.domain[1];
        float d2 = this.domain[2];
        float d3 = this.domain[3];
        float[] src = new float[2];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                src[0] = startX + j;
                src[1] = startY + i;
                src = Matrix.transformPoint(this.toUserSpace, src[0], src[1]);
                src = Matrix.transformPoint(this.toShadeSpace, src[0], src[1]);
                float x = src[0];
                float y = src[1];
                if (x < d0 || x > d1 || y < d2 || y > d3) continue;
                data[i * w + j] = 0xFF000000 | this.calculateColor(src);
            }
        }
        return raster;
    }

    private int calculateColor(float[] val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, val);
        this.shadingColorSpace.setColor(colValues, colValues.length);
        return this.shadingColorSpace.getColor().getRGB();
    }
}

