/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class AxialShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final PDFFunction[] function;
    private final float[] background;
    private final boolean hasLeftExt;
    private final boolean hasRightExt;
    private final float t0;
    private final float t1;
    private final float x0;
    private final float y0;
    private final float deltaX;
    private final float deltaY;
    private final float multiXY;
    private Rectangle2D bboxRect;
    private final float[][] toUserSpace;
    private final float[][] toShadeSpace;

    AxialShadeContext(AffineTransform xform, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, float[][] gm, PDFFunction[] function) {
        float[] inputs;
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        float[] newDomain = shadingObject.getFloatArray(1026641277);
        float[] domain = new float[]{0.0f, 1.0f};
        if (newDomain != null) {
            domain = newDomain;
        }
        this.background = background;
        boolean[] extension = shadingObject.getBooleanArray(1144345468);
        if (extension == null) {
            extension = new boolean[]{false, false};
        }
        this.hasLeftExt = extension[0];
        this.hasRightExt = extension[1];
        this.t0 = domain[0];
        this.t1 = domain[1];
        float[] bbox = shadingObject.getFloatArray(303185736);
        if (bbox != null) {
            GeneralPath gp = new GeneralPath();
            gp.moveTo(bbox[0], bbox[1]);
            gp.lineTo(bbox[2], bbox[1]);
            gp.lineTo(bbox[2], bbox[3]);
            gp.lineTo(bbox[0], bbox[3]);
            gp.lineTo(bbox[0], bbox[1]);
            gp.closePath();
            this.bboxRect = gp.getBounds2D();
        }
        Object caller = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        float[][] shadeMatrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        if (mm != null) {
            caller = mm;
        }
        if ((inputs = shadingObject.getFloatArray(1145198201)) != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        Object xformMatrix = new float[][]{{(float)xform.getScaleX(), (float)xform.getShearX(), 0.0f}, {(float)xform.getShearY(), (float)xform.getScaleY(), 0.0f}, {(float)xform.getTranslateX(), (float)xform.getTranslateY(), 1.0f}};
        if (gm != null) {
            xformMatrix = Matrix.concatenate(xformMatrix, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xformMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        float[] coords = shadingObject.getFloatArray(1061308290);
        this.x0 = coords[0];
        this.y0 = coords[1];
        float x1 = coords[2];
        float y1 = coords[3];
        this.deltaX = x1 - this.x0;
        this.deltaY = y1 - this.y0;
        this.multiXY = this.deltaX * this.deltaX + this.deltaY * this.deltaY;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w, h, data, this.shadingColorSpace, this.background);
        }
        float[] src = new float[2];
        float[] tv = new float[1];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                boolean render = true;
                src[0] = startX + j;
                src[1] = startY + i;
                Matrix.transformPixel(this.toUserSpace, src);
                Matrix.transformPixel(this.toShadeSpace, src);
                float x = src[0];
                float y = src[1];
                float t = 0.0f;
                float xp = (this.deltaX * (x - this.x0) + this.deltaY * (y - this.y0)) / this.multiXY;
                if (xp >= 0.0f && xp <= 1.0f) {
                    t = this.t0 + (this.t1 - this.t0) * xp;
                } else if (xp < 0.0f && this.hasLeftExt) {
                    t = this.t0;
                } else if (xp > 1.0f && this.hasRightExt) {
                    t = this.t1;
                } else {
                    render = false;
                }
                if (this.bboxRect != null && render) {
                    render = this.bboxRect.contains(x, y);
                }
                if (!render) continue;
                tv[0] = t;
                data[i * w + j] = 0xFF000000 | this.calculateColor(tv);
            }
        }
        return raster;
    }

    private int calculateColor(float[] val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, val);
        this.shadingColorSpace.setColor(colValues, colValues.length);
        return this.shadingColorSpace.getColor().getRGB();
    }
}

