/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.shadings;

import com.idrsolutions.pdf.acroforms.xfa.shadings.XFAShadeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.PdfPaint;

class RadialShadeContext
extends XFAShadeContext {
    private final int direction;

    RadialShadeContext(float[] coords, int direction, PdfPaint startColor, PdfPaint endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.coords = coords;
        this.direction = direction;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        double width = (this.coords[2] - this.coords[0]) * this.scaling;
        double height = (this.coords[3] - this.coords[1]) * this.scaling;
        double radius = width > height ? width : height;
        radius /= 2.0;
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int[] fCol = this.interpolate(x + xstart, y + ystart, radius, width, height);
                data[pos++] = 0xFF000000 | fCol[0] << 16 | fCol[1] << 8 | fCol[2];
            }
        }
        return raster;
    }

    private int[] interpolate(int x, int y, double radius, double width, double height) {
        int startCol = this.startColor.getRGB();
        int endCol = this.endColor.getRGB();
        if (this.direction == -1) {
            int temp = startCol;
            startCol = endCol;
            endCol = temp;
        }
        int sr = startCol >> 16 & 0xFF;
        int sg = startCol >> 8 & 0xFF;
        int sb = startCol & 0xFF;
        int er = endCol >> 16 & 0xFF;
        int eg = endCol >> 8 & 0xFF;
        int eb = endCol & 0xFF;
        x = (int)((float)x - (this.coords[0] * this.scaling + (float)this.offX));
        y = (int)((float)y - ((float)this.pHeight - this.coords[3] * this.scaling + (float)this.offY));
        double pRadius = Math.sqrt(Math.pow(width / 2.0 - (double)x, 2.0) + Math.pow(height / 2.0 - (double)y, 2.0));
        if (pRadius == 0.0) {
            pRadius = 1.0;
        }
        double endVal = pRadius / radius;
        double startVal = 1.0 - endVal;
        if (endVal > 1.0) {
            endVal = 1.0;
            startVal = 0.0;
        }
        int fr = (int)((double)sr * startVal + (double)er * endVal);
        int fg = (int)((double)sg * startVal + (double)eg * endVal);
        int fb = (int)((double)sb * startVal + (double)eb * endVal);
        return new int[]{fr, fg, fb};
    }
}

