/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFADataMapping;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import com.idrsolutions.pdf.acroforms.xfa.XOccur;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XQuery {
    public static final String FIELD_STRING = "field";
    public static final String EXCLGROUP_STRING = "exclGroup";
    public static final String DRAW_STRING = "draw";
    public static final String SUBFORM_STRING = "subform";
    public static final String SUBFORMSET_STRING = "subformSet";
    public static final String PROTO_STRING = "proto";
    public static final String EVENT_STRING = "event";
    public static final String XMLNS_String = "xmlns";
    public static final String TEXT_STIRNG = "text";
    public static final String VARIABLES_STRING = "variables";
    private static final String CAPTION_STRING = "caption";
    public static final String NODATABIND = "NoDataBind";
    public static final String JPEDALTHISDATA = "jpedalThisData";
    public static final String JSOMBIND = "jSomBind";
    public static final String JSOMSINGLE = "jSomSingle";
    public static final String JDOMBIND = "jDomBind";
    public static final String JDYNAMIC = "jDynamic";
    public static final String JRENAME = "className";

    public static List<Node> findAllFieldsAndDraws(Document root) {
        int i;
        ArrayList<Node> full = new ArrayList<Node>();
        NodeList temp = root.getElementsByTagName(FIELD_STRING);
        for (i = 0; i < temp.getLength(); ++i) {
            full.add(temp.item(i));
        }
        temp = root.getElementsByTagName(DRAW_STRING);
        for (i = 0; i < temp.getLength(); ++i) {
            full.add(temp.item(i));
        }
        return full;
    }

    public static Node findNodeWithAttrAndValue(Document root, String attrName, String attrValue) {
        NodeList nodeList = root.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !((Element)node).getAttribute(attrName).equals(attrValue)) continue;
            return node;
        }
        return null;
    }

    public static NodeList findAllSubforms(Document root) {
        return root.getElementsByTagName(SUBFORM_STRING);
    }

    public static NodeList findAllExclGroups(Document root) {
        return root.getElementsByTagName(EXCLGROUP_STRING);
    }

    public static NodeList findAllFields(Document root) {
        return root.getElementsByTagName(FIELD_STRING);
    }

    public static NodeList findAllDraws(Document root) {
        return root.getElementsByTagName(DRAW_STRING);
    }

    public static NodeList findAllCaptions(Document root) {
        return root.getElementsByTagName(CAPTION_STRING);
    }

    public static List<Node> findDrawsContainsHTML(Document root) {
        ArrayList<Node> results = new ArrayList<Node>();
        NodeList drawList = root.getElementsByTagName(DRAW_STRING);
        int size = drawList.getLength();
        for (int i = 0; i < size; ++i) {
            boolean hasFound = false;
            Element draw = (Element)drawList.item(i);
            NodeList exDataList = draw.getElementsByTagName("exData");
            int exSize = exDataList.getLength();
            for (int j = 0; j < exSize; ++j) {
                Node exNode = exDataList.item(j);
                if (!((Element)exNode).getAttribute("contentType").contains("html")) continue;
                hasFound = true;
                break;
            }
            if (!hasFound) continue;
            results.add(draw);
        }
        return results;
    }

    public static List<Node> findDrawsContainsNormal(Document root) {
        ArrayList<Node> results = new ArrayList<Node>();
        NodeList drawList = root.getElementsByTagName(DRAW_STRING);
        int size = drawList.getLength();
        for (int i = 0; i < size; ++i) {
            boolean hasFound = false;
            Element draw = (Element)drawList.item(i);
            NodeList exDataList = draw.getElementsByTagName("exData");
            int exSize = exDataList.getLength();
            for (int j = 0; j < exSize; ++j) {
                Node exNode = exDataList.item(j);
                if (!((Element)exNode).getAttribute("contentType").contains("html")) continue;
                hasFound = true;
                break;
            }
            if (hasFound) continue;
            results.add(draw);
        }
        return results;
    }

    public static void cloneFormsBasedOnOccurence(Document template) {
        NodeList formList = XQuery.findAllSubforms(template);
        for (int i = 0; i < formList.getLength(); ++i) {
            Node formNode = formList.item(i);
            XOccur occur = new XOccur(formNode);
            int cloneCount = 1;
            if (occur.getMin() > 1 || occur.getInitial() > 1) {
                cloneCount = Math.max(occur.getMin(), occur.getInitial());
            }
            for (int z = 1; z < cloneCount; ++z) {
                Node clone = formNode.cloneNode(true);
                if (occur.isDynamic()) {
                    Element cloneEle = (Element)clone;
                    cloneEle.setAttribute(JDYNAMIC, "c");
                }
                XFAFormStream.insertAfterCurrent(clone, formNode);
            }
            if (!occur.isDynamic()) continue;
            Element cloneEle = (Element)formNode;
            cloneEle.setAttribute(JDYNAMIC, "p");
        }
    }

    public static void datasetToSomBindZeroOmit(Node parse, ArrayList<Node> nodeList) {
        if (parse.getNodeType() == 1) {
            HashMap<String, Integer> childNameMap = new HashMap<String, Integer>();
            for (int i = 0; i < parse.getChildNodes().getLength(); ++i) {
                Node node = parse.getChildNodes().item(i);
                String name = node.getNodeName();
                if (childNameMap.containsKey(name)) {
                    childNameMap.put(name, (Integer)childNameMap.get(name) + 1);
                    continue;
                }
                childNameMap.put(name, 1);
            }
            for (String key : childNameMap.keySet()) {
                Element ele = (Element)parse;
                if ((Integer)childNameMap.get(key) == 1) {
                    Element nodeEle = (Element)ele.getElementsByTagName(key).item(0);
                    if (nodeEle == null) continue;
                    nodeEle.setAttribute(JSOMBIND, XQuery.getDatasetSomName(nodeEle));
                    continue;
                }
                for (int z = 0; z < (Integer)childNameMap.get(key); ++z) {
                    Element nodeEle = (Element)ele.getElementsByTagName(key).item(z);
                    if (nodeEle == null) continue;
                    nodeEle.setAttribute(JSOMBIND, XQuery.getDatasetSomName(nodeEle) + "[" + z + "]");
                }
            }
        }
        nodeList.add(parse);
        NodeList setOfNodes = parse.getChildNodes();
        for (int i = 0; i < setOfNodes.getLength(); ++i) {
            XQuery.datasetToSomBindZeroOmit(setOfNodes.item(i), nodeList);
        }
    }

    public static void datasetToSomBind(Node parse, ArrayList<Node> nodeList) {
        if (parse.getNodeType() == 1 && !parse.getNodeName().equals("xfa:datasets")) {
            HashMap<String, Integer> childNameMap = new HashMap<String, Integer>();
            for (int i = 0; i < parse.getChildNodes().getLength(); ++i) {
                Node node = parse.getChildNodes().item(i);
                String name = node.getNodeName();
                if (childNameMap.containsKey(name)) {
                    childNameMap.put(name, (Integer)childNameMap.get(name) + 1);
                    continue;
                }
                childNameMap.put(name, 1);
            }
            for (String key : childNameMap.keySet()) {
                Element ele = (Element)parse;
                for (int z = 0; z < (Integer)childNameMap.get(key); ++z) {
                    Element nodeEle = (Element)ele.getElementsByTagName(key).item(z);
                    if (nodeEle == null) continue;
                    nodeEle.setAttribute(JSOMBIND, XQuery.getDatasetSomName(nodeEle) + "[" + z + "]");
                }
            }
        }
        nodeList.add(parse);
        NodeList setOfNodes = parse.getChildNodes();
        for (int i = 0; i < setOfNodes.getLength(); ++i) {
            XQuery.datasetToSomBind(setOfNodes.item(i), nodeList);
        }
    }

    public static void fillSOM(Document template, NodeList nodeList, int nodeType) {
        String nodeTypeName = null;
        switch (nodeType) {
            case 97427706: {
                nodeTypeName = FIELD_STRING;
                break;
            }
            case 1644111747: {
                nodeTypeName = EXCLGROUP_STRING;
                break;
            }
            case -1867994364: {
                nodeTypeName = SUBFORM_STRING;
                break;
            }
            case 471239358: {
                nodeTypeName = SUBFORMSET_STRING;
            }
        }
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node typeNode = nodeList.item(i);
            Element typeEle = (Element)typeNode;
            typeEle.setAttribute("jName", "NoDataBind-" + nodeTypeName + "-" + i);
            String nameAttrValue = typeEle.getAttribute("name");
            if (nameAttrValue.isEmpty()) continue;
            typeEle.setAttribute("jName", XQuery.getSomBindName(typeNode));
        }
    }

    public static String getDatasetSomName(Node node) {
        Node somAtr;
        String fullBind = "";
        Node iter = node.getParentNode();
        if (iter.hasAttributes() && (somAtr = iter.getAttributes().getNamedItem(JSOMBIND)) != null) {
            fullBind = somAtr.getNodeValue() + "." + fullBind;
        }
        fullBind = fullBind.startsWith(".") ? fullBind.substring(1) : fullBind;
        return fullBind + node.getNodeName();
    }

    private static void generateTempSom(Document tempDocument) {
        NodeList sList = tempDocument.getElementsByTagName(SUBFORM_STRING);
        int ii = sList.getLength();
        for (int i = 0; i < ii; ++i) {
            Element sf = (Element)sList.item(i);
            XQuery.recursiveNaming(sf);
        }
    }

    private static void recursiveNaming(Element e) {
        Node p = e.getParentNode();
        if (p != null && e.getAttribute(JSOMBIND).isEmpty()) {
            int c;
            Element pce;
            Node pc;
            int i;
            ArrayList<Element> nameNodes;
            String name = e.getAttribute("name");
            String cName = e.getNodeName();
            if (!name.isEmpty()) {
                e.setAttribute(JSOMSINGLE, name);
                nameNodes = new ArrayList<Element>();
                int ii = p.getChildNodes().getLength();
                for (i = 0; i < ii; ++i) {
                    pc = p.getChildNodes().item(i);
                    if (pc.getNodeType() != 1 || !(pce = (Element)pc).getAttribute("name").equals(name)) continue;
                    nameNodes.add(pce);
                }
                c = 0;
                for (Element iter : nameNodes) {
                    if (iter.isSameNode(e)) {
                        if (c == 0) {
                            e.setAttribute(JSOMBIND, name);
                        } else {
                            e.setAttribute(JSOMBIND, name + "[" + c + "]");
                        }
                        break;
                    }
                    ++c;
                }
            } else {
                e.setAttribute(JSOMSINGLE, cName);
                nameNodes = new ArrayList();
                int ii = p.getChildNodes().getLength();
                for (i = 0; i < ii; ++i) {
                    pc = p.getChildNodes().item(i);
                    if (pc.getNodeType() != 1 || !(pce = (Element)pc).getNodeName().equals(cName)) continue;
                    nameNodes.add(pce);
                }
                c = 0;
                for (Element iter : nameNodes) {
                    if (iter.isSameNode(e)) {
                        if (c == 0) {
                            e.setAttribute(JSOMBIND, cName);
                        } else {
                            e.setAttribute(JSOMBIND, cName + "[" + c + "]");
                        }
                        break;
                    }
                    ++c;
                }
            }
        }
        int ii = e.getChildNodes().getLength();
        for (int i = 0; i < ii; ++i) {
            Node ec = e.getChildNodes().item(i);
            if (ec.getNodeType() != 1) continue;
            XQuery.recursiveNaming((Element)ec);
        }
    }

    public static void combineDataWithTemp(Document tempDocument, Document dataDocument) {
        NodeList formList = XQuery.findAllSubforms(tempDocument);
        NodeList exGroupList = XQuery.findAllExclGroups(tempDocument);
        NodeList fieldList = XQuery.findAllFields(tempDocument);
        ArrayList<Node> tempForms = new ArrayList<Node>();
        int ii = formList.getLength();
        for (int i = 0; i < ii; ++i) {
            tempForms.add(formList.item(i));
        }
        for (Node tempForm : tempForms) {
            XOccur occur = new XOccur(tempForm);
            if (!occur.isDynamic() || occur.getMin() <= 1) continue;
            int diff = occur.getMin() - 1;
            for (int i = 0; i < diff; ++i) {
                Element clone = (Element)tempForm.cloneNode(true);
                XFAFormStream.insertAfterCurrent(clone, tempForm);
            }
        }
        if (dataDocument != null) {
            XFADataMapping.doStandardMapping(dataDocument.getDocumentElement(), tempDocument.getDocumentElement());
            XFADataMapping.doRecordRefMapping(dataDocument.getDocumentElement(), tempDocument.getDocumentElement());
            XFADataMapping.doGlobalMapping(dataDocument.getDocumentElement(), tempDocument.getDocumentElement());
        }
        for (Node tempForm : tempForms) {
            Element tempFormEle = (Element)tempForm;
            XOccur occur = new XOccur(tempForm);
            if (!occur.isDynamic() || occur.getMin() != 0 || tempFormEle.getAttribute("mapped").equals("mapped")) continue;
            tempFormEle.setAttribute("presence", "hidden");
        }
        XQuery.generateTempSom(tempDocument);
        XQuery.fillSOM(tempDocument, formList, -1867994364);
        XQuery.fillSOM(tempDocument, tempDocument.getElementsByTagName(SUBFORMSET_STRING), 471239358);
        XQuery.fillSOM(tempDocument, exGroupList, 1644111747);
        XQuery.fillSOM(tempDocument, fieldList, 97427706);
    }

    public static void printXML(Document xmlDocument) {
        try {
            TransformerFactory tf = SecureTransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(new OutputStreamWriter((OutputStream)System.out, "UTF-8")));
        }
        catch (Exception e) {
            System.err.println("XML printing error");
        }
    }

    public static void printXMLtoFile(Document xmlDocument, File file) {
        try {
            TransformerFactory tf = SecureTransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StreamResult result = new StreamResult(file);
            transformer.transform(new DOMSource(xmlDocument), result);
        }
        catch (Exception e) {
            System.err.println("XML printing error");
        }
    }

    public static void printNodeList(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            System.out.println(nodeList.item(i).getNodeName());
            for (int j = 0; j < nodeList.item(i).getChildNodes().getLength(); ++j) {
                Node node = nodeList.item(i).getChildNodes().item(j);
                if (node.getNodeType() != 1) continue;
                System.out.println(node.getNamespaceURI());
                System.out.println("\t" + node.getNodeName() + " : " + node.getTextContent());
            }
        }
    }

    public static String getDataBindName(Node node) {
        StringBuilder sb = new StringBuilder();
        for (Node iter = node; iter != null; iter = iter.getParentNode()) {
            XOccur occur;
            Node somAtr;
            if (!iter.hasAttributes() || iter.getNodeName().equals(SUBFORMSET_STRING) || (somAtr = iter.getAttributes().getNamedItem(JSOMBIND)) == null || (occur = new XOccur(iter)).getDataBindMatch().hashCode() == 3387192) continue;
            String somValue = somAtr.getNodeValue();
            String refName = occur.getRefBindName();
            if (refName != null) {
                String suffix = somValue.endsWith("]") ? somValue.substring(somValue.lastIndexOf(91)) : "";
                somValue = refName + suffix;
            }
            if (sb.length() == 0) {
                sb.append(somValue);
                continue;
            }
            sb.insert(0, somValue + ".");
        }
        return sb.toString();
    }

    public static String getSomBindName(Node node) {
        StringBuilder sb = new StringBuilder();
        for (Node iter = node; iter != null && iter.getNodeType() == 1; iter = iter.getParentNode()) {
            Element iterEle = (Element)iter;
            String somName = iterEle.getAttribute(JSOMBIND);
            if (somName.isEmpty()) continue;
            if (sb.length() == 0) {
                sb.append(somName);
                continue;
            }
            sb.insert(0, somName + ".");
        }
        return sb.toString();
    }
}

