/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XBox;
import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import com.idrsolutions.pdf.acroforms.xfa.XOccur;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XFADataMapping {
    public static final String MAPPED = "mapped";

    XFADataMapping() {
    }

    public static void doStandardMapping(Element dom, Element som) {
        LinkedHashMap dHold = new LinkedHashMap();
        NodeList dList = dom.getChildNodes();
        int ii = dList.getLength();
        for (int i = 0; i < ii; ++i) {
            List<Element> temp;
            Node it = dList.item(i);
            if (it.getNodeType() != 1) continue;
            Element itEle = (Element)it;
            String name = it.getNodeName().trim();
            if (name.isEmpty()) continue;
            if (dHold.containsKey(name)) {
                temp = (List)dHold.get(name);
                temp.add(itEle);
                continue;
            }
            temp = new ArrayList();
            temp.add(itEle);
            dHold.put(name, temp);
        }
        for (String dn : dHold.keySet()) {
            ArrayList<Element> arr = new ArrayList<Element>();
            List dnList = (List)dHold.get(dn);
            int dLen = dnList.size();
            if (dLen == 1) {
                XFADataMapping.findDomDownSingle(som, dn, arr);
                Element toLook = (Element)dnList.get(0);
                if (!arr.isEmpty()) {
                    Element found = (Element)arr.get(0);
                    toLook.setAttribute(MAPPED, MAPPED);
                    if (XFADataMapping.isDataValue(toLook)) {
                        if (!XFADataMapping.isField(found) && !XFADataMapping.isExclGroup(found)) continue;
                        XBox.addCustomData(found, toLook.getTextContent());
                        continue;
                    }
                    found.setAttribute(MAPPED, MAPPED);
                    XFADataMapping.doStandardMapping(toLook, found);
                    continue;
                }
                XFADataMapping.doStandardMapping(toLook, som);
                continue;
            }
            if (dLen > 1 && XFADataMapping.isDataValue((Element)dnList.get(0))) {
                XFADataMapping.findDomDownMulti(som, dn, arr);
                int ii2 = Math.min(arr.size(), dnList.size());
                for (int i = 0; i < ii2; ++i) {
                    Element found = (Element)arr.get(i);
                    if (!XFADataMapping.isField(found) && !XFADataMapping.isExclGroup(found)) continue;
                    XBox.addCustomData(found, ((Element)dnList.get(i)).getTextContent());
                }
                continue;
            }
            XFADataMapping.findDomDownMulti(som, dn, arr);
            int formLen = arr.size();
            if (formLen > 0) {
                if (dLen <= formLen) {
                    for (int i = 0; i < dLen; ++i) {
                        ((Element)dnList.get(i)).setAttribute(MAPPED, MAPPED);
                        ((Element)arr.get(i)).setAttribute(MAPPED, MAPPED);
                        XFADataMapping.doStandardMapping((Element)dnList.get(i), (Element)arr.get(i));
                    }
                    continue;
                }
                int diff = dLen - formLen;
                Element zeroForm = (Element)arr.get(0);
                if (XFADataMapping.isForm(zeroForm)) {
                    XOccur occur = new XOccur(zeroForm);
                    if (occur.isDynamic()) {
                        for (int i = 0; i < diff; ++i) {
                            Node clone = zeroForm.cloneNode(true);
                            XFAFormStream.insertAfterCurrent(clone, zeroForm);
                        }
                    }
                    arr.clear();
                    XFADataMapping.findDomDownMulti(som, dn, arr);
                    int mm = Math.min(arr.size(), dnList.size());
                    for (int i = 0; i < mm; ++i) {
                        ((Element)dnList.get(i)).setAttribute(MAPPED, MAPPED);
                        ((Element)arr.get(i)).setAttribute(MAPPED, MAPPED);
                        XFADataMapping.doStandardMapping((Element)dnList.get(i), (Element)arr.get(i));
                    }
                    continue;
                }
                for (int i = 0; i < formLen; ++i) {
                    ((Element)dnList.get(i)).setAttribute(MAPPED, MAPPED);
                    XFADataMapping.doStandardMapping((Element)dnList.get(i), (Element)arr.get(i));
                }
                continue;
            }
            for (Element aDnList : dnList) {
                XFADataMapping.doStandardMapping(aDnList, som);
            }
        }
    }

    public static void doRecordRefMapping(Element dom, Element som) {
        NodeList sList = som.getChildNodes();
        int ii = sList.getLength();
        block0: for (int i = 0; i < ii; ++i) {
            Node it = sList.item(i);
            if (it.getNodeType() != 1) continue;
            Element itEle = (Element)it;
            if (XFADataMapping.isDataRef(itEle)) {
                XOccur occur = new XOccur(itEle);
                String bindName = occur.getRefBindName();
                Element searchingDom = dom;
                if (bindName.contains(".") && (XFADataMapping.isField(itEle) || XFADataMapping.isExclGroup(itEle))) {
                    String[] bindArr = bindName.split("\\.");
                    boolean canLoop = true;
                    block1: for (String bn : bindArr) {
                        if (!canLoop) continue;
                        if (bn.endsWith("]")) {
                            String bs = bn.substring(0, bn.indexOf(91));
                            NodeList bList = searchingDom.getElementsByTagName(bs);
                            String pSearch = bn.substring(bn.lastIndexOf(91) + 1, bn.lastIndexOf(93));
                            if (pSearch.equals("*")) {
                                int jj = bList.getLength();
                                for (int j = 0; j < jj; ++j) {
                                    Element tempD = (Element)bList.item(j);
                                    if (XFADataMapping.isDataValue(tempD)) {
                                        XBox.addCustomData(itEle, tempD.getTextContent());
                                        tempD.setAttribute(MAPPED, MAPPED);
                                        canLoop = false;
                                        continue block1;
                                    }
                                    searchingDom = tempD;
                                }
                                continue;
                            }
                            int point = Integer.parseInt(pSearch);
                            if (bList.getLength() <= point) continue;
                            Element tempD = (Element)bList.item(point);
                            if (XFADataMapping.isDataValue(tempD)) {
                                XBox.addCustomData(itEle, tempD.getTextContent());
                                tempD.setAttribute(MAPPED, MAPPED);
                                continue block0;
                            }
                            searchingDom = tempD;
                            continue;
                        }
                        NodeList bList = searchingDom.getElementsByTagName(bn);
                        int jj = bList.getLength();
                        for (int j = 0; j < jj; ++j) {
                            Element tempD = (Element)bList.item(j);
                            if (XFADataMapping.isDataValue(tempD)) {
                                XBox.addCustomData(itEle, tempD.getTextContent());
                                tempD.setAttribute(MAPPED, MAPPED);
                                canLoop = false;
                                continue block1;
                            }
                            searchingDom = tempD;
                        }
                    }
                    continue;
                }
                XFADataMapping.doRecordRefMapping(dom, itEle);
                continue;
            }
            XFADataMapping.doRecordRefMapping(dom, itEle);
        }
    }

    public static void doGlobalMapping(Element dom, Element som) {
        NodeList sList = som.getChildNodes();
        int ii = sList.getLength();
        for (int i = 0; i < ii; ++i) {
            Node it = sList.item(i);
            if (it.getNodeType() != 1) continue;
            Element itEle = (Element)it;
            if (XFADataMapping.isGlobal(itEle) && (XFADataMapping.isField(itEle) || XFADataMapping.isExclGroup(itEle))) {
                String search = itEle.getAttribute("name");
                NodeList result = dom.getElementsByTagName(search);
                if (result.getLength() <= 0) continue;
                XBox.addCustomData(itEle, result.item(0).getTextContent());
                continue;
            }
            XFADataMapping.doGlobalMapping(dom, itEle);
        }
    }

    private static void findDomDownSingle(Element nodeObj, String search, List<Element> arr) {
        NodeList nodeList = nodeObj.getChildNodes();
        int ii = nodeList.getLength();
        for (int i = 0; i < ii; ++i) {
            String bindName;
            Node li = nodeList.item(i);
            if (li.getNodeType() != 1) continue;
            Element ele = (Element)li;
            XOccur occur = new XOccur(ele);
            String string = bindName = occur.getRefBindName() != null ? occur.getRefBindName() : ele.getAttribute("name");
            if (bindName.equals(search) && !XFADataMapping.isTransient(ele) && !ele.getNodeName().equals("area") && !ele.getParentNode().getNodeName().equals("exclGroup")) {
                arr.add(ele);
                return;
            }
            XFADataMapping.findDomDownSingle(ele, search, arr);
        }
    }

    private static void findDomDownMulti(Element nodeObj, String search, List<Element> arr) {
        NodeList nodeList = nodeObj.getChildNodes();
        int ii = nodeList.getLength();
        for (int i = 0; i < ii; ++i) {
            String bindName;
            Node li = nodeList.item(i);
            if (li.getNodeType() != 1) continue;
            Element ele = (Element)li;
            XOccur occur = new XOccur(ele);
            String string = bindName = occur.getRefBindName() != null ? occur.getRefBindName() : ele.getAttribute("name");
            if (bindName.equals(search) && !XFADataMapping.isTransient(ele) && !ele.getNodeName().equals("area") && !ele.getParentNode().getNodeName().equals("exclGroup")) {
                arr.add(ele);
            }
            XFADataMapping.findDomDownMulti(ele, search, arr);
        }
    }

    private static boolean isGlobal(Element ele) {
        int ii = ele.getChildNodes().getLength();
        for (int i = 0; i < ii; ++i) {
            Node temp = ele.getChildNodes().item(i);
            if (!temp.getNodeName().equals("bind")) continue;
            Element tEle = (Element)temp;
            return tEle.getAttribute("match").equals("global");
        }
        return false;
    }

    private static boolean isDataRef(Element ele) {
        int ii = ele.getChildNodes().getLength();
        for (int i = 0; i < ii; ++i) {
            Node temp = ele.getChildNodes().item(i);
            if (!temp.getNodeName().equals("bind")) continue;
            Element tEle = (Element)temp;
            return tEle.getAttribute("match").equals("dataRef");
        }
        return false;
    }

    private static boolean isTransient(Element ele) {
        if (ele.getAttribute("name").isEmpty()) {
            return true;
        }
        int ii = ele.getChildNodes().getLength();
        for (int i = 0; i < ii; ++i) {
            Node temp = ele.getChildNodes().item(i);
            if (!temp.getNodeName().equals("bind")) continue;
            Element tEle = (Element)temp;
            return tEle.getAttribute("match").equals("none");
        }
        return false;
    }

    private static boolean isDataValue(Element dom) {
        int domChildLen = dom.getChildNodes().getLength();
        return domChildLen == 0 || domChildLen == 1 && dom.getChildNodes().item(0).getNodeType() == 3;
    }

    private static boolean isForm(Element node) {
        return node.getNodeName().startsWith("subform");
    }

    private static boolean isField(Element node) {
        return node.getNodeName().equals("field");
    }

    private static boolean isExclGroup(Element node) {
        return node.getNodeName().equals("exclGroup");
    }
}

