/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import com.idrsolutions.pdf.acroforms.xfa.XMargin;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XBox {
    private XLayout childLayout = XLayout.POSITION;
    private double x;
    private double y;
    private double w;
    private double h;
    public boolean hasH;
    public boolean hasW;
    public boolean hasMinW;
    public boolean hasMinH;
    private double marginLeft;
    private double marginRight;
    private double marginTop;
    private double marginBottom;
    private String id;
    private String name;
    private static final String customCoordsTag = "jRect";
    private static final String customGlobalHeightTag = "jGH";
    private static final String customGlobalPositionTag = "jGP";
    private static final String customDataTag = "rawValue";
    public static final String customNameTag = "jName";
    public boolean isHidden;
    private boolean isInvisible;
    public boolean isInactive;
    private int widgetSubType = -1;
    private boolean containMultiline;
    private XFontInfo formFontInfo = new XFontInfo("Arial", 10, 0);
    private final double calculatedHeight;
    public int keepNext = -1;

    public XBox(Node node) {
        int widgetType = node.getNodeName().hashCode();
        if (node.hasAttributes()) {
            block16: for (int z = 0; z < node.getAttributes().getLength(); ++z) {
                String attrName = node.getAttributes().item(z).getNodeName();
                String attrValue = node.getAttributes().item(z).getNodeValue();
                switch (attrName.hashCode()) {
                    case 120: {
                        this.x = XFAUtils.convertToPoints(attrValue);
                        continue block16;
                    }
                    case 121: {
                        this.y = XFAUtils.convertToPoints(attrValue);
                        continue block16;
                    }
                    case 119: {
                        this.w = XFAUtils.convertToPoints(attrValue);
                        this.hasW = true;
                        continue block16;
                    }
                    case 3351621: {
                        this.w = XFAUtils.convertToPoints(attrValue);
                        this.hasMinW = true;
                        continue block16;
                    }
                    case 104: {
                        this.h = XFAUtils.convertToPoints(attrValue);
                        this.hasH = true;
                        continue block16;
                    }
                    case 3351606: {
                        this.h = XFAUtils.convertToPoints(attrValue);
                        this.hasMinH = true;
                        continue block16;
                    }
                    case -1297063025: {
                        continue block16;
                    }
                    case 3355: {
                        this.id = attrValue;
                        continue block16;
                    }
                    case 3373707: {
                        this.name = attrValue;
                        continue block16;
                    }
                    case -1276666629: {
                        this.updatePresence(attrValue);
                        continue block16;
                    }
                    case -1109722326: {
                        this.updateLayout(attrValue);
                    }
                }
            }
        }
        if (widgetType == 1644111747 && this.h == 0.0) {
            double totalHeight = 0.0;
            switch (this.childLayout) {
                case LEFTRIGHTTB: 
                case RIGHTLEFTTB: {
                    if (this.w == 0.0) {
                        double maxH = 0.0;
                        for (int z = 0; z < node.getChildNodes().getLength(); ++z) {
                            Node child = node.getChildNodes().item(z);
                            XBox childBox = new XBox(child);
                            maxH = maxH > childBox.h ? maxH : childBox.h;
                        }
                        totalHeight = maxH;
                        break;
                    }
                    double availableW = this.w;
                    double tempH = 0.0;
                    for (int z = 0; z < node.getChildNodes().getLength(); ++z) {
                        Node child = node.getChildNodes().item(z);
                        XBox childBox = new XBox(child);
                        double childH = childBox.getCalculatedHeight();
                        tempH = tempH == 0.0 ? childH : tempH;
                        if (!((availableW -= childBox.w) < 0.0)) continue;
                        tempH += childH;
                        availableW = this.w - childH;
                    }
                    break;
                }
                default: {
                    for (int z = 0; z < node.getChildNodes().getLength(); ++z) {
                        Node child = node.getChildNodes().item(z);
                        XBox childBox = new XBox(child);
                        totalHeight += childBox.h;
                    }
                }
            }
            this.h = totalHeight;
        }
        this.updateOtherInfo(node);
        this.calculatedHeight = XBox.getCustomGlobalHeight(node);
    }

    private void updateOtherInfo(Node node) {
        block18: for (int c = 0; c < node.getChildNodes().getLength(); ++c) {
            Node child = node.getChildNodes().item(c);
            switch (child.getNodeName().hashCode()) {
                case -1081309778: {
                    if (!child.hasAttributes()) continue block18;
                    NamedNodeMap nnm = child.getAttributes();
                    block19: for (int m = 0; m < nnm.getLength(); ++m) {
                        String val = nnm.item(m).getNodeValue();
                        switch (nnm.item(m).getNodeName().hashCode()) {
                            case 1721482582: {
                                this.marginLeft = XFAUtils.convertToPoints(val);
                                continue block19;
                            }
                            case -986497848: {
                                this.marginTop = XFAUtils.convertToPoints(val);
                                continue block19;
                            }
                            case -1408130975: {
                                this.marginRight = XFAUtils.convertToPoints(val);
                                continue block19;
                            }
                            case -629442126: {
                                this.marginBottom = XFAUtils.convertToPoints(val);
                            }
                        }
                    }
                    continue block18;
                }
                case 3287941: {
                    if (!child.hasAttributes()) continue block18;
                    block20: for (int q = 0; q < child.getAttributes().getLength(); ++q) {
                        Node keepAtr = child.getAttributes().item(q);
                        switch (keepAtr.getNodeName().hashCode()) {
                            case 3377907: {
                                this.keepNext = keepAtr.getNodeValue().hashCode();
                                continue block20;
                            }
                        }
                    }
                    continue block18;
                }
                case 3732: {
                    Node uNode = null;
                    for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                        Node typeNode = child.getChildNodes().item(i);
                        switch (typeNode.getNodeName().hashCode()) {
                            case -1377687758: 
                            case -1004091177: 
                            case -878615035: 
                            case 68595383: 
                            case 282923610: 
                            case 535284191: 
                            case 566613829: 
                            case 609537093: 
                            case 1073584312: {
                                this.widgetSubType = typeNode.getNodeName().hashCode();
                                uNode = typeNode;
                            }
                        }
                    }
                    if (this.widgetSubType != -1004091177 || uNode == null || !uNode.hasAttributes() || uNode.getAttributes().getNamedItem("multiLine") == null) continue block18;
                    this.containMultiline = true;
                    continue block18;
                }
                case 3148879: {
                    this.formFontInfo = XFontInfo.getFontInfoFromNode(child);
                }
            }
        }
    }

    private void updatePresence(String attrValue) {
        switch (attrValue.hashCode()) {
            case -1217487446: {
                this.isHidden = true;
                break;
            }
            case -1901805651: {
                this.isInvisible = true;
                break;
            }
            case 24665195: {
                this.isInactive = true;
            }
        }
    }

    private void updateLayout(String attrValue) {
        this.childLayout = attrValue.hashCode() == 3694 ? XLayout.TB : (attrValue.equals("lr-tb") ? XLayout.LEFTRIGHTTB : (attrValue.equals("rl-tb") ? XLayout.RIGHTLEFTTB : (attrValue.equals("table") ? XLayout.TABLE : (attrValue.equals("row") ? XLayout.ROW : XLayout.POSITION))));
    }

    public static boolean isPageAreaFamily(Node node) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent.getNodeName().hashCode() != 858900412) continue;
            return true;
        }
        return false;
    }

    private static void addCustomCoords(Node node, double x, double y, double w, double h) {
        Element element = (Element)node;
        element.setAttribute(customCoordsTag, String.valueOf(x) + ',' + y + ',' + w + ',' + h);
    }

    public static void addGivenCoords(Node node, String coordsName, double value) {
        Element element = (Element)node;
        element.setAttribute(coordsName, value + "pt");
    }

    public static void addCustomCoords(Node node, double[] coords) {
        XBox.addCustomCoords(node, coords[0], coords[1], coords[2], coords[3]);
    }

    public static double[] getCustomCoords(Node node) {
        double[] coords = new double[4];
        if (node.hasAttributes() && node.getAttributes().getNamedItem(customCoordsTag) != null) {
            String coordsString = node.getAttributes().getNamedItem(customCoordsTag).getNodeValue();
            String[] str = coordsString.split(",");
            for (int z = 0; z < 4; ++z) {
                coords[z] = Double.parseDouble(str[z]);
            }
        }
        return coords;
    }

    public static void addCustomGlobalHeight(Node node, double height) {
        Element element = (Element)node;
        element.setAttribute(customGlobalHeightTag, height + "pt");
    }

    public static double getCustomGlobalHeight(Node node) {
        double cHeight = 0.0;
        if (node.hasAttributes() && node.getAttributes().getNamedItem(customGlobalHeightTag) != null) {
            String heightString = node.getAttributes().getNamedItem(customGlobalHeightTag).getNodeValue();
            cHeight = XFAUtils.convertToPoints(heightString);
        }
        return cHeight;
    }

    public static void addCustomGlobalPosition(Node node, double x, double y) {
        Element element = (Element)node;
        element.setAttribute(customGlobalPositionTag, String.valueOf(x) + ',' + y);
    }

    public static XRect getCustomGlobalPosition(Node node) {
        if (node.hasAttributes() && node.getAttributes().getNamedItem(customGlobalPositionTag) != null) {
            String str = node.getAttributes().getNamedItem(customGlobalPositionTag).getNodeValue();
            String[] data = str.split(",");
            double x = Double.parseDouble(data[0]);
            double y = Double.parseDouble(data[1]);
            return new XRect(x, y);
        }
        return null;
    }

    public static void addCustomData(Node node, String data) {
        if (node.getNodeName().equals("exclGroup")) {
            int ii = node.getChildNodes().getLength();
            for (int i = 0; i < ii; ++i) {
                Node nn = node.getChildNodes().item(i);
                if (!nn.getNodeName().equals("field")) continue;
                Element element = (Element)nn;
                Node ft = XBox.findChild(nn);
                if (ft == null) continue;
                if (ft.getTextContent().trim().equals(data)) {
                    element.setAttribute(customDataTag, data);
                    continue;
                }
                element.removeAttribute(customDataTag);
            }
        } else {
            Element element = (Element)node;
            element.setAttribute(customDataTag, data);
        }
    }

    private static Node findChild(Node node) {
        int ii = node.getChildNodes().getLength();
        for (int i = 0; i < ii; ++i) {
            Node nn = node.getChildNodes().item(i);
            if (!nn.getNodeName().equals("items")) continue;
            return nn;
        }
        return null;
    }

    public static String getCustomData(Node node) {
        String data = null;
        if (node.hasAttributes() && node.getAttributes().getNamedItem(customDataTag) != null) {
            data = node.getAttributes().getNamedItem(customDataTag).getNodeValue();
        }
        return data;
    }

    public boolean canDisplayWidget(Node node) {
        if (this.isHidden || this.isInactive) {
            return false;
        }
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            int code = parent.getNodeName().hashCode();
            if (code != -1867994364 && code != 471239358) continue;
            XBox pBox = new XBox(parent);
            if (!pBox.isHidden && !pBox.isInactive) continue;
            return false;
        }
        return true;
    }

    public boolean isVisibleWidget(Node node) {
        if (this.isInvisible) {
            return false;
        }
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            int code = parent.getNodeName().hashCode();
            if (code != -1867994364 && code != 471239358) continue;
            XBox pBox = new XBox(parent);
            if (!pBox.isInvisible) continue;
            return false;
        }
        return true;
    }

    public static void addCustomName(Node node, String data) {
        Element element = (Element)node;
        element.setAttribute(customNameTag, data);
    }

    public static String getCustomName(Node node) {
        String name = null;
        if (node.hasAttributes() && node.getAttributes().getNamedItem(customNameTag) != null) {
            name = node.getAttributes().getNamedItem(customNameTag).getNodeValue();
        }
        return name;
    }

    public static Node getVisibleParentForm(Node node) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            int code = parent.getNodeName().hashCode();
            if (code != -1867994364 && code != 471239358) continue;
            return parent;
        }
        return null;
    }

    public static boolean isPageSetBeforeParent(Node node) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            int hash = parent.getNodeName().hashCode();
            if (hash == -1867994364) {
                return false;
            }
            if (hash != -803560621) continue;
            return true;
        }
        return false;
    }

    public static Node getVisibleSomParent(Node node) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            Element parentEle;
            if (parent.getNodeType() != 1 || !(parentEle = (Element)parent).getAttribute("className").equals("subform") || parentEle.getAttribute("jSomBind").isEmpty()) continue;
            return parent;
        }
        return null;
    }

    public static boolean hiddenOrInactive(Node node) {
        Node visibleForm;
        int code;
        if (node.hasAttributes()) {
            for (int z = 0; z < node.getAttributes().getLength(); ++z) {
                String attrName = node.getAttributes().item(z).getNodeName();
                String attrValue = node.getAttributes().item(z).getNodeValue();
                switch (attrName.hashCode()) {
                    case -1276666629: {
                        switch (attrValue.hashCode()) {
                            case -1217487446: {
                                return true;
                            }
                            case 24665195: {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if (((code = node.getNodeName().hashCode()) == -1867994364 || code == 471239358) && (visibleForm = XBox.getVisibleParentForm(node)) != null) {
            XBox parentForm = new XBox(visibleForm);
            return parentForm.isInactive || parentForm.isHidden;
        }
        return false;
    }

    public static XRect getHierachyMarginRect(Node node) {
        XRect rect = new XRect();
        for (Node iter = node.getParentNode(); iter != null; iter = iter.getParentNode()) {
            double[] margins = new XMargin(iter).getValues();
            int code = iter.getNodeName().hashCode();
            if (code == -1867994364 || code == 471239358) {
                if (XBox.findLayout(iter) == XLayout.ROW) continue;
                rect.moveFromX(margins[3]);
                rect.moveFromY(margins[0]);
                continue;
            }
            rect.moveFromX(margins[3]);
            rect.moveFromY(margins[0]);
        }
        return rect;
    }

    public static double getHeirachyMarginTop(Node node) {
        double mTop = 0.0;
        for (Node iter = node.getParentNode(); iter != null; iter = iter.getParentNode()) {
            double[] margins = new XMargin(iter).getValues();
            mTop += margins[0];
        }
        return mTop;
    }

    public static double getHeirachyMarginBottom(Node node) {
        double mBot = 0.0;
        for (Node iter = node.getParentNode(); iter != null; iter = iter.getParentNode()) {
            double[] margins = new XMargin(iter).getValues();
            mBot += margins[2];
        }
        return mBot;
    }

    public double[] getXYWH() {
        return new double[]{this.x, this.y, this.w, this.getCalculatedHeight()};
    }

    public double[] getXYWHwithMargin() {
        return new double[]{this.x + this.marginLeft, this.y + this.marginTop, this.w, this.getCalculatedHeight()};
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getW() {
        return this.w;
    }

    public double getCalculatedHeight() {
        return this.h > this.calculatedHeight ? this.h : this.calculatedHeight;
    }

    public double getH() {
        return this.h;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public double getMarginTop() {
        return this.marginTop;
    }

    public double getMarginBottom() {
        return this.marginBottom;
    }

    public int getWidgetSubType() {
        return this.widgetSubType;
    }

    public boolean isContainMultiline() {
        return this.containMultiline;
    }

    public XFontInfo getFormFontInfo() {
        return this.formFontInfo;
    }

    public static XLayout findLayout(Node node) {
        XLayout childLayout = XLayout.POSITION;
        if (node.getNodeType() == 1) {
            Element nodeEle = (Element)node;
            String lay = nodeEle.getAttribute("layout");
            childLayout = lay.hashCode() == 3694 ? XLayout.TB : (lay.equals("lr-tb") ? XLayout.LEFTRIGHTTB : (lay.equals("rl-tb") ? XLayout.RIGHTLEFTTB : (lay.equals("table") ? XLayout.TABLE : (lay.equals("row") ? XLayout.ROW : XLayout.POSITION))));
        }
        return childLayout;
    }

    public static enum XLayout {
        POSITION,
        TB,
        LEFTRIGHTTB,
        RIGHTLEFTTB,
        TABLE,
        ROW;

    }
}

