/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import org.jpedal.color.PdfColor;

public class ExDataStyle {
    private static final int CSS_FONTFAMILY = 108532386;
    private static final int CSS_FONTSIZE = -1586082113;
    private static final int CSS_FONTWEIGHT = 598800822;
    private static final int CSS_COLOR = 94842723;
    private static final int CSS_LETTERSPACING = -1988401764;
    private static final int CSS_LINEHEIGHT = -1215680224;
    private static final int CSS_MARGINLEFT = 941004998;
    private static final int CSS_MARGINRIGHT = -887955139;
    private static final int CSS_MARGINTOP = 1970025654;
    private static final int CSS_MARGINBOTTOM = 2086035242;
    private static final int CSS_TEXTALIGN = 746232421;
    private String family = "Arial";
    public int size;
    private int weight = 0;
    public PdfColor color = new PdfColor(0, 0, 0);
    private int letterSpacing;
    private int lineHeight;
    public final int[] margins = new int[4];
    public int textAlign = 3317767;
    public XRect rect = new XRect();
    public String content = "";

    public ExDataStyle(XFontInfo info) {
        this.family = info.getTypeFace();
        this.size = info.getSize();
        this.weight = info.getWeight();
        this.color = info.getColor();
    }

    public void update(String styleString) {
        String[] styles;
        if (styleString == null || styleString.isEmpty()) {
            return;
        }
        block23: for (String s : styles = styleString.split(";")) {
            String[] temp = s.split(":");
            String attr = temp[0].trim().toLowerCase();
            String value = temp[1];
            switch (attr.hashCode()) {
                case 108532386: {
                    this.family = value;
                    continue block23;
                }
                case -1586082113: {
                    double fs = Math.round(XFAUtils.convertToPoints(value));
                    this.size = (int)fs;
                    continue block23;
                }
                case 598800822: {
                    switch (value) {
                        case "normal": {
                            this.weight = 0;
                            break;
                        }
                        case "bold": {
                            this.weight = 1;
                            break;
                        }
                        case "italic": {
                            this.weight = 2;
                        }
                    }
                    continue block23;
                }
                case -1988401764: {
                    double ls = Math.round(XFAUtils.convertToPoints(value));
                    this.letterSpacing = (int)ls;
                    continue block23;
                }
                case 94842723: {
                    this.color = XFAUtils.getPdfColorFromStyle(value);
                    continue block23;
                }
                case -1215680224: {
                    this.lineHeight = (int)Math.round(XFAUtils.convertToPoints(value));
                    continue block23;
                }
                case 1970025654: {
                    this.margins[0] = (int)Math.round(XFAUtils.convertToPoints(value));
                    continue block23;
                }
                case -887955139: {
                    this.margins[1] = (int)Math.round(XFAUtils.convertToPoints(value));
                    continue block23;
                }
                case 2086035242: {
                    this.margins[2] = (int)Math.round(XFAUtils.convertToPoints(value));
                    continue block23;
                }
                case 941004998: {
                    this.margins[3] = (int)Math.round(XFAUtils.convertToPoints(value));
                    continue block23;
                }
                case 746232421: {
                    if (value.equals("right")) {
                        this.textAlign = 108511772;
                        continue block23;
                    }
                    if (!value.equals("center")) continue block23;
                    this.textAlign = -1364013995;
                }
            }
        }
    }

    private ExDataStyle() {
    }

    public ExDataStyle substitute() {
        ExDataStyle ex = new ExDataStyle();
        ex.family = this.family;
        ex.letterSpacing = this.letterSpacing;
        ex.size = this.size;
        ex.weight = this.weight;
        ex.color = this.color;
        ex.lineHeight = this.lineHeight;
        ex.textAlign = this.textAlign;
        return ex;
    }

    public XFontInfo getFontInfo() {
        XFontInfo info = new XFontInfo();
        info.setColor(this.color);
        info.setSize(this.size);
        info.setTypeFace(this.family);
        info.setWeight(this.weight);
        return info;
    }
}

