/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.wmf;

import com.idrsolutions.image.DataByteLittle;
import com.idrsolutions.image.DataFileLittle;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.wmf.Brush;
import com.idrsolutions.image.wmf.GraphicObject;
import com.idrsolutions.image.wmf.Info;
import com.idrsolutions.image.wmf.Pen;
import com.idrsolutions.image.wmf.WFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class WmfDecoder {
    private static boolean debug;

    public BufferedImage read(File file) throws IOException {
        DataFileLittle reader = new DataFileLittle(file);
        BufferedImage image = WmfDecoder.parseData(reader);
        reader.close();
        return image;
    }

    public BufferedImage read(byte[] data) throws IOException {
        DataByteLittle reader = new DataByteLittle(data);
        BufferedImage image = WmfDecoder.parseData(reader);
        reader.close();
        return image;
    }

    private static BufferedImage parseData(DataReader reader) throws IOException {
        int key = reader.getU32();
        Info info = new Info();
        Rectangle bRect = null;
        if (key == -1698247209) {
            info.hwmf = reader.getU16();
            info.boundingBox = WmfDecoder.getRect(reader);
            bRect = new Rectangle(Math.min(info.boundingBox[0], info.boundingBox[2]), Math.min(info.boundingBox[1], info.boundingBox[3]), Math.abs(info.boundingBox[2] - info.boundingBox[0]), Math.abs(info.boundingBox[3] - info.boundingBox[1]));
            info.unitsPerInch = reader.getU16();
            reader.skip(6);
            info.type = reader.getU16();
            info.headerSize = reader.getU16();
        } else {
            info.type = key & 0xFFFF;
            info.headerSize = key >>> 16 & 0xFFFF;
        }
        info.version = reader.getU16();
        info.sizeLow = reader.getU16();
        info.sizeHigh = reader.getU16();
        info.nObjects = reader.getU16();
        info.maxRecord = reader.getU32();
        reader.skip(2);
        int pos = reader.getPosition();
        WmfDecoder.readDimensions(reader, info);
        info.scale = 1.0f;
        if (bRect != null) {
            info.scale = bRect.getWidth() == (double)info.wex ? 96.0f / (float)info.unitsPerInch : (float)(96.0 * bRect.getWidth() / (double)info.unitsPerInch / (double)Math.abs(info.wex));
        }
        int iw = Math.round(Math.abs((float)info.wex * info.scale));
        int ih = Math.round(Math.abs((float)info.wey * info.scale));
        BufferedImage image = new BufferedImage(iw, ih, 2);
        Graphics2D gg = image.createGraphics();
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.setColor(Color.WHITE);
        gg.fillRect(0, 0, iw, ih);
        reader.moveTo(pos);
        WmfDecoder.readRecords(reader, info, gg);
        return image;
    }

    private static void readDimensions(DataReader reader, Info info) throws IOException {
        boolean canRead = true;
        while (canRead) {
            int pos = reader.getPosition();
            int size = reader.getU32() << 1;
            int function = reader.getU16();
            switch (function) {
                case 0: {
                    canRead = false;
                    break;
                }
                case 523: {
                    WmfDecoder.setWindowOrg(reader, info);
                    break;
                }
                case 524: {
                    WmfDecoder.setWindowExt(reader, info);
                    break;
                }
                case 525: {
                    WmfDecoder.setViewportOrg(reader, info);
                    break;
                }
                case 526: {
                    WmfDecoder.setViewportExt(reader, info);
                    break;
                }
            }
            reader.moveTo(pos + size);
        }
    }

    private static void readRecords(DataReader reader, Info info, Graphics2D gg) throws IOException {
        boolean canRead = true;
        while (canRead) {
            int pos = reader.getPosition();
            int size = reader.getU32() << 1;
            int function = reader.getU16();
            if (debug) {
                System.out.println(size + " --- " + function + " -- " + Integer.toHexString(function));
            }
            switch (function) {
                case 0: {
                    canRead = false;
                    break;
                }
                case 259: {
                    info.mapmode = reader.getU16();
                    break;
                }
                case 505: 
                case 764: {
                    WmfDecoder.storeGraphicObject(info, function, 1, reader.getPosition(), size);
                    break;
                }
                case 247: {
                    WmfDecoder.storeGraphicObject(info, function, 3, reader.getPosition(), size);
                    break;
                }
                case 763: {
                    WmfDecoder.storeGraphicObject(info, function, 2, reader.getPosition(), size);
                    break;
                }
                case 1791: {
                    WmfDecoder.storeGraphicObject(info, function, 5, reader.getPosition(), size);
                    break;
                }
                case 762: {
                    WmfDecoder.storeGraphicObject(info, function, 4, reader.getPosition(), size);
                    break;
                }
                case 496: {
                    WmfDecoder.deleteGraphicObject(reader, info);
                    break;
                }
                case 301: {
                    WmfDecoder.selectGraphicObject(reader, info);
                    break;
                }
                case 260: {
                    info.fbro = reader.getU16();
                    break;
                }
                case 258: {
                    info.bkMode = reader.getU16();
                    break;
                }
                case 262: {
                    info.pfm = reader.getU16();
                    break;
                }
                case 531: 
                case 532: 
                case 804: 
                case 805: 
                case 1048: 
                case 1051: 
                case 1055: 
                case 1313: 
                case 1336: 
                case 1564: 
                case 2610: {
                    WmfDecoder.drawObjects(reader, info, gg, function, size);
                    break;
                }
                case 521: {
                    WmfDecoder.setTextColor(reader, info);
                    break;
                }
                case 513: {
                    WmfDecoder.setBgColor(reader, info);
                    break;
                }
                case 30: 
                case 261: 
                case 523: 
                case 524: 
                case 525: 
                case 526: 
                case 1574: {
                    break;
                }
                default: {
                    System.out.println("not found " + function + ' ' + Integer.toHexString(function));
                }
            }
            reader.moveTo(pos + size);
        }
    }

    private static void setWindowOrg(DataReader reader, Info info) throws IOException {
        info.woy = (short)reader.getU16();
        info.wox = (short)reader.getU16();
    }

    private static void setWindowExt(DataReader reader, Info info) throws IOException {
        info.wey = (short)reader.getU16();
        info.wex = (short)reader.getU16();
    }

    private static void setViewportOrg(DataReader reader, Info info) throws IOException {
        info.voy = (short)reader.getU16();
        info.vox = (short)reader.getU16();
    }

    private static void setViewportExt(DataReader reader, Info info) throws IOException {
        info.vey = (short)reader.getU16();
        info.vex = (short)reader.getU16();
    }

    private static void setTextColor(DataReader reader, Info info) throws IOException {
        info.textColor = new Color(reader.getU8(), reader.getU8(), reader.getU8());
        reader.skip(1);
    }

    private static void setBgColor(DataReader reader, Info info) throws IOException {
        info.bgColor = new Color(reader.getU8(), reader.getU8(), reader.getU8());
        reader.skip(1);
    }

    private static int[] getRect(DataReader reader) throws IOException {
        short left = (short)reader.getU16();
        short top = (short)reader.getU16();
        short right = (short)reader.getU16();
        short bottom = (short)reader.getU16();
        return new int[]{left, top, right, bottom};
    }

    private static void storeGraphicObject(Info info, int record, int type, int offset, int len) {
        for (int op = 0; info.objects[op] != null && op < 65536; ++op) {
        }
        info.objects[op] = new GraphicObject(record, type, offset, len);
    }

    private static void deleteGraphicObject(DataReader reader, Info info) throws IOException {
        int pos = reader.getU16();
        info.objects[pos] = null;
    }

    private static void selectGraphicObject(DataReader reader, Info info) throws IOException {
        int cp = reader.getU16();
        GraphicObject sel = info.objects[cp];
        if (sel != null) {
            info.selected[sel.type] = sel;
        }
    }

    private static void drawObjects(DataReader reader, Info info, Graphics2D gg, int record, int size) throws IOException {
        switch (record) {
            case 804: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4], info.selected[1]};
                WmfDecoder.drawPolygon(reader, info, gObjects, gg);
                break;
            }
            case 1336: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4], info.selected[1]};
                WmfDecoder.drawPolyPolygon(reader, info, gObjects, gg);
                break;
            }
            case 805: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4]};
                WmfDecoder.drawPolyline(reader, info, gObjects, gg);
                break;
            }
            case 1048: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4], info.selected[1]};
                WmfDecoder.drawEllipse(reader, info, gObjects, gg);
                break;
            }
            case 1313: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[2]};
                WmfDecoder.drawText(reader, info, gObjects, gg);
                break;
            }
            case 2610: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[2]};
                WmfDecoder.drawExtText(reader, info, gObjects, gg, size);
                break;
            }
            case 1055: {
                WmfDecoder.drawPixel(reader, info, gg);
                break;
            }
            case 1051: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4], info.selected[1]};
                WmfDecoder.drawRectangle(reader, info, gObjects, gg);
                break;
            }
            case 1564: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4], info.selected[1]};
                WmfDecoder.drawRoundRectangle(reader, info, gObjects, gg);
                break;
            }
            case 532: {
                WmfDecoder.drawMoveTo(reader, info);
                break;
            }
            case 531: {
                GraphicObject[] gObjects = new GraphicObject[]{info.selected[4]};
                WmfDecoder.drawLineTo(reader, info, gObjects, gg);
            }
        }
    }

    private static void updateBrush(DataReader reader, GraphicObject brushObj, Graphics2D gg, Shape shape) throws IOException {
        if (brushObj != null) {
            Brush brush = new Brush(reader, brushObj.offset);
            if (brush.fill != null) {
                gg.setPaint(brush.fill);
                gg.fill(shape);
            }
        }
    }

    private static void updatePen(DataReader reader, Info info, GraphicObject penObj, Graphics2D gg, Shape shape) throws IOException {
        if (penObj != null) {
            Pen pen = new Pen(reader, penObj.offset);
            int penW = WmfDecoder.calculateDim(info, pen.width);
            if (penW > 0) {
                gg.setPaint(pen.color);
                gg.setStroke(new BasicStroke((float)penW + 0.5f));
                gg.draw(shape);
            }
        }
    }

    private static void updateFont(DataReader reader, Info info, GraphicObject fontObj, Graphics2D gg, int x, int y, String str) throws IOException {
        if (fontObj != null) {
            WFont wfont = new WFont(reader, fontObj.offset, fontObj.len);
            int fstyle = wfont.italic ? 2 : (wfont.weight == 700 ? 1 : 0);
            int fh = WmfDecoder.calculateDim(info, wfont.height);
            Font font = new Font(wfont.family, fstyle, fh);
            gg.setFont(font);
            if (info.bgColor != null) {
                gg.setColor(info.bgColor);
                FontMetrics fm = gg.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(str, gg);
                gg.fill(new Rectangle(x, y - fh, (int)rect.getWidth(), fh));
            }
            gg.setColor(info.textColor);
            gg.drawString(str, x, y);
        }
    }

    private static void drawRoundRectangle(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int width = reader.getU16();
        width = WmfDecoder.calculateDim(info, width);
        int height = reader.getU16();
        height = WmfDecoder.calculateDim(info, height);
        int[] pp = WmfDecoder.getRect(reader);
        int y1 = WmfDecoder.calculateY(info, pp[0]);
        int x1 = WmfDecoder.calculateX(info, pp[1]);
        int y2 = WmfDecoder.calculateY(info, pp[2]);
        int x2 = WmfDecoder.calculateX(info, pp[3]);
        int x = Math.min(x1, x2);
        int y = Math.min(y1, y2);
        int w = Math.abs(x2 - x1);
        int h = Math.abs(y2 - y1);
        WmfDecoder.updatePen(reader, info, tools[0], gg, new RoundRectangle2D.Float(x, y, w, h, width, height));
        WmfDecoder.updateBrush(reader, tools[1], gg, new RoundRectangle2D.Float(x, y, w, h, width, height));
    }

    private static void drawRectangle(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int[] pp = WmfDecoder.getRect(reader);
        int y1 = WmfDecoder.calculateY(info, pp[0]);
        int x1 = WmfDecoder.calculateX(info, pp[1]);
        int y2 = WmfDecoder.calculateY(info, pp[2]);
        int x2 = WmfDecoder.calculateX(info, pp[3]);
        int x = Math.min(x1, x2);
        int y = Math.min(y1, y2);
        int w = Math.abs(x2 - x1);
        int h = Math.abs(y2 - y1);
        WmfDecoder.updatePen(reader, info, tools[0], gg, new Rectangle(x, y, w, h));
        WmfDecoder.updateBrush(reader, tools[1], gg, new Rectangle(x, y, w, h));
    }

    private static void drawMoveTo(DataReader reader, Info info) throws IOException {
        short y = (short)reader.getU16();
        short x = (short)reader.getU16();
        info.curY = WmfDecoder.calculateY(info, y);
        info.curX = WmfDecoder.calculateX(info, x);
    }

    private static void drawLineTo(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int prevY = info.curY;
        int prevX = info.curX;
        short y = (short)reader.getU16();
        short x = (short)reader.getU16();
        info.curY = WmfDecoder.calculateY(info, y);
        info.curX = WmfDecoder.calculateX(info, x);
        WmfDecoder.updatePen(reader, info, tools[0], gg, new Line2D.Double(prevX, prevY, info.curX, info.curY));
    }

    private static void drawPolygon(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int nPoints = reader.getU16();
        int[] x = new int[nPoints];
        int[] y = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            short xx = (short)reader.getU16();
            short yy = (short)reader.getU16();
            x[i] = WmfDecoder.calculateX(info, xx);
            y[i] = WmfDecoder.calculateY(info, yy);
        }
        WmfDecoder.updatePen(reader, info, tools[0], gg, new Polygon(x, y, nPoints));
        WmfDecoder.updateBrush(reader, tools[1], gg, new Polygon(x, y, nPoints));
    }

    private static void drawPolyPolygon(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int nPoints;
        int i;
        int nPolygons = reader.getU16();
        int[] nPolyPoints = new int[nPolygons];
        for (int i2 = 0; i2 < nPolygons; ++i2) {
            nPolyPoints[i2] = reader.getU16();
        }
        int[][] x = new int[nPolygons][];
        int[][] y = new int[nPolygons][];
        for (i = 0; i < nPolygons; ++i) {
            nPoints = nPolyPoints[i];
            x[i] = new int[nPoints];
            y[i] = new int[nPoints];
            for (int j = 0; j < nPoints; ++j) {
                short xx = (short)reader.getU16();
                short yy = (short)reader.getU16();
                x[i][j] = WmfDecoder.calculateX(info, xx);
                y[i][j] = WmfDecoder.calculateY(info, yy);
            }
        }
        for (i = 0; i < nPolygons; ++i) {
            nPoints = nPolyPoints[i];
            WmfDecoder.updatePen(reader, info, tools[0], gg, new Polygon(x[i], y[i], nPoints));
            WmfDecoder.updateBrush(reader, tools[1], gg, new Polygon(x[i], y[i], nPoints));
        }
    }

    private static void drawPolyline(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int nPoints = reader.getU16();
        int[] x = new int[nPoints];
        int[] y = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            short xx = (short)reader.getU16();
            short yy = (short)reader.getU16();
            x[i] = WmfDecoder.calculateX(info, xx);
            y[i] = WmfDecoder.calculateY(info, yy);
        }
        GeneralPath shape = new GeneralPath();
        shape.moveTo(x[0], y[0]);
        for (int i = 1; i < nPoints; ++i) {
            shape.lineTo(x[i], y[i]);
        }
        WmfDecoder.updatePen(reader, info, tools[0], gg, shape);
    }

    private static void drawEllipse(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int ly = reader.getU16();
        ly = WmfDecoder.calculateY(info, ly);
        int lx = reader.getU16();
        lx = WmfDecoder.calculateX(info, lx);
        int uy = reader.getU16();
        uy = WmfDecoder.calculateY(info, uy);
        int ux = reader.getU16();
        ux = WmfDecoder.calculateX(info, ux);
        WmfDecoder.updatePen(reader, info, tools[0], gg, new Ellipse2D.Double(ux, uy, Math.abs(lx - ux), Math.abs(ly - uy)));
        WmfDecoder.updateBrush(reader, tools[1], gg, new Ellipse2D.Double(ux, uy, Math.abs(lx - ux), Math.abs(ly - uy)));
    }

    private static void drawExtText(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg, int size) throws IOException {
        int start = reader.getPosition();
        int y = reader.getU16();
        y = WmfDecoder.calculateY(info, y);
        int x = reader.getU16();
        x = WmfDecoder.calculateX(info, x);
        int strLen = reader.getU16();
        int fwopts = reader.getU16();
        if ((fwopts & 6) > 0) {
            WmfDecoder.getRect(reader);
        }
        byte[] data = new byte[strLen];
        reader.read(data);
        String str = new String(data);
        int bal = reader.getPosition() - start - size;
        if (bal != 0) {
            // empty if block
        }
        WmfDecoder.updateFont(reader, info, tools[0], gg, x, y, str);
    }

    private static void drawText(DataReader reader, Info info, GraphicObject[] tools, Graphics2D gg) throws IOException {
        int strLen = reader.getU16();
        byte[] data = new byte[strLen];
        reader.read(data);
        String str = new String(data);
        int y = reader.getU16();
        y = WmfDecoder.calculateY(info, y);
        int x = reader.getU16();
        x = WmfDecoder.calculateX(info, x);
        WmfDecoder.updateFont(reader, info, tools[0], gg, x, y, str);
    }

    private static void drawPixel(DataReader reader, Info info, Graphics2D gg) throws IOException {
        Color pixColor = new Color(reader.getU8(), reader.getU8(), reader.getU8());
        int y = reader.getU16();
        y = WmfDecoder.calculateY(info, y);
        int x = reader.getU16();
        x = WmfDecoder.calculateX(info, x);
        gg.setColor(pixColor);
        gg.drawRect(x, y, 1, 1);
    }

    private static int calculateX(Info info, int x) {
        if (info.wex < 1) {
            return Math.round(info.scale * (float)(info.wox - x));
        }
        return Math.round(info.scale * (float)(x - info.wox));
    }

    private static int calculateY(Info info, int y) {
        int r = info.wey < 1 ? Math.round(info.scale * (float)(info.woy - y)) : Math.round(info.scale * (float)(y - info.woy));
        return r;
    }

    private static int calculateDim(Info info, int t) {
        return (int)Math.ceil(info.scale * (float)t);
    }
}

