/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.wmf;

import com.idrsolutions.image.DataReader;
import java.io.IOException;

class WFont {
    public final int height;
    private final int width;
    private final int escapement;
    private final int orientation;
    public final int weight;
    private final int charset;
    private final int outPrecision;
    private final int clipPrecision;
    private final int quality;
    private final int pitch;
    public final boolean italic;
    private final boolean underline;
    private final boolean strikeOut;
    public final String family;

    WFont(DataReader reader, int offset, int size) throws IOException {
        reader.moveTo(offset);
        this.height = Math.abs((short)reader.getU16());
        this.width = (short)reader.getU16();
        this.escapement = (short)reader.getU16();
        this.orientation = (short)reader.getU16();
        this.weight = (short)reader.getU16();
        this.italic = reader.getU8() != 0;
        this.underline = reader.getU8() != 0;
        this.strikeOut = reader.getU8() != 0;
        this.charset = reader.getU8();
        this.outPrecision = reader.getU8();
        this.clipPrecision = reader.getU8();
        this.quality = reader.getU8();
        this.pitch = reader.getU8();
        int bal = size - 18;
        byte[] temp = new byte[bal];
        reader.read(temp);
        StringBuilder sb = new StringBuilder();
        for (byte aTemp : temp) {
            if (aTemp <= 31) break;
            sb.append((char)aTemp);
        }
        this.family = sb.toString().replaceAll("[^A-z0-9 ]", "");
    }

    public String toString() {
        return "WFont{height=" + this.height + ", width=" + this.width + ", escapement=" + this.escapement + ", orientation=" + this.orientation + ", weight=" + this.weight + ", charset=" + this.charset + ", outPrecision=" + this.outPrecision + ", clipPrecision=" + this.clipPrecision + ", quality=" + this.quality + ", pitch=" + this.pitch + ", italic=" + this.italic + ", underline=" + this.underline + ", strikeOut=" + this.strikeOut + ", family=" + this.family + '}';
    }
}

