/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import com.idrsolutions.image.webm.BitDecoder;
import com.idrsolutions.image.webm.SegmentQ;

public class SegmentQuants {
    final SegmentQ[] segQuants = new SegmentQ[4];

    private static int getDQ(BitDecoder bc) {
        int ret = 0;
        if (bc.getBit() > 0) {
            ret = bc.getLiteral(4);
            if (bc.getBit() > 0) {
                ret = -ret;
            }
        }
        return ret;
    }

    public SegmentQuants() {
        for (int x = 0; x < 4; ++x) {
            this.segQuants[x] = new SegmentQ();
        }
    }

    public void parse(BitDecoder bc, boolean hasSegmentation, boolean mb_segement_abs_delta) {
        int v;
        int index = bc.getLiteral(7);
        int y1dcdq = v = SegmentQuants.getDQ(bc);
        int y2dcdq = v = SegmentQuants.getDQ(bc);
        int y2acdq = v = SegmentQuants.getDQ(bc);
        int uvdcdq = v = SegmentQuants.getDQ(bc);
        int uvacdq = v = SegmentQuants.getDQ(bc);
        for (SegmentQ s : this.segQuants) {
            if (!hasSegmentation) {
                s.index = index;
            } else if (!mb_segement_abs_delta) {
                s.index += index;
            }
            s.setY1dc(y1dcdq);
            s.setY2DC(y2dcdq);
            s.setY2ac_delta_q(y2acdq);
            s.setDeltaQUVDC(uvdcdq);
            s.setDeltaQUVAC(uvacdq);
        }
    }
}

