/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LittleReader {
    private final ByteBuffer buffer;
    private final int length;

    LittleReader(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.length = data.length;
    }

    public int getUINT8() {
        return this.buffer.get() & 0xFF;
    }

    public int getUINT32() {
        return this.buffer.getInt();
    }

    public String getFOURCC() {
        byte[] bb = new byte[4];
        this.buffer.get(bb);
        return new String(bb);
    }

    public void seek(int pos) {
        this.buffer.position(pos);
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public int getSize() {
        return this.length;
    }
}

