/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

public class LZW {
    private byte[][] codes;
    private byte[] input;
    private byte[] output;
    private int bitsToGet = 9;
    private int bp;
    private int tp;
    private int op;
    private int putBuffer;
    private int putBits;

    public void decompress(byte[] output, byte[] input) {
        int code;
        this.init();
        this.input = input;
        this.output = output;
        this.bp = 0;
        this.op = 0;
        this.putBuffer = 0;
        this.putBits = 0;
        int oldCode = 0;
        while ((code = this.findNext()) != 257 && this.op < output.length) {
            byte[] chars;
            if (code == 256) {
                this.init();
                code = this.findNext();
                if (code == 257) break;
                this.addCodes(this.codes[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tp) {
                chars = this.codes[code];
                this.addCodes(chars);
                this.addCodeToCodes(this.codes[oldCode], chars[0]);
                oldCode = code;
                continue;
            }
            chars = this.codes[oldCode];
            chars = LZW.generateCodeArray(chars, chars[0]);
            this.addCodes(chars);
            this.addCodeArrToCodes(chars);
            oldCode = code;
        }
    }

    public void init() {
        this.codes = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.codes[i] = new byte[1];
            this.codes[i][0] = (byte)i;
        }
        this.tp = 258;
        this.bitsToGet = 9;
    }

    private void addCodes(byte[] codes) {
        for (byte code : codes) {
            this.output[this.op++] = code;
        }
    }

    private void addCodeToCodes(byte[] oldCodes, byte code) {
        int length = oldCodes.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldCodes, 0, string, 0, length);
        string[length] = code;
        this.codes[this.tp++] = string;
        switch (this.tp) {
            case 511: {
                this.bitsToGet = 10;
                break;
            }
            case 1023: {
                this.bitsToGet = 11;
                break;
            }
            case 2047: {
                this.bitsToGet = 12;
                break;
            }
        }
    }

    private void addCodeArrToCodes(byte[] codeArr) {
        this.codes[this.tp++] = codeArr;
        switch (this.tp) {
            case 511: {
                this.bitsToGet = 10;
                break;
            }
            case 1023: {
                this.bitsToGet = 11;
                break;
            }
            case 2047: {
                this.bitsToGet = 12;
                break;
            }
        }
    }

    private static byte[] generateCodeArray(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    private int findNext() {
        int[] combinator = new int[]{511, 1023, 2047, 4095};
        try {
            this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
            this.putBits += 8;
            if (this.putBits < this.bitsToGet) {
                this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
                this.putBits += 8;
            }
            int code = this.putBuffer >> this.putBits - this.bitsToGet & combinator[this.bitsToGet - 9];
            this.putBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Exception in findNext " + e);
            return 257;
        }
    }
}

