/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.jpeg.Component;
import java.io.IOException;

class ScanInfo {
    public int nComp;
    public int spectralStart;
    Component[] components;

    ScanInfo() {
    }

    void read(DataReader data) throws IOException {
        int count = 2;
        int length = data.getU16();
        this.nComp = data.getU8();
        ++count;
        this.components = new Component[this.nComp];
        for (int i = 0; i < this.nComp; ++i) {
            this.components[i] = new Component();
            if (count > length) {
                throw new IOException("Scan Info Error");
            }
            this.components[i].lsComp = data.getU8();
            ++count;
            int temp = data.getU8();
            ++count;
            this.components[i].lsDC = temp >> 4;
            this.components[i].lsAC = temp & 0xF;
        }
        this.spectralStart = data.getU8();
        ++count;
        data.skip(2);
        if ((count += 2) != length) {
            throw new IOException("Scan Info Error");
        }
    }
}

