/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeglossless;

import com.idrsolutions.image.DataByteBig;
import com.idrsolutions.image.DataFileBig;
import com.idrsolutions.image.DataReader;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.jpeg.Component;
import com.idrsolutions.image.jpeglossless.Frame;
import com.idrsolutions.image.jpeglossless.HTable;
import com.idrsolutions.image.jpeglossless.QTable;
import com.idrsolutions.image.jpeglossless.Sampler;
import com.idrsolutions.image.jpeglossless.ScanInfo;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;

public class JpegLosslessDecoder
extends JDeliImage {
    private static final int MAX_HTREE = 50;
    private static final int MSB = Integer.MIN_VALUE;
    private DataReader reader;
    private Frame frame;
    private HTable hTable;
    private QTable qTable;
    private ScanInfo scan;
    private final int[][][] HuffTab = new int[4][2][12800];
    private final int[] sIDCT = new int[64];
    private final int[] nBlock = new int[10];
    private final int[][] acTab = new int[10][];
    private final int[][] dcTab = new int[10][];
    private final int[][] qTab = new int[10][];
    private boolean isRestart;
    private int marker;
    private int mIndex;
    private int nComp;
    private int interRestart;
    private int selection;
    private int iw;
    private int ih;
    private int mask;
    private int xLoc;
    private int yLoc;
    private int[] samples;
    private int[] samplesR;
    private int[] samplesG;
    private int[] samplesB;
    private static final int[] POINTERS = new int[]{0, 5, 40, 16, 45, 2, 7, 42, 21, 56, 8, 61, 18, 47, 1, 4, 41, 23, 58, 13, 32, 24, 37, 10, 63, 17, 44, 3, 6, 43, 20, 57, 15, 34, 29, 48, 53, 26, 39, 9, 60, 19, 46, 22, 59, 12, 33, 31, 50, 55, 25, 36, 11, 62, 14, 35, 28, 49, 52, 27, 38, 30, 51, 54};
    private static final int[] FIXED = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};

    public BufferedImage read(byte[] data) throws IOException {
        this.reader = new DataByteBig(data);
        return this.readImage();
    }

    public BufferedImage read(File file) throws IOException {
        this.reader = new DataFileBig(file);
        BufferedImage img = this.readImage();
        this.reader.close();
        return img;
    }

    private BufferedImage readImage() throws IOException {
        this.frame = new Frame();
        this.scan = new ScanInfo();
        this.qTable = new QTable();
        this.hTable = new HTable();
        int[][] decoded = this.getRawPixelArray();
        int width = this.frame.width;
        int height = this.frame.height;
        if (this.nComp == 1) {
            switch (this.frame.precision) {
                case 8: {
                    return JpegLosslessDecoder.toGray8(decoded, width, height);
                }
                case 12: {
                    return JpegLosslessDecoder.toGray12(decoded, width, height);
                }
                case 16: {
                    return JpegLosslessDecoder.toGray16(decoded, width, height);
                }
            }
        }
        if (this.nComp == 3) {
            return JpegLosslessDecoder.toRGB8(decoded, width, height);
        }
        return null;
    }

    private static BufferedImage toGray16(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 11);
        short[] imageBuffer = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < imageBuffer.length; ++i) {
            imageBuffer[i] = (short)decoded[0][i];
        }
        return image;
    }

    private static BufferedImage toGray12(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 11);
        short[] imageBuffer = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < imageBuffer.length; ++i) {
            imageBuffer[i] = (short)(decoded[0][i] << 4);
        }
        return image;
    }

    private static BufferedImage toGray8(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] imageBuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < imageBuffer.length; ++i) {
            imageBuffer[i] = (byte)decoded[0][i];
        }
        return image;
    }

    private static BufferedImage toRGB8(int[][] decoded, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] imageBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < imageBuffer.length; ++i) {
            imageBuffer[i] = decoded[0][i] << 16 | decoded[1][i] << 8 | decoded[2][i];
        }
        return image;
    }

    private int[][] getRawPixelArray() throws IOException {
        int[][] outputRef;
        int scanNum = 0;
        int[] pred = new int[10];
        this.xLoc = 0;
        this.yLoc = 0;
        int current = this.reader.getU16();
        if (current != 65496) {
            throw new IOException("Not a JPEG file");
        }
        current = this.reader.getU16();
        while (current >> 4 != 4092 || current == 65476) {
            switch (current) {
                case 65476: {
                    this.hTable.read(this.reader, this.HuffTab);
                    break;
                }
                case 65484: {
                    throw new IOException("Arithmetic Decoding is not supported yet");
                }
                case 65499: {
                    this.qTable.read(this.reader, FIXED);
                    break;
                }
                case 65501: {
                    this.interRestart = this.readNumber();
                    break;
                }
                case 65534: {
                    this.skipComment();
                    break;
                }
                default: {
                    if (current >= 65504 && current <= 65519) {
                        this.readApp();
                        break;
                    }
                    if (current >> 8 == 255) break;
                    throw new IOException("Corrupted JPEGLossless Data");
                }
            }
            current = this.reader.getU16();
        }
        if (current < 65472 || current > 65479) {
            throw new IOException("Arithmetic Decoding is not supported yet");
        }
        this.frame.read(this.reader);
        current = this.reader.getU16();
        while (true) {
            if (current != 65498) {
                switch (current) {
                    case 65476: {
                        this.hTable.read(this.reader, this.HuffTab);
                        break;
                    }
                    case 65484: {
                        throw new IOException("Arithmetic Decoding is not supported yet");
                    }
                    case 65499: {
                        this.qTable.read(this.reader, FIXED);
                        break;
                    }
                    case 65501: {
                        this.interRestart = this.readNumber();
                        break;
                    }
                    case 65534: {
                        this.skipComment();
                        break;
                    }
                    default: {
                        if (current >= 65504 && current <= 65519) {
                            this.readApp();
                            break;
                        }
                        if (current >> 8 == 255) break;
                        throw new IOException("Invalid Marker Found");
                    }
                }
                current = this.reader.getU16();
                continue;
            }
            int precision = this.frame.precision;
            this.mask = precision == 8 ? 255 : 65535;
            Sampler[] components = this.frame.getSamples();
            this.scan.read(this.reader);
            this.nComp = this.scan.nComp;
            this.selection = this.scan.spectralStart;
            Component[] scanComps = this.scan.components;
            int[][] quantTables = this.qTable.qTables;
            for (int i = 0; i < this.nComp; ++i) {
                int compN = scanComps[i].lsComp;
                this.qTab[i] = quantTables[components[compN].qt];
                this.nBlock[i] = components[compN].v * components[compN].h;
                this.dcTab[i] = this.HuffTab[scanComps[i].lsDC][0];
                this.acTab[i] = this.HuffTab[scanComps[i].lsAC][1];
            }
            this.iw = this.frame.width;
            this.ih = this.frame.height;
            outputRef = new int[this.nComp][];
            if (this.nComp == 1) {
                this.samples = new int[this.iw * this.ih];
                outputRef[0] = this.samples;
            } else {
                this.samplesR = new int[this.iw * this.ih];
                this.samplesG = new int[this.iw * this.ih];
                this.samplesB = new int[this.iw * this.ih];
                outputRef[0] = this.samplesR;
                outputRef[1] = this.samplesG;
                outputRef[2] = this.samplesB;
            }
            ++scanNum;
            do {
                int[] temp = new int[1];
                int[] index = new int[1];
                temp[0] = 0;
                index[0] = 0;
                for (int i = 0; i < 10; ++i) {
                    pred[i] = 1 << precision - 1;
                }
                if (this.interRestart == 0) {
                    current = this.decodeNComp(pred, temp, index);
                    while (current == 0 && this.xLoc < this.iw && this.yLoc < this.ih) {
                        this.output(pred);
                        current = this.decodeNComp(pred, temp, index);
                    }
                    break;
                }
                for (int mcuNum = 0; mcuNum < this.interRestart; ++mcuNum) {
                    this.isRestart = mcuNum == 0;
                    current = this.decodeNComp(pred, temp, index);
                    this.output(pred);
                    if (current != 0) break;
                }
                if (current != 0) continue;
                if (this.mIndex != 0) {
                    current = 0xFF00 | this.marker;
                    this.mIndex = 0;
                    continue;
                }
                current = this.reader.getU16();
            } while (current >= 65488 && current <= 65495);
            if (current == 65500 && scanNum == 1) {
                this.readNumber();
                current = this.reader.getU16();
            }
            if (current == 65497 || this.xLoc >= this.iw || this.yLoc >= this.ih || scanNum != 0) break;
        }
        return outputRef;
    }

    private int decodeNComp(int[] prev, int[] temp, int[] index) throws IOException {
        switch (this.nComp) {
            case 1: {
                return this.decode1Comp(prev, temp, index);
            }
            case 3: {
                return this.decode3Comp(prev, temp, index);
            }
        }
        return -1;
    }

    private int decode1Comp(int[] prev, int[] temp, int[] index) throws IOException {
        if (this.isRestart) {
            this.isRestart = false;
            prev[0] = 1 << this.frame.precision - 1;
        } else {
            switch (this.selection) {
                case 2: {
                    prev[0] = this.getPrevY(this.samples);
                    break;
                }
                case 3: {
                    prev[0] = this.getPrevXY(this.samples);
                    break;
                }
                case 4: {
                    prev[0] = this.getPrevX(this.samples) + this.getPrevY(this.samples) - this.getPrevXY(this.samples);
                    break;
                }
                case 5: {
                    prev[0] = this.getPrevX(this.samples) + (this.getPrevY(this.samples) - this.getPrevXY(this.samples) >> 1);
                    break;
                }
                case 6: {
                    prev[0] = this.getPrevY(this.samples) + (this.getPrevX(this.samples) - this.getPrevXY(this.samples) >> 1);
                    break;
                }
                case 7: {
                    prev[0] = (int)(((long)this.getPrevX(this.samples) + (long)this.getPrevY(this.samples)) / 2L);
                    break;
                }
                default: {
                    prev[0] = this.getPrevX(this.samples);
                }
            }
        }
        for (int i = 0; i < this.nBlock[0]; ++i) {
            int value = this.getHuffmanValue(this.dcTab[0], temp, index);
            if (value >= 65280) {
                return value;
            }
            int n = this.getN(prev, value, temp, index);
            int nrs = n >> 8;
            if (nrs >= 65488 && nrs <= 65495) {
                return nrs;
            }
            prev[0] = prev[0] + n;
        }
        return 0;
    }

    private int decode3Comp(int[] prev, int[] temp, int[] index) throws IOException {
        switch (this.selection) {
            case 2: {
                prev[0] = this.getPrevY(this.samplesR);
                prev[1] = this.getPrevY(this.samplesG);
                prev[2] = this.getPrevY(this.samplesB);
                break;
            }
            case 3: {
                prev[0] = this.getPrevXY(this.samplesR);
                prev[1] = this.getPrevXY(this.samplesG);
                prev[2] = this.getPrevXY(this.samplesB);
                break;
            }
            case 4: {
                prev[0] = this.getPrevX(this.samplesR) + this.getPrevY(this.samplesR) - this.getPrevXY(this.samplesR);
                prev[1] = this.getPrevX(this.samplesG) + this.getPrevY(this.samplesG) - this.getPrevXY(this.samplesG);
                prev[2] = this.getPrevX(this.samplesB) + this.getPrevY(this.samplesB) - this.getPrevXY(this.samplesB);
                break;
            }
            case 5: {
                prev[0] = this.getPrevX(this.samplesR) + (this.getPrevY(this.samplesR) - this.getPrevXY(this.samplesR) >> 1);
                prev[1] = this.getPrevX(this.samplesG) + (this.getPrevY(this.samplesG) - this.getPrevXY(this.samplesG) >> 1);
                prev[2] = this.getPrevX(this.samplesB) + (this.getPrevY(this.samplesB) - this.getPrevXY(this.samplesB) >> 1);
                break;
            }
            case 6: {
                prev[0] = this.getPrevY(this.samplesR) + (this.getPrevX(this.samplesR) - this.getPrevXY(this.samplesR) >> 1);
                prev[1] = this.getPrevY(this.samplesG) + (this.getPrevX(this.samplesG) - this.getPrevXY(this.samplesG) >> 1);
                prev[2] = this.getPrevY(this.samplesB) + (this.getPrevX(this.samplesB) - this.getPrevXY(this.samplesB) >> 1);
                break;
            }
            case 7: {
                prev[0] = (int)(((long)this.getPrevX(this.samplesR) + (long)this.getPrevY(this.samplesR)) / 2L);
                prev[1] = (int)(((long)this.getPrevX(this.samplesG) + (long)this.getPrevY(this.samplesG)) / 2L);
                prev[2] = (int)(((long)this.getPrevX(this.samplesB) + (long)this.getPrevY(this.samplesB)) / 2L);
                break;
            }
            default: {
                prev[0] = this.getPrevX(this.samplesR);
                prev[1] = this.getPrevX(this.samplesG);
                prev[2] = this.getPrevX(this.samplesB);
            }
        }
        for (int ctrC = 0; ctrC < this.nComp; ++ctrC) {
            int[] qtab = this.qTab[ctrC];
            int[] actab = this.acTab[ctrC];
            int[] dctab = this.dcTab[ctrC];
            block9: for (int i = 0; i < this.nBlock[ctrC]; ++i) {
                for (int k = 0; k < this.sIDCT.length; ++k) {
                    this.sIDCT[k] = 0;
                }
                int value = this.getHuffmanValue(dctab, temp, index);
                if (value >= 65280) {
                    return value;
                }
                prev[ctrC] = this.sIDCT[0] = prev[ctrC] + this.getN(index, value, temp, index);
                this.sIDCT[0] = this.sIDCT[0] * qtab[0];
                for (int j = 1; j < 64; ++j) {
                    value = this.getHuffmanValue(actab, temp, index);
                    if (value >= 65280) {
                        return value;
                    }
                    j += value >> 4;
                    if ((value & 0xF) == 0) {
                        if (value >> 4 != 0) continue;
                        continue block9;
                    }
                    this.sIDCT[JpegLosslessDecoder.POINTERS[j]] = this.getN(index, value & 0xF, temp, index) * qtab[j];
                }
            }
        }
        return 0;
    }

    private int getHuffmanValue(int[] table, int[] temp, int[] index) throws IOException {
        int input;
        int maski = 65535;
        if (index[0] < 8) {
            temp[0] = temp[0] << 8;
            input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
        } else {
            index[0] = index[0] - 8;
        }
        int code = table[temp[0] >> index[0]];
        if ((code & Integer.MIN_VALUE) != 0) {
            if (this.mIndex != 0) {
                this.mIndex = 0;
                return 0xFF00 | this.marker;
            }
            temp[0] = temp[0] & 65535 >> 16 - index[0];
            temp[0] = temp[0] << 8;
            input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
            code = table[(code & 0xFF) * 256 + (temp[0] >> index[0])];
            index[0] = index[0] + 8;
        }
        index[0] = index[0] + (8 - (code >> 8));
        if (index[0] < 0) {
            throw new IOException("Huffman decoding error");
        }
        if (index[0] < this.mIndex) {
            this.mIndex = 0;
            return 0xFF00 | this.marker;
        }
        temp[0] = temp[0] & 65535 >> 16 - index[0];
        return code & 0xFF;
    }

    private int getN(int[] PRED, int n, int[] temp, int[] index) throws IOException {
        int nn;
        boolean one = true;
        int n_one = -1;
        int maski = 65535;
        if (n == 0) {
            return 0;
        }
        if (n == 16) {
            if (PRED[0] >= 0) {
                return Short.MIN_VALUE;
            }
            return 32768;
        }
        index[0] = index[0] - n;
        if (index[0] >= 0) {
            if (index[0] < this.mIndex && !this.isEndPix()) {
                this.mIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            nn = temp[0] >> index[0];
            temp[0] = temp[0] & 65535 >> 16 - index[0];
        } else {
            temp[0] = temp[0] << 8;
            int input = this.reader.getU8();
            if (input == 255) {
                this.marker = this.reader.getU8();
                if (this.marker != 0) {
                    this.mIndex = 9;
                }
            }
            temp[0] = temp[0] | input;
            index[0] = index[0] + 8;
            if (index[0] < 0) {
                if (this.mIndex != 0) {
                    this.mIndex = 0;
                    return (0xFF00 | this.marker) << 8;
                }
                temp[0] = temp[0] << 8;
                input = this.reader.getU8();
                if (input == 255) {
                    this.marker = this.reader.getU8();
                    if (this.marker != 0) {
                        this.mIndex = 9;
                    }
                }
                temp[0] = temp[0] | input;
                index[0] = index[0] + 8;
            }
            if (index[0] < 0) {
                throw new IOException("Decoding jpeglossless stream error");
            }
            if (index[0] < this.mIndex) {
                this.mIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            nn = temp[0] >> index[0];
            temp[0] = temp[0] & 65535 >> 16 - index[0];
        }
        if (nn < 1 << n - 1) {
            nn += (-1 << n) + 1;
        }
        return nn;
    }

    private int getPrevX(int[] data) {
        if (this.xLoc > 0) {
            return data[this.yLoc * this.iw + this.xLoc - 1];
        }
        if (this.yLoc > 0) {
            return this.getPrevY(data);
        }
        return 1 << this.frame.precision - 1;
    }

    private int getPrevXY(int[] data) {
        if (this.xLoc > 0 && this.yLoc > 0) {
            return data[(this.yLoc - 1) * this.iw + this.xLoc - 1];
        }
        return this.getPrevY(data);
    }

    private int getPrevY(int[] data) {
        if (this.yLoc > 0) {
            return data[(this.yLoc - 1) * this.iw + this.xLoc];
        }
        return this.getPrevX(data);
    }

    private boolean isEndPix() {
        return this.xLoc == this.iw - 1 && this.yLoc == this.ih - 1;
    }

    private void output(int[] PRED) {
        if (this.nComp == 1) {
            this.outputSingle(PRED);
        } else {
            this.outputRGB(PRED);
        }
    }

    private void outputSingle(int[] PRED) {
        if (this.xLoc < this.iw && this.yLoc < this.ih) {
            this.samples[this.yLoc * this.iw + this.xLoc] = this.mask & PRED[0];
            ++this.xLoc;
            if (this.xLoc >= this.iw) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void outputRGB(int[] PRED) {
        if (this.xLoc < this.iw && this.yLoc < this.ih) {
            this.samplesR[this.yLoc * this.iw + this.xLoc] = PRED[0];
            this.samplesG[this.yLoc * this.iw + this.xLoc] = PRED[1];
            this.samplesB[this.yLoc * this.iw + this.xLoc] = PRED[2];
            ++this.xLoc;
            if (this.xLoc >= this.iw) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void readApp() throws IOException {
        int count = 0;
        int length = this.reader.getU16();
        count += 2;
        while (count < length) {
            this.reader.getU8();
            ++count;
        }
    }

    private void skipComment() throws IOException {
        int count = 0;
        int length = this.reader.getU16();
        count += 2;
        while (count < length) {
            this.reader.getU8();
            ++count;
        }
    }

    private int readNumber() throws IOException {
        int Ld = this.reader.getU16();
        if (Ld != 4) {
            throw new IOException("Invalid number symbol found");
        }
        return this.reader.getU16();
    }
}

